#!/usr/local/bin/perl
#  wrapper.pl - a command parsing wrapper for the cbb 'engine'.
#
#  Written by Curtis Olson.  Started August 22, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: wrapper.pl,v 1.9 1995/02/23 05:13:14 curt Exp $
# (Log is kept at end of this file)


# specify the installed location of the necessary pieces.
$cbb_incl_dir = ".";
unshift(@INC, $cbb_incl_dir);


$logging = 1;			# 0 = off,  1 = on
$debug = 1;			# 0 = off,  1 = on


require "engine.pl";
require "categories.pl";
require "memorized.pl";	
require "import.pl";
require "export.pl";
require "reports.pl";


# main command parsing loop
while (<>) {
    chop;

    print DEBUG "Command string:  '$_'\n" if $debug;

    if ( m/ / ) {
	($command, $arg) = split(/ /, $_, 2);
    } else {
	($command, $arg) = ($_, "");
    }

    if ($command eq "create_trans") {
	print DEBUG "calling create_trans($arg)\n" if $debug;
	print &create_trans($arg)."\n";
    } elsif ($command eq "create_xfer") {
	print DEBUG "calling create_xfer($arg)\n" if $debug;
	print &create_xfer($arg)."\n";
    } elsif ($command eq "update_trans") {
	print DEBUG "calling update_trans($arg)\n" if $debug;
	print &update_trans($arg)."\n";
    } elsif ($command eq "delete_trans") {
	print DEBUG "calling delete_trans($arg)\n" if $debug;
	print &delete_trans($arg)."\n";
    } elsif ($command eq "next_trans") {
	print DEBUG "next_trans()\n" if $debug;
	print &next_trans()."\n";
    } elsif ($command eq "prev_trans") {
	print "prev_trans()\n";
    } elsif ($command eq "find_trans") {
	print DEBUG "find_trans($arg)\n" if $debug;
	print &find_trans($arg)."\n";
    } elsif ($command eq "get_current_index") {
	print DEBUG "get_current_index()\n" if $debug;
	print &get_current_index()."\n";
    } elsif ($command eq "first_trans") {
	print DEBUG "first_trans()\n" if $debug;
	print &first_trans()."\n";
    } elsif ($command eq "all_trans") {
	print DEBUG "all_trans()\n" if $debug;
	print &all_trans()."\n";
    } elsif ($command eq "last_trans") {
	print "last_trans()\n";
    } elsif ($command eq "first_uncleared_trans") {
	print DEBUG "first_uncleared_trans()\n" if $debug;
	print &first_uncleared_trans()."\n";
    } elsif ($command eq "last_uncleared_trans") {
	print "last_uncleared_trans()\n";
    } elsif ($command eq "next_uncleared_trans") {
	print DEBUG "next_uncleared_trans()\n" if $debug;
	print &next_uncleared_trans()."\n";
    } elsif ($command eq "prev_uncleared_trans") {
	print "prev_uncleared_trans()\n";
    } elsif ($command eq "select_trans") {
	print DEBUG "select_trans()\n" if $debug;
	print &select_trans($arg)."\n";
    } elsif ($command eq "unselect_trans") {
	print DEBUG "unselect_trans()\n" if $debug;
	print &unselect_trans($arg)."\n";
    } elsif ($command eq "clear_trans") {
	print DEBUG "clear_trans()\n" if $debug;
	print &clear_trans()."\n";
    } elsif ($command eq "get_cleared_bal") {
	print DEBUG "get_cleared_bal()\n" if $debug;
	print &get_cleared_bal()."\n";
    } elsif ($command eq "sort_trans") {
	print "sort_trans()\n";
    } elsif ($command eq "init_trans") {
	print DEBUG "calling init_trans()\n" if $debug;
	print &init_trans()."\n";
    } elsif ($command eq "make_acct") {
	print DEBUG "calling make_acct($arg)\n" if $debug;
	print &make_acct($arg)."\n";
    } elsif ($command eq "load_trans") {
	print DEBUG "calling load_trans($arg)\n" if $debug;
	print &load_trans($arg)."\n";
    } elsif ($command eq "import_old_cbb") {
	print DEBUG "calling import_old_cbb($arg)\n" if $debug;
	print &import_old_cbb($arg)."\n";
    } elsif ($command eq "import_qif") {
	print DEBUG "calling import_qif($arg)\n" if $debug;
	print &import_qif($arg)."\n";
    } elsif ($command eq "export_old_cbb") {
	print DEBUG "calling export_old_cbb($arg)\n" if $debug;
	print &export_old_cbb($arg)."\n";
    } elsif ($command eq "export_qif") {
	print DEBUG "calling export_qif($arg)\n" if $debug;
	print &export_qif($arg)."\n";
    } elsif ($command eq "save_trans") {
	print DEBUG "calling save_trans($arg)\n" if $debug;
	print &save_trans($arg)."\n";
    } elsif ($command eq "rehash_mems") {
	print DEBUG "calling rehash_mems()\n" if $debug;
	print &rehash_mems()."\n";
    } elsif ($command eq "find_mem") {
	print DEBUG "calling find_mem($arg)\n" if $debug;
	print &find_mem($arg)."\n";
    } elsif ($command eq "init_cats") {
	print DEBUG "calling init_cats()\n" if $debug;
	print &init_cats()."\n";
    } elsif ($command eq "edit_cat") {
	print DEBUG "calling edit_cat($arg)\n" if $debug;
	print &edit_cat($arg)."\n";
    } elsif ($command eq "insert_cat") {
	print DEBUG "calling insert_cat($arg)\n" if $debug;
	print &insert_cat($arg)."\n";
    } elsif ($command eq "delete_cat") {
	print DEBUG "calling delete_cat($arg)\n" if $debug;
	print &delete_cat($arg)."\n";
    } elsif ($command eq "all_cats") {
	print DEBUG "calling all_cats()\n";
        print &all_cats()."\n";
    } elsif ($command eq "find_cat") {
	print DEBUG "calling find_cat($arg)\n";
        print &find_cat($arg)."\n";
    } elsif ($command eq "import_cats") {
	print DEBUG "calling import_cats($arg)\n" if $debug;
	print &import_cats($arg)."\n";
    } elsif ($command eq "load_cats") {
	print DEBUG "calling load_cats($arg)\n" if $debug;
	print &load_cats($arg)."\n";
    } elsif ($command eq "save_cats") {
	print DEBUG "calling save_cats($arg)\n" if $debug;
	print &save_cats($arg)."\n";
    } elsif ($command eq "rep_txn_list") {
	print DEBUG "calling rep_txn_list($arg)\n" if $debug;
	print &rep_txn_list($arg)."\n"
    } elsif ($command eq "rep_txn_by_cat") {
	print DEBUG "calling rep_txn_by_cat($arg)\n" if $debug;
	print &rep_txn_by_cat($arg)."\n"
    } elsif ($command eq "rep_txn_by_cat_short") {
	print DEBUG "calling rep_txn_by_cat_short($arg)\n" if $debug;
	print &rep_txn_by_cat_short($arg)."\n"
    } elsif ($command eq "nice_date") {
	print DEBUG "calling nice_date()\n" if $debug;
	print &nice_date()."\n"
    } elsif ($command eq "raw_date") {
	print DEBUG "calling raw_date()\n" if $debug;
	print &raw_date()."\n"
    } elsif ($command eq "quit") {
	print DEBUG "exiting\n" if $debug;
	exit(0);
    } else {
	# unknown command ... return error
	print DEBUG "unknown command\n" if $debug;
	print "error\n";
    }
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: wrapper.pl,v $
# Revision 1.9  1995/02/23  05:13:14  curt
# Removed dependencies on tclX (wishx).
#
# Revision 1.8  1994/12/20  02:44:21  curt
# Added a "by category summary report"
#
# Revision 1.7  1994/11/28  18:55:34  clolson
# Added reports.pl & reports.tk
#
# Revision 1.6  1994/11/07  23:13:58  clolson
# Working on interactive category viewing/editing
#
# Revision 1.5  1994/11/04  19:33:05  clolson
# Added Transfers between Accounts.
#
# Revision 1.4  1994/11/02  12:58:41  curt
# Calculate the statement starting balance for the Balance operation.
#
# Revision 1.3  1994/11/01  22:39:20  clolson
# Added log.pl --> implemented logging.
# Worked on install script.
#
# Revision 1.2  1994/10/31  23:14:53  clolson
# Started tracking towards cbbsh (the text only version).  Chris Browne has
# some good ideas, so I am trying to incorperate them, and make my stuff
# compatible with his.
#
# Revision 1.1  1994/10/31  15:18:53  curt
# These files resulted from the splitting of engine.pl
#
