diff -C 5 oleo-1.6/basic.c oleo-1.6.1/basic.c
*** oleo-1.6/basic.c	Sat Jun  4 01:04:54 1994
--- oleo-1.6.1/basic.c	Wed Feb 15 21:06:53 1995
***************
*** 154,163 ****
--- 154,230 ----
    to.lc = cucol + repeat;
    to.hc = cucol + repeat;
    move_region (&from, &to);
  }
  
+ /* Inserts new rows below the current row, that are a copy of the current
+    row.  Uses insert_row and copy_region.
+ */
+ #ifdef __STDC__
+ void
+ insert_copy_row (int repeat)
+ #else
+ void
+ insert_copy_row (repeat)
+      int repeat;
+ #endif
+ {
+   struct rng from, to;
+ 
+   if ((repeat > (MAX_ROW - curow)) || (repeat < 0))
+   {
+     io_error_msg ("insert-copy-row: prefix argument out of range.");
+     return;
+   }
+ 
+   from.lr = curow + repeat;
+   from.hr = curow + repeat;
+   from.lc = MIN_COL;
+   from.hc = MAX_COL;
+   to.lr   = curow;
+   to.hr   = curow + repeat - 1;
+   to.lc   = MIN_COL;
+   to.hc   = MAX_COL;
+   
+   insert_row(repeat);
+   copy_region(&from, &to);
+ }
+ 
+ 
+ /* Inserts new columns to the right of the current column, that are a
+    copy of the current column. Uses insert_col and copy_region.
+ */
+ #ifdef __STDC__
+ void
+ insert_copy_col (int repeat)
+ #else
+ void
+ insert_copy_col (repeat)
+      int repeat;
+ #endif
+ {
+   struct rng from, to;
+   
+   if ((repeat > (MAX_COL - cucol)) || (repeat < 0))
+       {
+         io_error_msg ("insert-copy-col: prefix argument out of range.");
+         return;
+       }
+ 
+    from.lc = cucol + repeat;
+    from.hc = cucol + repeat;
+    from.lr = MIN_ROW;
+    from.hr = MAX_ROW;
+    to.lc   = cucol;
+    to.hc   = cucol + repeat - 1;
+    to.lr   = MIN_ROW;
+    to.hr   = MAX_ROW;
+ 
+    insert_col(repeat);
+    copy_region(&from, &to);
+ }
+ 
  #ifdef __STDC__
  void
  delete_row (int repeat)
  #else
  void
Only in oleo-1.6.1: basic.c.orig
diff -C 5 oleo-1.6/basic.h oleo-1.6.1/basic.h
*** oleo-1.6/basic.h	Fri Jun  3 12:17:30 1994
--- oleo-1.6.1/basic.h	Wed Feb 15 21:06:53 1995
***************
*** 41,50 ****
--- 41,52 ----
  
  #ifdef __STDC__
  extern void noop (void);
  extern void insert_row (int repeat);
  extern void insert_col (int repeat);
+ extern void insert_copy_row (int repeat);
+ extern void insert_copy_col (int repeat);
  extern void delete_row (int repeat);
  extern void delete_col (int repeat);
  extern void open_window (char *text);
  extern void hsplit_window (void);
  extern void vsplit_window (void);
Only in oleo-1.6.1: basic.h.orig
diff -C 5 oleo-1.6/configure oleo-1.6.1/configure
*** oleo-1.6/configure	Sat Jun  4 01:26:18 1994
--- oleo-1.6.1/configure	Wed Feb 15 21:16:27 1995
***************
*** 1155,1165 ****
--- 1155,1242 ----
  
  done
  
  fi
  
+ # The curses library for Linux is buggy, so if using Linux, use ncurses
+ # instead.
+ use_ncurses=""
+ 
+ if [ "`uname -s`" = "Linux" ]; then
  LIBS_save="${LIBS}"
+ LIBS="${LIBS} -lncurses"
+ have_lib=""
+ echo checking for -lncurses
+ cat > conftest.c <<EOF
+ #include "confdefs.h"
+ 
+ int main() { exit(0); }
+ int t() { main(); }
+ EOF
+ if eval $compile; then
+   rm -rf conftest*
+   have_lib="1"
+ fi
+ rm -f conftest*
+ LIBS="${LIBS_save}"
+ if test -n "${have_lib}"; then
+    use_ncurses="1"
+   :; wlibs="$wlibs -lncurses"
+    echo "(adding -lncurses to wlibs)"
+    test -n "$verbose" && \
+    echo " defining USE_NCURSES"
+    echo "#define" USE_NCURSES 1 >> confdefs.h
+    DEFS="$DEFS -DUSE_NCURSES=1"
+ 
+    echo checking for ncurses.h
+    cat > conftest.c <<EOF
+ #include "confdefs.h"
+ #include <ncurses.h>
+ EOF
+    err=`eval "($CPP conftest.c >/dev/null) 2>&1"`
+    if test -z "$err"; then
+      rm -rf conftest*
+      test -n "$verbose" && \
+      echo " defining HAVE_NCURSES_H1"
+      echo "#define" HAVE_NCURSES_H1 1 >> confdefs.h
+      DEFS="$DEFS -DHAVE_NCURSES_H1=1"
+    else
+    rm -f conftest*
+    echo checking for ncurses/ncurses.h
+    cat > conftest.c <<EOF
+ #include "confdefs.h"
+ #include <ncurses/ncurses.h>
+ EOF
+    err=`eval "($CPP conftest.c >/dev/null) 2>&1"`
+    if test -z "$err"; then
+      rm -rf conftest*
+      test -n "$verbose" && \
+      echo " defining HAVE_NCURSES_H2"
+      echo "#define" HAVE_NCURSES_H2 1 >> confdefs.h
+      DEFS="$DEFS -DHAVE_NCURSES_H2=1"
+    else
+      rm -f conftest*
+      echo "#define" HAVE_CURSES_H 1 >> confdefs.h
+      DEFS="$DEFS -DHAVE_CURSES_H=1"
+    fi                            # if test -z
+    fi                    # if test -z
+ fi   # if test -n "${have_lib}"
+  # some people said they had to set HAVE_X11R4, even if they didn't have it.
+  # for Linux.  Don't know why because I don't have X.
+  if test -z "$no_x"; then  
+    echo "#define" HAVE_X11R4 1 >> confdefs.h
+    DEFS="$DEFS -DHAVE_X11R4"
+  fi  
+ fi   # if [ "`uname -s`"
+ 
+ 
+ if test -z "$use_ncurses"; then
+ 
+ echo "#define" HAVE_CURSES_H 1 >> confdefs.h
+ DEFS="$DEFS -DHAVE_CURSES_H"
+   
+ LIBS_save="${LIBS}"
  LIBS="${LIBS} -ltermcap"
  have_lib=""
  echo checking for -ltermcap
  cat > conftest.c <<EOF
  #include "confdefs.h"
***************
*** 1204,1213 ****
--- 1281,1291 ----
  				LIBS="$LIBS -lcurses"
  fi
  
  fi
  
+ fi  # if test -z "$use_ncurses"
  
  LIBS_save="${LIBS}"
  LIBS="${LIBS} -lmisc"
  have_lib=""
  echo checking for -lmisc
Only in oleo-1.6.1: configure.orig
diff -C 5 oleo-1.6/defun.h oleo-1.6.1/defun.h
*** oleo-1.6/defun.h	Sat Jun  4 01:13:39 1994
--- oleo-1.6.1/defun.h	Wed Feb 15 21:06:56 1995
***************
*** 5,15 ****
  #ifdef FUNC_ARG_STRINGS
  "sEnter string for %c? ",
  #endif
  #ifdef DOC_STRINGS
  "Quote STRING appropriately and store it in the current cell.",
! "Called interactively, this is a way to store a string in a cell without",
  "having to enclose it in quotes.",
  #endif
  #endif /* NOT USED */
  
  /* squeek squeek */
--- 5,16 ----
  #ifdef FUNC_ARG_STRINGS
  "sEnter string for %c? ",
  #endif
  #ifdef DOC_STRINGS
  "Quote STRING appropriately and store it in the current cell.",
! "Called interactively, this is a way to store a string in a cell
! without",
  "having to enclose it in quotes.",
  #endif
  #endif /* NOT USED */
  
  /* squeek squeek */
***************
*** 16,28 ****
  DEFUN_3 ("mouse-goto", FDmouse_goto, mouse_goto_cmd)
  DEFUN_3 ("mouse-mark", FDmouse_mark, mouse_mark_cmd)
  DEFUN_3 ("mouse-mark-and-goto",
  	 FDmouse_mark_and_goto_cmd, mouse_mark_and_goto_cmd)
  
! #if 0
! DEFUN ("sort-region", "tj", sort_region_cmd)
  #endif
      
  
  
  
  DEFUN_3 ("exit-minibuffer", FDexit_minibuffer, exit_minibuffer)
--- 17,37 ----
  DEFUN_3 ("mouse-goto", FDmouse_goto, mouse_goto_cmd)
  DEFUN_3 ("mouse-mark", FDmouse_mark, mouse_mark_cmd)
  DEFUN_3 ("mouse-mark-and-goto",
  	 FDmouse_mark_and_goto_cmd, mouse_mark_and_goto_cmd)
  
! #if 1
! DEFUN ("sort-region", FDsort_region_cmd, FAsort_region_cmd,
!         sort_region_cmd)
! #ifdef FUNC_ARG_STRINGS
! "SSort region? ",
  #endif
+ #ifdef DOC_STRINGS
+ "Sort a row or column of cells.",
+ #endif
+ 
+ #endif
      
  
  
  
  DEFUN_3 ("exit-minibuffer", FDexit_minibuffer, exit_minibuffer)
***************
*** 846,855 ****
--- 855,882 ----
  #ifdef FUNC_ARG_STRINGS
  "+p",
  #endif
  #ifdef DOC_STRINGS
  "Insert ARG empty cols.",
+ #endif
+ 
+ DEFUN ("insert-copy-row", FDinsert_copy_row, FAinsert_copy_row,
+        insert_copy_row)
+ #ifdef FUNC_ARG_STRINGS
+ "+p",
+ #endif
+ #ifdef DOC_STRINGS
+ "Insert ARG copies of the current row, below the current row.",
+ #endif
+ 
+ DEFUN ("insert-copy-col", FDinsert_copy_col, FAinsert_copy_col,
+        insert_copy_col)
+ #ifdef FUNC_ARG_STRINGS
+ "+p",
+ #endif
+ #ifdef DOC_STRINGS
+ "Insert ARG copies of the current column, to the right of the current column.",
  #endif
  
  DEFUN ("delete-row", FDdelete_row, FAdelete_row, delete_row)
  #ifdef FUNC_ARG_STRINGS
  "+p",
Only in oleo-1.6.1: defun.h.orig
diff -C 5 oleo-1.6/forminfo.c oleo-1.6.1/forminfo.c
*** oleo-1.6/forminfo.c	Fri Jun  3 12:18:30 1994
--- oleo-1.6.1/forminfo.c	Wed Feb 15 21:06:58 1995
***************
*** 1217,1229 ****
--- 1217,1233 ----
  "		     Operations on entire regions",
  "",
  "Copy region		[copy-region]",
  "Copy values in region	[copy-values-in-region]",
  "Move region		[move-region]",
+ "Sort region            [sort-region]",
  "",
  "Insert row		[insert-row]",
  "Insert col		[insert-col]",
+ "",
+ "Insert copy row        [insert-copy-row]",
+ "Insert copy col        [insert-copy-col]",
  "",
  "Delete row		[delete-row]",
  "Delete col		[delete-col]",
  "",
  "Delete region		[delete-region]",
Only in oleo-1.6.1: forminfo.c.orig
diff -C 5 oleo-1.6/init.c oleo-1.6.1/init.c
*** oleo-1.6/init.c	Sat Jun  4 01:00:41 1994
--- oleo-1.6.1/init.c	Wed Feb 15 21:07:01 1995
***************
*** 243,252 ****
--- 243,254 ----
    "bind-key meta copy-region c",
    "bind-key meta copy-values-in-region ^c",
    "bind-key meta move-region m",
    "bind-key main insert-row ^o",
    "bind-key meta insert-col o",
+   "bind-key meta insert-copy-row ^r",
+   "bind-key meta insert-copy-col ^o",
    "bind-key main delete-row ^k",
    "bind-key meta delete-col k",
    "",
    "# Changing cell formulas",
    "bind-key main set-cell =",
Only in oleo-1.6.1: init.c.orig
diff -C 5 oleo-1.6/io-curses.c oleo-1.6.1/io-curses.c
*** oleo-1.6/io-curses.c	Fri Jun  3 12:19:22 1994
--- oleo-1.6.1/io-curses.c	Wed Feb 15 21:07:04 1995
***************
*** 16,26 ****
  
  
  #include "proto.h"
  #include "funcdef.h"
  #include <stdio.h>
! #include <curses.h>
  #include <fcntl.h>
  #include <errno.h>
  #include <ctype.h>
  #include <signal.h>
  #undef NULL
--- 16,34 ----
  
  
  #include "proto.h"
  #include "funcdef.h"
  #include <stdio.h>
! #ifdef HAVE_NUCRSES_H1
! # include <ncurses.h>
! #endif
! #ifdef HAVE_NCURSES_H2
! # include <ncurses/curses.h>
! #endif
! #ifdef HAVE_CURSES_H
! # include <curses.h>
! #endif
  #include <fcntl.h>
  #include <errno.h>
  #include <ctype.h>
  #include <signal.h>
  #undef NULL
***************
*** 42,51 ****
--- 50,64 ----
  #include "info.h"
  
  #define MIN_WIN_HEIGHT	(cwin->flags&WIN_EDGES ? 2 : 1)
  #define MIN_WIN_WIDTH	(cwin->flags&WIN_EDGES ? 6 : 1)
  
+ #ifdef USE_NCURSES
+ # undef A_STANDOUT
+ # define A_STANDOUT A_REVERSE
+ #endif
+ 
  static int redrew = 0;
  static int textout = 0;
  static int term_cursor_claimed = 0;
  
  #ifdef __STDC__
***************
*** 252,269 ****
      cell_cursor_row += get_height (rr);
    cwid = get_width (cucol);
    if (cwid > cwin->numc)
      cwid = cwin->numc;
    move (cell_cursor_row, cell_cursor_col);
    standout ();
    for (n = cwid; n; n--)
  #ifdef A_STANDOUT
      addch (inch () | A_STANDOUT);
  #else
!     addch (inch ());
  #endif
    standend ();
    move (y, x);
  }
  
  #ifdef __STDC__
  static void 
--- 265,286 ----
      cell_cursor_row += get_height (rr);
    cwid = get_width (cucol);
    if (cwid > cwin->numc)
      cwid = cwin->numc;
    move (cell_cursor_row, cell_cursor_col);
+ #ifndef USE_NCURSES
    standout ();
+ #endif
    for (n = cwid; n; n--)
  #ifdef A_STANDOUT
      addch (inch () | A_STANDOUT);
  #else
!     addch (inch () );
  #endif
+ #ifndef USE_NCURSES
    standend ();
+ #endif
    move (y, x);
  }
  
  #ifdef __STDC__
  static void 
Only in oleo-1.6.1: io-curses.c.orig
Only in oleo-1.6.1: oleo.pat2
diff -C 5 oleo-1.6/window.c oleo-1.6.1/window.c
*** oleo-1.6/window.c	Fri Jun  3 12:21:45 1994
--- oleo-1.6.1/window.c	Wed Feb 15 21:07:08 1995
***************
*** 28,37 ****
--- 28,42 ----
  int scr_lines = 24;
  int scr_cols = 80;
  #define LINES scr_lines
  #define COLS scr_cols
  
+ #ifdef USE_NCURSES
+ # undef wstandout
+ # define wstandout(win)   (wattrset(win, A_REVERSE))
+ #endif
+ 
  
  /* These control the layout of input and status lines. */
  int user_input = 1;		/* As specified (+/- [0-2]). */
  int user_status = 2;
  int input = 0;			/* As row address. */
Only in oleo-1.6.1: window.c.orig
