################################################################################
##  The basic class for a frame widget                                        ##  
##  LAST EDIT: Thu Aug  4 10:32:48 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

Tcl_Object IOM_Frame {} {xParent xupdateCMD} {Name} {String} { The created object has the {ARG 1 Name} and the widget has the name .{ARG 1 Name} .} {
    frame .$Name
    if [regsub {\.[^\.]*$} $Name {} parent] \
	    {set $THIS->xParent .$parent} {set $THIS->xParent .}
}

Tcl_Method IOM_Frame ~IOM_Frame {} {} {Destroy the frame widget} {
    destroy .$THIS
}

Tcl_Method IOM_Frame -pack {Options} {String} {Call the packer with the {ARG 1 Options} string and the parent of the frame.} {
    pack append [set $THIS->xParent] .$THIS $Options
}

Tcl_Method IOM_Frame -packT {} {} {Call the packer with the "top fill expand" options and the parent of the frame.} {
    
    $THIS -pack "top fill expand"
}

Tcl_Method IOM_Frame -packL {} {} {Call the packer with the "left fill expand" options and the parent of the frame.} {
    
    $THIS -pack "left fill expand"
}

Tcl_Method IOM_Frame -packR {} {} {Call the packer with the "right fill expand" options and the parent of the frame.} {
    
    $THIS -pack "right fill expand"
}

Tcl_Method IOM_Frame -packB {} {} {Call the packer with the "bottom fill expand" options and the parent of the frame.} {
    
    $THIS -pack "bottom fill expand"
}

Tcl_Method IOM_Frame -rborder {} {} {Build a 1 pixel raised border around the frame.} {
    .$THIS configure -border 1 -relief raised
}

Tcl_Method IOM_Frame -sborder {} {} {Build a 1 pixel sunken border around the frame.} {
    .$THIS configure -border 1 -relief sunken
}

Tcl_Method IOM_Frame -updateCMD Command String {Set the update command, to the object. This command is called after chancing one value of the widget.} {
    set $THIS->xupdateCMD $Command
}
Tcl_Method IOM_Frame -get_updateCMD "" "" {Get the update command.} {
    return [set $THIS->xupdateCMD ]
}

Tcl_Method IOM_Frame -callUpdateCMD "" "" {Call the update command. This method must be bound to the button, scales, entrys in the subclasses of frame. } {
    if [string length [set $THIS->xupdateCMD]] {
	uplevel #0 [set $THIS->xupdateCMD]
    }
}

IOM_Frame -description {This is the base of all utility widget classes for the tk interface.}
IOM_Frame -keywords {IOM User-Interface}
