################################################################################
##  Dialog box for tree widget.                                               ##  
##  LAST EDIT: Thu Aug  4 11:27:21 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

IOM_CmpTopBox ?

Tcl_Object IOM_SceneBox IOM_CmpTopBox {tree} {Name} {String } \
	{Creates a new interface box with the hierachie tree called {ARG 1 Name}.} {
    $THIS -buildCurrentObjectLabel
    wm title [set $THIS->tkTop] "IOM.scene"
    
    set path [set $THIS->frCenter]
    
    # cut the point at the begin of the widget name
    set tree [string range $path.tree 1 end]
    set $THIS->tree $tree
    
    # build the tree object
    IOM_Tree $tree
    $tree -bind
    $tree -addCB $THIS
    $THIS -addCB $tree
    
    $THIS -addMenuLeft select Select
    $THIS -addMenuEntry select "Select nodes with surface" "[set $THIS->tree] -selectNodesWithAttribute Surface"
    $THIS -addMenuEntry select "Select nodes with resolution" "[set $THIS->tree] -selectNodesWithAttribute Resolution"
    $THIS -addMenuEntry select "Select nodes with fillstyle" "[set $THIS->tree] -selectNodesWithAttribute Fillstyle"
    $THIS -addMenuSeparator select
    $THIS -addMenuEntry select "Show diffuse color" "[set $THIS->tree] -setBitmapColorToDiffuseValue"
    $THIS -addMenuEntry select "Show specular color" "[set $THIS->tree] -setBitmapColorToSpecularValue"
    $THIS -addMenuEntry select "Show emission color" "[set $THIS->tree] -setBitmapColorToEmissionValue"

    $THIS -addMenuLeft tree Treemode 

    # build the radiobuttons for the nodeSelectionMode
    # variable of the tree class
    $THIS -addMenuRadioButton tree "Select object if it is present." \
	    $tree->nodeSelectionMode selectIfItIsPreseent
    $THIS -addMenuRadioButton tree "Show the tree to the selected object." $tree->nodeSelectionMode showTreeToSelected
    $THIS -addMenuRadioButton tree "Show the complete tree to the selected object." $tree->nodeSelectionMode showCompleteTreeToSelected
    $THIS -addMenuRadioButton tree "Show the parent and the children of the selected object." $tree->nodeSelectionMode showNearowOfSelected
    
    # now put the rescan entry to the tree menu
    $THIS -addMenuSeparator options
    $THIS -addMenuEntry options "Show all trees" "$tree -buildCompleteTree"
    $THIS -addMenuEntry options "Toggle the layout" "$tree -toggleLayout"
    $THIS -addMenuEntry options "Rescan the top objects." "$tree -scanTopObjects"
    
    $THIS -addMenuLeft edit Edit
    $THIS -addMenuEntry edit "Set marked as new parent." "[set $THIS->tree] -setFather"
    $THIS -addMenuEntry edit "Delete selected objects." "[set $THIS->tree] -deleteSelectedObject"
    $THIS -addMenuSeparator edit 
    $THIS -addMenuEntry edit "Create the surface box" "[set $THIS->tree] -buildInterfaceDevice IOM_SurfaceBox surface"
    $THIS -addMenuEntry edit "Create the resolution box" "[set $THIS->tree] -buildInterfaceDevice IOM_ResolutionBox resolution"
    $THIS -addMenuEntry edit "Create the fillstyle box" "[set $THIS->tree] -buildInterfaceDevice IOM_FillstyleBox fillstyle"
    
    $THIS -addMenuSeparator edit 
    $THIS -addMenuEntry edit "Clear the surface" "[set $THIS->tree] -deleteAttributeOfSelected Surface"
    $THIS -addMenuEntry edit "Clear the resolution" "[set $THIS->tree] -deleteAttributeOfSelected Resolution"
    $THIS -addMenuEntry edit "Clear the fillstyle" "[set $THIS->tree] -deleteAttributeOfSelected Fillstyle"
    
    $THIS -addMenuSeparator edit 
    $THIS -addMenuEntry edit "Bitmap" "$THIS -editCurrentBitmap"
    
    # build the file menu:
    $THIS -addMenuLeft file File
    $THIS -addMenuEntry file "Insert *.iom" "$THIS -loadObjects"
    $THIS -addMenuEntry file "Save *.iom" "$THIS -saveCurrentObject"
    $THIS -addMenuSeparator file
    $THIS -addMenuEntry file "Save *.cls" "$THIS -createClass"
    $THIS -addMenuEntry file "Save *.yrt" "$THIS -createYARTFile"
    $THIS -addMenuEntry file "Save *.eps" "$THIS -saveTreeAsEPS"

    $THIS -addMenuSeparator help
    $THIS -addMenuEntry help "Scene" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage Scene"	
    $THIS -addMenuEntry help "IOM_Tree" "$THIS -buildInterfaceDevice IOM_ManualBox _i.man;
_i.man -manpage IOM_Tree"	
    $THIS -addMenuEntry help "<Selected>" "$THIS -manpage"
}

Tcl_Method IOM_SceneBox ~IOM_SceneBox {} {} {The destructor of the SceneBox objects.} {
    delete [set $THIS->tree] 
}

Tcl_Method IOM_SceneBox  -scanObjects {} {}  {Scan the object hierarchie.} {
    [set $THIS->tree] -scanObjects
}

Tcl_Method IOM_SceneBox  -editCurrentBitmap {} {}  {Edit the Bitmap of the current Class.} {
    global env
    set obj [$THIS -get_currentObject]
    if [string length $obj] {
	set class [$obj -get_class]
	exec bitmap $env(GOOD_ROOT_DIR)/IOM/bitmaps/$class.xbm
    }
}

Tcl_Method IOM_SceneBox  -manpage {} {} {Show man page of selected primitive} {
    set obj [$THIS -get_currentObject]
    if [string length $obj] {
	$THIS -buildInterfaceDevice IOM_ManualBox _i.man;	
	_i.man -manpage [$obj -get_class]
    }	
}

Tcl_Method IOM_SceneBox  -saveTreeAsEPS {} {}  {Save the tree as eps file.} {
   global env 
   
    FSBoxSetPattern *.eps
    
    set file [FSBox]
    
    if [string length $file] {
	set tree [set $THIS->tree]
	global $tree->canvas
	set canvas [set $tree->canvas]
	set bbox [eval $canvas bbox [$canvas find all]] 
	set x [lindex $bbox 0]
	set y [lindex $bbox 1]
	set dx [expr [lindex $bbox 2]-($x)]
	set dy [expr [lindex $bbox 3]-($y)]
	$canvas postscript -colormode gray -file $file \
		-x $x -y $y -width $dx -height $dy
	catch "exec xpsview $file &"
    }
}

# load and save functions:

Tcl_Method IOM_SceneBox  -saveCurrentObjectToFile {FileName} {String}  {Save the current object and his children to a file with the name {ARG 1 FileName}.} {
    global IOM_Version
    set obj [$THIS -get_currentObject]
    if [catch "open $FileName w" File] {
	rt_Output -error "erorr in file open: $File"
    }  
    
    puts $File "# IOM_ASCII_$IOM_Version\n\n"
    
    puts $File "######################################################"
    puts $File "#"
    puts $File "# IOM - Scene Script of the object $obj"
    puts $File "#"
    puts $File "# date: [exec date]"
    puts $File "#"
    puts $File "######################################################"
    
    IOM_saveHierarchicalPrimitive $obj $File
    
    close $File
}

Tcl_Method IOM_SceneBox  -loadObjectsFromFile {FileName} {String}  {Load the objects and his children of the a file with the name {ARG 1 FileName}.} {
    global IOM_Version
    if [catch "open $FileName r" File] {
	rt_Output -error "$THIS-loadObject: error in file open: $File"
    }  
    
    if [catch "gets $File" str] {
	rt_Output -error "$THIS-loadObject: error reading"
    }
    if [regexp IOM_ASCII_$IOM_Version $str] {
	source $FileName
    } {
	rt_Output -error "$THIS-loadObject: wrong file type! You need a file with the version: IOM_ASCII_$IOM_Version ."
    }
    close $File
    $THIS -update
    [set $THIS->tree] -buildCompleteTree
}

Tcl_Method IOM_SceneBox  -saveCurrentObject {} {}  {Save the current object and his childern.} {
    global env 
    
    FSBoxSetPattern *.iom
    set file [FSBox]
    if [string length $file] {
	$THIS -saveCurrentObjectToFile $file
    }
}

Tcl_Method IOM_SceneBox  -loadObjects {} {}  {Load the objects from an iom script.} {
    global env 
    
    FSBoxSetPattern *.iom
    set file [FSBox]
    if [string length $file] {
	$THIS -loadObjectsFromFile $file
    }
}

Tcl_Method IOM_SceneBox  -createClass {} {}  {Create a new class from current object tree.} {
    global env 
    set obj [$THIS -get_currentObject]
    if {""==$obj} return
    
    set path [exec pwd]
    
    #catch "cd $env(GOOD_ROOT_DIR)/classes"
    
    FSBoxSetPattern *.cls
    set file [FSBox]
    if [string length $file] {
	if [regsub "\.cls$" $file "" clsName] {
	    regsub ".*/" $clsName "" clsName
	    IOM_buildClassFileFromTree $obj $clsName $file
	} {
	    rt_Output -error "The extension of the class file is .cls!"
	}
	cd $path
    }
}

Tcl_Method IOM_SceneBox  -createYARTFile {} {}  {Create a .yrt file for the rtsh shell} {
    global env 
    
    FSBoxSetPattern *.yrt
    set file [FSBox]
    if [string length $file] {
	IOM_create_YRT_File $file
	exec $env(GOOD_ROOT_DIR)/bin/rtsh -file $file & 
    }
}

IOM_SceneBox -description {An interface to the hierachies of YART primitives. The tree-based representation is created by instantiating the class IOM_Tree. For an additional description of hot keys and scene semantics have a look into manual page IOM_Tree.}

IOM_SceneBox -keywords {IOM UserInterface}

