################################################################################
##  This file defines a collection of frame procedures.                       ##  
##  LAST EDIT: Thu Aug  4 13:23:47 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

########################################################################### 
# some default variables 
###########################################################################

set _FRAME_largeFrameOptions "-border 5"
set _FRAME_mediumFrameOptions "-border 5"
set _FRAME_smallFrameOptions "-border 1"
set _FRAME_nullFrameOptions "-border 0"

########################################################################### 
# build a frame  witch is packed to his parent and return the path
# for his children
###########################################################################

proc build_frame {name {dir top} {options {fill expand}} {frame_options ""}} {
    regsub "\.\[^\.\]*$" $name "" parent
    
    eval "frame $name $frame_options"
    
    if [string length $parent] {
	pack append $parent $name "$dir $options"
    } {
	pack append . $name "$dir $options"
    }

    return $name
}

###########################################################################
#
# procedures to build frames with three border types
# large small null
#
########################################################################### 

proc lframe {name {dir top} {options {fill expand}} {frame_options ""}} {
    global _FRAME_largeFrameOptions
    
    build_frame $name $dir $options $_FRAME_largeFrameOptions
}

proc sframe {name {dir top} {options {fill expand}} {frame_options ""}} {
    global _FRAME_smallFrameOptions

    build_frame $name $dir $options $_FRAME_smallFrameOptions
}

proc nullframe {name {dir top} {options {fill expand}} {frame_options ""}} {
    global _FRAME_nullFrameOptions
    
    build_frame $name $dir $options $_FRAME_nullFrameOptions
}

###########################################################################
#
# procedures to build a frame with  border and a rectangle
#
########################################################################### 

proc boxframe {name {dir top} {options {fill expand}} } {
    global _FRAME_smallFrameOptions _FRAME_mediumFrameOptions
    
    set tmp [build_frame $name $dir $options $_FRAME_mediumFrameOptions]
    set tmp [build_frame $tmp.r $dir $options "$_FRAME_smallFrameOptions -relief raised"]
    set tmp [build_frame $tmp.s $dir $options "$_FRAME_smallFrameOptions -relief sunken"]
    build_frame $tmp.f $dir $options $_FRAME_mediumFrameOptions
}

proc highframe {name {dir top} {options {fill expand}} } {
    global _FRAME_smallFrameOptions _FRAME_mediumFrameOptions
    
    set tmp [build_frame $name $dir $options $_FRAME_mediumFrameOptions]
    set tmp [build_frame $tmp.r $dir $options "$_FRAME_smallFrameOptions -relief raised"]
    build_frame $tmp.f $dir $options $_FRAME_mediumFrameOptions
}

proc lowframe {name {dir top} {options {fill expand}} } {
    global _FRAME_smallFrameOptions _FRAME_mediumFrameOptions
    
    set tmp [build_frame $name $dir $options $_FRAME_mediumFrameOptions]
    set tmp [build_frame $tmp.r $dir $options "$_FRAME_smallFrameOptions -relief sunken"]
    build_frame $tmp.f $dir $options $_FRAME_mediumFrameOptions
}

