################################################################################
##  This file defines an RGB scale.                                           ##  
##  LAST EDIT: Thu Aug  4 13:49:23 1994 by ekki(@prakinf.tu-ilmenau.de)
################################################################################
##  This file belongs to the YART implementation. Copying, distribution and   ##
##  legal info is in the file COPYRGHT which should be distributed with this  ##
##  file. If COPYRGHT is not available or for more info please contact:       ##
##                                                                            ##  
##		yart@prakinf.tu-ilmenau.de                                    ##
##                                                                            ##  
## (C) Copyright 1994 YART team                                               ##
################################################################################

###########################################################################
# build a scale with an label on the right side
###########################################################################

proc scale_label {name title {width 0}} {
    set path [sframe $name]
    scale $path.scale -orient horizontal -showvalue 0 -width 6 -sliderlength 20 -from 0 -to 255
    label $path.label -text $title -width $width
    pack append $path \
	$path.scale {left fill expand} \
	$path.label {left fill }
    return  $path.scale
}

###########################################################################
# build a scale for the 3 rgb values
###########################################################################

# getCmd is a command witch returns the value of the manipulated object
# setCmd set the value of the manipulated object
# 
# the value is in vector format: {r g b}
#
# the result of the procedure is a command witch must be called to update the scale

proc rgb_scale {name titel getCmd setCmd {label_width 0}} {
    set path [boxframe $name]
    set info [lowframe $path.info left fill]
    set scales [lowframe $path.scales left]
    
    label $info.label -text "$titel" -width $label_width 
    pack append $info $info.label {expand fill}
    
    set infoFrame [highframe $info.val]
    label $infoFrame.l -background #000000
    pack append $infoFrame $infoFrame.l {expand fill}
    
    set r_scale [scale_label $scales.r Red 5] 
    set g_scale [scale_label $scales.g Green 5]
    set b_scale [scale_label $scales.b Blue 5]
    
    
    append update_command "$infoFrame.l configure -background \[format \"#%2.2x%2.2x%2.2x\" \[$r_scale get\]  \[$g_scale get\] \[$b_scale get\]\]; "
    append update_command "set _red \[expr \"\[$r_scale get \]/255.0\" \]; "
    append update_command "set _green \[expr \"\[$g_scale get \]/255.0\" \]; "
    append update_command "set _blue \[expr \"\[$b_scale get \]/255.0\" \]; "
    append update_command "$setCmd \"\{ \$_red \$_green \$_blue \}\"; "
    append update_command "set __color "
    
    $r_scale configure -command $update_command
    $g_scale configure -command $update_command
    $b_scale configure -command $update_command
    
    # create a commandset, to get the values for the scales
    append getCommands "set __list \[$getCmd\];\n"
    append getCommands "if \[llength \$__list\]==3 { \n"
    append getCommands "$r_scale set \[format \"%3.0f\" \[expr 255*\[lindex \$__list 0\]\]\] \n"
    append getCommands "$g_scale set \[format \"%3.0f\" \[expr 255*\[lindex \$__list 1\]\]\] \n"
    append getCommands "$b_scale set \[format \"%3.0f\" \[expr 255*\[lindex \$__list 2\]\]\] \n"
    append getCommands "} \n "
    
    return $getCommands
}    

###########################################################################
# build a scale for an scalar value
###########################################################################

# getCmd is a command witch returns the value of the manipulated object
# setCmd set the value of the manipulated object
# 
# the value is scalar
#
# the result of the procedure is a command witch must be called to update the scale

proc s_scale {name titel getCmd setCmd {label_width 0}} {
    set path [boxframe $name]
    set info [lowframe $path.info left fill]
    set scales [lowframe $path.scales left]
    
    label $info.label -text "$titel" -width $label_width
    pack append $info $info.label {expand fill}
    
    scale $scales.val -orient horizontal -showvalue 0 -width 6 -from 0 -to 255 -sliderlength 20
    pack append  $scales $scales.val {fill expand}
    
    append update_command "set _val \[expr \"\[$scales.val get \]/255.0\" \]; "
    append update_command "$setCmd \$_val ; "
    append update_command "set __null "
    
    $scales.val configure -command $update_command
    
    append getCommands "if \[string length \[$getCmd\]\] { \n"
    append getCommands "$scales.val set \[format \"%3.0f\" \[expr 255*\[$getCmd\]\]\] \n"
    append getCommands "} \n "
    
    return $getCommands
}    

