////////////////////////////////////////////////////////////////////////////////
//  implementation of XDR communication                                       //  
//  LAST EDIT: Fri Dec 16 09:02:34 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART VR extension. Copying, distribution and     //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright '94 '95 Ekkehard 'Ekki' Beier                                //
////////////////////////////////////////////////////////////////////////////////

#include "vr_scene.h"
#include "vr_xdrcomm.h"

const char *VR_COMPRESS = "gzip ";
const char *VR_UNCOMPRESS = "gzip -d ";

int VR_XDRUserCommunicator::blobMode; 
int VR_XDRUserCommunicator::blobString = 0; 
int VR_XDRUserCommunicator::blobSize; 
FILE *VR_XDRUserCommunicator::blobFP = 0;
RT_String VR_XDRUserCommunicator::blobFile(100);

VR_XDRSceneCommunicator::VR_XDRSceneCommunicator() {
    sockaddr_in saddr;
    memset( &saddr, 0, sizeof( sockaddr_in ) );
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons( VR_PORT_ADDR ); 

    // initialize the scene socket:
    if (( sofd = socket( AF_INET, SOCK_STREAM, 0 )) == -1 
	|| bind( sofd, (sockaddr*)&saddr, sizeof( sockaddr_in )) == -1 
	|| listen( sofd, 5 ) == -1 ) {
	rt_Output->fatal( "Couldn't create the socket. May be the program is already running on this host? Or try it some minutes later again." );
    }

    FD_ZERO( &rfds ); 
    FD_SET( sofd, &rfds );
    fdMax = sofd;
}    

void VR_XDRSceneCommunicator::sendText2user(VR_User *us, const char *txt) {
    RT_String s = "vr_User -message \"";
    s += txt;
    s += '\"';
    char *c = (char*)s;
    xdr_wrapstring( &((VR_XDRUserData*)us->data)->wxdr, &c );
}

void VR_XDRSceneCommunicator::sendCmd2user(VR_User *us, const char *txt) {
    char *c = (char*)txt;
    xdr_wrapstring( &((VR_XDRUserData*)us->data)->wxdr, &c );
}

void VR_XDRSceneCommunicator::sendBlob2user(VR_User *us, const char *fname, const char *rfname, int cmp) {
    FILE *fp;
    char *cfname; // compressed file's name
    RT_String cmd(100);
    if (cmp) {
	// compress it:
	cmd = "cat ";
	cmd += fname;
	cmd += "|";
	cmd += VR_COMPRESS;

	cfname = new char[ strlen( VR_TMPLATE ) + 1];
	strcpy( cfname, VR_TMPLATE );
	mktemp( cfname );
	cmd += "> ";
	cmd += cfname;

	system( cmd ); 

	fp = fopen( cfname, "r" );
	if (!fp) rt_Output->fatalVar( "Couldn't read compressed BLOB file ", (char*)cfname, "!", 0 );
    }
    else {
	fp = fopen( fname, "r" );
	if (!fp) rt_Output->fatalVar( "Couldn't read BLOB file ", (char*)fname, "!", 0 );
    }
    int cnt = 1;

    char *txt = new char[20]; 
    char *blob = new char[VR_SPLIT_BLOB_SIZE + 1];
    
    sprintf( txt, "B_Start %s %i", rfname, cmp );
    xdr_wrapstring( &((VR_XDRUserData*)us->data)->wxdr, &txt );
    while (1) {
	int r = fread( (void*)blob, 1, VR_SPLIT_BLOB_SIZE, fp );
	sprintf( txt, "B_Part %i", r );
	xdr_wrapstring( &((VR_XDRUserData*)us->data)->wxdr, &txt );

	blob[r] = 0;
	xdr_bytes( &((VR_XDRUserData*)us->data)->wxdr, &blob, (u_int*)&r, r );
	if (r < VR_SPLIT_BLOB_SIZE) break;
	cnt++;
    }
    fclose( fp );
    sprintf( txt, "B_End %s", rfname );
    xdr_wrapstring( &((VR_XDRUserData*)us->data)->wxdr, &txt );

    delete txt;
    delete blob;

    if (cmp) {
	// remove the tmp file:
	cmd = "rm -f ";
	cmd += cfname;
	system( cmd );

	delete cfname;
    }
}

void VR_XDRSceneCommunicator::loop() {
    fd_set tfds;
    while (1) {
	tfds = rfds;
	if ( select( fdMax + 1, &tfds, 0, 0, 0 ) > 0 ) {
	    if ( FD_ISSET( sofd, &tfds ) ) {
		// create connection:
		int co = accept( sofd, 0, 0 );
		if (co == -1) rt_Output->warning( "Couldn't accept connection." );
		else {
		    XDR rxdr, wxdr;
		    VR_createXDR( &rxdr, co, XDR_DECODE );
		    VR_createXDR( &wxdr, co, XDR_ENCODE );
		    
		    char *cmd = 0;
		    if (!xdr_wrapstring( &rxdr, &cmd )) 
			rt_Output->warning( "Couldn't read login command." );
		    else {
			RT_String res( eval( cmd ) );
			if (!strncmp( cmd, "login", 5 )) {
			    VR_User *us = 0;
			    
			    int argc; char **argv;
			    if (Tcl_SplitList( rt_Ip, (char*)res, &argc, &argv) == TCL_OK) {
				if (argc == 2) {
				    // the login was successful
				    // the first value is the uid
				    int uid;
				    RT_string2int( argv[0], uid );
				    us = vr_Scene->find( uid );
				}
				free( (char*)argv );
			    }
			    if (us) {
				us->data = new VR_XDRUserData( rxdr, wxdr );
				FD_SET( co, &rfds );
				if (co > fdMax ) fdMax = co;
				vr_Scene->newUser( us );
			    }
			    else {
				rt_Output->error( "Login failed." );
				xdr_destroy( &rxdr );
				xdr_destroy( &wxdr );
				close( co );
			    }
			}
			free( cmd );
		    }
		}
	    }
	    static RT_String cmds( 1000 );
	    cmds = "";
	    class LFunctoid: public RT_GeneralListFunctoid {
		RT_String &cmds;
		void exec( RT_GeneralListEntry *e, void *v ) {
		    // this is a type-safe downcast cos only
		    // VR_Users are in that scene:
		    VR_User *us = (VR_User*)e;
		    if ( FD_ISSET( ((VR_XDRUserData*)us->data)->rxdr.x_handy, (fd_set*)v ) ) {
			char *cmd = 0;
			if (!xdr_wrapstring( &((VR_XDRUserData*)us->data)->rxdr, &cmd )) {
			    rt_Output->warningVar( "Bad command from ", (char*)us->getName(), "." );
			    us->invalid();
			}
			else { cmds += cmd; cmds += '\n'; }
			free( cmd );
		    }
		}
	      public:
		LFunctoid(RT_String &_cmds): cmds( _cmds ) {}
	    } func( cmds );
	    vr_Scene->iterate( &func, &tfds );
	    vr_SceneCommunicator->eval( cmds );
	    VR_User *us;
	    while ( us = vr_Scene->findInvalidUser() ) 
		vr_Scene->killUser( us );
	}
    }
}

void VR_XDRSceneCommunicator::killUser(VR_User *us) {
    FD_CLR( ((VR_XDRUserData*)us->data)->rxdr.x_handy, &rfds );
}

int VR_XDRUserCommunicator::blobStartCMD(ClientData, Tcl_Interp*, int argc, char *argv[] ) {
    // <cmd> <blob filename> <mode>
    if (argc != 3) {
	rt_Output->error( "Received a bad BLOB start command." );
	return TCL_ERROR;
    }
    blobMode = strcmp( argv[2], "0" );
    // setup Blob name:
    char *h = getenv( "HOME" );
    if (!h) rt_Output->fatal( "Cannot read your HOME variable." );
    blobFile = h;
    blobFile += "/tmp/";
    blobFile += argv[1]; 
    
    // open local Blob file for writing:

    blobFP = fopen( (char*)blobFile, "w" );
    if (!blobFP) {
	rt_Output->fatalVar( "Cannot open BLOB file ", (char*)blobFile, ".", 0);
	return TCL_OK;
    }
    return TCL_OK;
}

int VR_XDRUserCommunicator::blobPartCMD(ClientData, Tcl_Interp*, int argc, char *argv[] ) {
    // <cmd> <size>
    if (argc != 2) {
	rt_Output->error( "Received a bad BLOB part command." );
	return TCL_ERROR;
    }
    RT_string2int( argv[1], blobSize );
    blobString = 1;
    return TCL_OK;
}

int VR_XDRUserCommunicator::blobEndCMD(ClientData, Tcl_Interp*, int argc, char *argv[] ) {
    // <cmd> <blob filename>
    if (argc != 2) {
	rt_Output->error( "Received a bad BLOB end command." );
	return TCL_ERROR;
    }
    fclose( blobFP );

    if (blobMode) {
	char *tmpName = new char[ strlen( VR_TMPLATE ) + 1];
	strcpy( tmpName, VR_TMPLATE );
	mktemp( tmpName );
	RT_String cmd( 200 );
	// move blob file to tmp file:
	cmd = "mv ";
	cmd += blobFile;
	cmd += " ";
	cmd += tmpName;
	// uncompress tmp file in blob file:
	cmd += ";cat ";
	cmd += tmpName;
	cmd += "|";
	cmd += VR_UNCOMPRESS;
	cmd += ">";
	cmd += blobFile;
	// delete the tmp file:
	cmd += ";rm ";
	cmd += tmpName;
	system( cmd );
	
	delete tmpName;
    }
    blobFP = 0;
    return TCL_OK;
}

VR_XDRUserCommunicator::VR_XDRUserCommunicator(Tcl_Interp *_ip, char *_scene):
VR_UserCommunicator( _ip, 0 ), scene( _scene ) {
    // append two special commands to the interpreter:
    Tcl_CreateCommand( ip, "B_Start", VR_XDRUserCommunicator::blobStartCMD, 0, 0 );
    Tcl_CreateCommand( ip, "B_Part", VR_XDRUserCommunicator::blobPartCMD, 0, 0 );
    Tcl_CreateCommand( ip, "B_End", VR_XDRUserCommunicator::blobEndCMD, 0, 0 );
    
    int idx = scene.pos( "@" );
    assert( idx != -1 );
    hostent *he = gethostbyname( &((char*)scene)[idx + 1]);

    if (!he) {
	extern int h_errno;
	switch( h_errno ) {
	  case HOST_NOT_FOUND: rt_Output->fatalVar( "Host \"", &((char*)scene)[idx + 1], "\" not found.", 0 ); break;
	  case TRY_AGAIN: rt_Output->fatal( "NIS error, try again." ); break;
	  case NO_RECOVERY: rt_Output->fatal( "Non-recoverable server error." ); break;
	  case NO_DATA: rt_Output->fatal( "No address associated with this name." ); break;
	}
    }
    sockaddr_in saddr;

    memset( &saddr, 0, sizeof( sockaddr_in ) );
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons( VR_PORT_ADDR ); 
    saddr.sin_addr = *(struct in_addr*)he->h_addr_list[0];
    
    // initialize the scene socket:
    if (( sofd = socket( AF_INET, SOCK_STREAM, 0 )) == -1
	|| connect( sofd, (sockaddr*)&saddr, sizeof( saddr )) == -1 )
	rt_Output->fatal( "Couldn't connect to the scene." );

    VR_createXDR( &rxdr, sofd, XDR_DECODE );
    VR_createXDR( &wxdr, sofd, XDR_ENCODE );

    RT_String cmd( VR_MAX_USER_REPRESENTATION + 100 );
    cmd = "login ";
    cmd += getlogin();
    cmd += '@';
    cmd += vr_Hostname;
    cmd += ' ';

    cmd += " {{";
    cmd += getRepresentation();
    cmd += "}}";

    send( cmd );

    // install a filehandler in Tk:
    Tk_CreateFileHandler( sofd, TK_READABLE, VR_XDRUserCommunicator::readProc, 0 );
}

void VR_XDRUserCommunicator::send(char *cmd) {
    RT_eval( "vr_User -transfer" );
    xdr_wrapstring( &wxdr, &cmd );
}

void VR_XDRUserCommunicator::receive() {
    char *s = 0;
    if (blobString) {
	u_int r;
	if (!xdr_bytes( &rxdr, &s, &r, blobSize ));
	if (!s || r != (u_int)blobSize) return;

	if (blobFP) fwrite( (void*)s, blobSize, 1, blobFP );
	blobString = 0;
    }
    else {
	if (!xdr_wrapstring( &rxdr, &s )) rt_Output->fatal( "Received bad command." );
	if (!s) return;

	if (Tcl_GlobalEval( rt_Ip, s ) != TCL_OK ) 
	    rt_Output->error( rt_Ip->result );
	else vr_updateCamera(); 

	RT_eval( "vr_User -transfer" );
    }
    free( s );
}

VR_XDRUserCommunicator::~VR_XDRUserCommunicator() { 
    xdr_destroy( &rxdr ); 
    xdr_destroy( &wxdr ); 
    close( sofd );
}

