////////////////////////////////////////////////////////////////////////////////
// attribute list implementation. an attribute list is also used as dynamic   //
// growing attribute context                                                  //  
// 14/01/94: retraversing changed: find the first attribute that matches to the
//           primitive (class or object) 
//  LAST EDIT: Fri Aug  5 08:55:13 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "attribut.h"
#include "attrobj.h"
#include "primitiv.h"

const char *RTN_ATTRIBUTE = "Attribute";
const char *RT_ANY = "";

int RT_Attribute::findStart(char **argv) {
    return RT_findString( argv, getClass() );
}

void RT_AttributeList::insert(RT_Attribute *a) {
    RT_Attribute *b;
    // if there is already one attribute of this
    // type - copy the new one into this one:
    if ( b = get( a->getClass())) *b = *a;
    // else create one:
    else {
	append(a);
	if (pm) pm->attrsChanged();
    }
}

RT_Attribute *RT_AttributeList::get(const char *_cls) {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return 0;
    // look for THE attribute of class _cls
    // a primitive can have only one attribute of each attr class
    do {
	RT_Attribute *at = (RT_Attribute*)tmp->elem; 
	// only attributes in the list - thus no type checking
	if (!strcmp( at->getClass(), _cls )) return at;
    }
    while (tmp = tmp->next);
    return 0;
}

void RT_AttributeList::merge( const RT_AttributeList *list) {
    RT_GeneralListElem *tmp = list->root;
    if (tmp) do {
	RT_Attribute *attr = (RT_Attribute*)tmp->elem;
	int replaced = 0;
	RT_GeneralListElem *tmp1 = root;
	// set the new attribute,
	// if exist overwrite it, else append it:
	if (tmp1) do {
	    RT_Attribute *oat = (RT_Attribute*)tmp1->elem;
	    if (!strcmp( oat->getClass(), attr->getClass() )) {
		tmp1->elem = attr;
		replaced = 1;
		break;
	    }
	}
	while (tmp1 = tmp1->next);
	if (!replaced) append( attr );
    } 
    while (tmp = tmp->next);
}

const RT_Attribute *RT_AttributeList::retraverse( const char *cls, 
    const RT_Primitive *p) const {
    RT_GeneralListElem *tmp = root;
    if (tmp)  {
	// look for the attribute related to this class:
	do {
	    RT_Attribute *at = (RT_Attribute*)tmp->elem;
	    if (!strcmp( at->getClass(), cls )) {
		// now check if "at" is valid to the primitive or not:
		if (!strcmp( at->getNamesList(), RT_ANY )) return at;
		int aargc; char **aargv;
		if (Tcl_SplitList( rt_Ip, 
				  (char*)at->getNamesList(), 
				  &aargc, &aargv) == TCL_OK) {
		    for ( int i = 0; i < aargc; i++) {
			if (!strcmp( p->get_name(), aargv[i]) ||
			    (!strcmp( p->get_class(), aargv[i]))) {
			    free((char*)aargv);
			    return at;
			}
		    }
		    free((char*)aargv);
		}
	    }
	}
	while( tmp = tmp->next);
    }

    // print a debug message about the retraversing:
    //    fprintf( stderr, "%s.%s wanted in: %s\n", 
    // p->get_name(), cls, pm ? pm->get_name() : "<noname>" );
    
    
    // this is important!!! -> if "p" is a part, 
    // then retraverse under the name of its parent:

    if (p->isPart && p->get_father()) {
	p = p->get_father();
	return p->attributes->retraverse( cls, p );
    }
	
    // otherwise ask the father (recursively) for the 
    // wanted attribute:

    if (pm && pm->get_father()) 
	return pm->get_father()->attributes->retraverse( cls, p );

    // no attribute in the hierarchy - so return the default one:
    return rt_AttributeObject->getDefault( cls );
}

void RT_Attribute::changed() { 
    // if the attribute was already changed:
    if (changedFlag) return; 
    changedFlag = 1; 
}

void RT_AttributeList::print(FILE *f) const {
    RT_GeneralList::print( f );
    fprintf(f, "\n" );
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    // now save the classes of the attributes:
    do {
	RT_Attribute *a = (RT_Attribute *)tmp->elem; 
	// no type check - only attributes in the list
	if (strcmp( a->getNamesList(), RT_ANY )) {
	    // it is a dump of a primitive:
	    if (pm) fprintf( f, "%s -attrNames %s {%s}\n", 
			    pm->get_name(), a->getClass(), a->getNamesList() );

	    else fprintf( f, "[attribute: %s class: %s]\n", a->getClass(), 
			 a->getNamesList() );
	}
    }
    while (tmp = tmp->next);
}

// remove all attributes from the list:
void RT_AttributeList::clear() {
    RT_GeneralListElem *tmp = root;
    if (!tmp) return;
    do delete tmp->elem; while (tmp = tmp->next); 
} 


