#ifndef __COMPLEX_H__
#define __COMPLEX_H__

////////////////////////////////////////////////////////////////////////////////
//  A class representing complex numbers.                                     //  
//  LAST EDIT: Fri Aug  5 08:55:10 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <math.h>
#include <stdio.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

class RT_Complex {
    double rr, ii;
  public:
    RT_Complex(const double _rr = 0., const double _ii = 0.) { rr = _rr; ii = _ii; }

    // set&get contents:
    void setReal(const double d) { rr = d; }
    void setImag(const double d) { ii = d; }
    double getReal() const { return rr; }
    double getImag() const { return ii; }

    // manipulations:
    void addReal(const double d) { rr += d; }

    void mult(const double d) { rr *= d; ii *= d; }

    void pow(const double p) {
	double r = sqrt( rr * rr + ii * ii );
	double phi;

	if (ii >= 0) {
	    if ( rr == 0.) phi = M_PI_2;
	    else phi = atan( ii/rr);
	    if (rr < 0 ) phi += M_PI;
	}
	else {
	    if ( rr == 0.) phi = M_PI_2;
	    else phi = atan( ii/rr);
	    if (rr < 0 ) phi -= M_PI;
	}

	r = ::pow( r, p );
	phi *= p;

	rr = r * cos( phi ); ii = r * sin( phi );
    }

    void operator=(const RT_Complex &c) { rr = c.rr; ii = c.ii; }
    friend RT_Complex operator+(const RT_Complex &a, const RT_Complex &b) {
	RT_Complex c( a.rr + b.rr, a.ii + b.ii );
	return c;
    }

    friend RT_Complex operator*(const RT_Complex &a, const RT_Complex &b) {
	RT_Complex c( a.rr * b.rr - a.ii * b.ii, a.rr * b.ii + a.ii * b.rr );
	return c;
    }

    friend RT_Complex operator-(const RT_Complex &a, const RT_Complex &b) {
	RT_Complex c( a.rr - b.rr, a.ii - b.ii );
	return c;
    }

    // print it to verify it:
    void print(FILE *f) { fprintf( f, "%lf + j (%lf)\n", rr, ii ); }
};

#endif
