#ifndef __ERROR_H__
#define __ERROR_H__

////////////////////////////////////////////////////////////////////////////////
// An error device class. Every application can implemented their own specific//  
// devices for output of error, warnings, etc.                                //  
// LAST EDIT: Thu Oct 20 13:32:24 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <stdio.h>
#include <stdarg.h>

#ifndef RTD_CPP_INCLUDES
}
#endif

#include "strings.h"

class RT_Output {
  protected:
    RT_String prog;
  public:
    RT_Output() { prog = "YART"; }
    
    virtual void special(const char*) = 0;
    virtual void specialVar(const char* ...) = 0;
    // special messages will not presented 
    // to the standard user
    // they can be used for log files etc.

    virtual void message(const char*) = 0;
    virtual void messageVar(const char* ...) = 0;

    virtual void warning(const char*) = 0;
    virtual void warningVar(const char* ...) = 0;

    virtual void error(const char*) = 0;
    virtual void errorVar(const char* ...) = 0;

    // a fatal error leads to the exit
    virtual void fatal(const char*) = 0;
    virtual void fatalVar(const char* ...) = 0;

    void setProgram(const char *pr) { prog = pr; }
};

class RT_SystemOutput: public RT_Output {
  public:
    void special(const char*) {}
    void specialVar(const char* ...) {}

    void message(const char*);
    void messageVar(const char* ...);

    void warning(const char*);
    void warningVar(const char* ...);

    void error(const char*);
    void errorVar(const char*...);

    void fatal(const char*);
    void fatalVar(const char*...);
};

#endif
