////////////////////////////////////////////////////////////////////////////////
//  Definitions and Implemenations of global variables and functions.         //  
//  LAST EDIT: Fri Feb 10 15:43:43 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "yart.h"
#include "tclmath.h"

#ifdef RTD_RSY
#include "rsy/rsyscene.h"
#endif

#ifdef RTD_SC
#include "scient/scient.h"
#endif

#ifdef OSF1_2
#include <signal.h>
#endif

#ifndef RTD_CPP_INCLUDES
extern "C" {
#endif

#include <sys/stat.h>    
#include <stdlib.h>    

#ifndef RTD_CPP_INCLUDES
}
#endif

double rt_UndefinedBounds = 1e+10;
double rt_RayEps = 1e-10;
double rt_MaxDistance = 1e7;
int rt_MaxLevel = 10;
double rt_MinWeight = 0.01;
RT_String rt_PackageList;
RT_String rt_PrimitiveClassList;
Tcl_Interp *rt_Ip;
Tcl_HashTable rt_Hash;
RT_GlobalList *rt_Objects;
RT_Output *rt_Output;

const RT_Matrix RT_IDENTITY;
const RT_Surface RT_NULL_SURFACE(0);
const RT_Vector RT_NULL_NORMAL( 0, 0, 0);
const RT_Vector RT_BAD_VECTOR( -1, -1, -1 ); 

const RT_GeneralList RT_NULL_LIST;

RT_GeneralList rt_DefaultAttributes;

// global and Tcl-accessible variables:
int rt_RayDebug = 0; // no ray-tracing debug messages
int rt_PickDebug = 0; // no pick debug messages
int rt_RefractedShadows = 1; // compute refracted shadows
RT_String rt_YARTProgram( "${GOOD_ROOT_DIR}/YART/bin/rtsh");

int RT_primitivesCMD(ClientData, Tcl_Interp *ip, int, char *[]) {
    RT_GeneralList *list = RT_primitives();
    RT_String tmp(100);
    RT_PrintObjectNameFunc func( &tmp);
    tmp += '{';
    list->doWithElements( &func );
    tmp += '}';
    delete list;
    Tcl_SetResult( ip, (char*)tmp, TCL_VOLATILE );
    return TCL_OK;
}

int RT_deleteCMD(ClientData, Tcl_Interp *, int argc, char *argv[]) {
    // the CMD has the same functionality like the C++-delete operator
    // but you can specify more than one argument:
    RT_Object *tmpObj;
    for (int i = 1; i < argc; i++ ) 
	if ( tmpObj = RT_Object::getObject(argv[i])) {
	    if ((tmpObj->isA( RTN_MAPPING )) && ((RT_Mapping*)tmpObj)->getRef() ) {
		rt_Output->errorVar( "You cannot delete ", tmpObj->get_name(), ", because it is still referenced in at least one directly assigned mapping attribute.", 0 );
		break;
	    }
	    if ((tmpObj->isA( RTN_TEXTURE_3D )) && ((RT_Texture3D*)tmpObj)->getRef() ) {
		rt_Output->errorVar( "You cannot delete ", tmpObj->get_name(), ", because it is still referenced in at least one another texture.", 0 );
		break;
	    }
	    delete tmpObj;
	}
	else rt_Output->errorVar( "No such object to delete: ", argv[i], "!", 0 );
    return TCL_OK;
}

int RT_packCMD(ClientData, Tcl_Interp *ip, int, char *[]) {
    Tcl_AppendResult( ip, RT_packages(), (char*)NULL);
    return TCL_OK;
}

char *RT_packages() {
    return (char*)rt_PackageList;
}

int RT_primClassCMD(ClientData, Tcl_Interp *ip, int, char *[]) {
    Tcl_AppendResult( ip, RT_primitiveClasses(), (char*)0 );
    return TCL_OK;
}

char *RT_primitiveClasses() {
    return (char*)rt_PrimitiveClassList;
}


int RT_saveCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    if (argc != 2) {
	Tcl_AppendResult( ip, argv[0], " need a filename.", 0 );
	return TCL_OK;
    }
    RT_save( argv[1]);
    return TCL_OK;
}

void RT_save(char *file) {
    FILE *f = fopen( file, "w" );
    if ( f ) {
	rt_Objects->print( f );
	fclose( f );
	chmod( file, 0755 );
    } 
    else rt_Output->errorVar( "Couldn't open file ", file, " for writing.", 0 );
}

int RT_sleepCMD(ClientData, Tcl_Interp *ip, int argc, char *argv[]) {
    int ms;
    if (argc != 2 || !RT_string2int( argv[1], ms)) {
	Tcl_AppendResult( ip, argv[0], " need an integer.", 0 );
	return TCL_OK;
    }
    RT_sleep( ms );
    return TCL_OK;
}

void RT_sleep(int ms) {
    static  struct timeval delay;
    delay.tv_sec = ms/1000;
    delay.tv_usec = (ms%1000)*1000;
    select( 0, 0, 0, 0, &delay);
}

// trace procedures:

char *RT_writeRayDebugTRC(ClientData, Tcl_Interp *, char*, char *, int) {
    char *v = Tcl_GetVar( rt_Ip, "rt_RayDebug", TCL_GLOBAL_ONLY );
    if (!v) return 0;
    int i;
    if (RT_string2int( v, i)) {
	if (i > 1) i = 1;
	if (i < 0) i = 0;
	rt_RayDebug = i;
    }
    return 0;
}

char *RT_writePickDebugTRC(ClientData, Tcl_Interp *, char*, char *, int) {
    char *v = Tcl_GetVar( rt_Ip, "rt_PickDebug", TCL_GLOBAL_ONLY );
    if (!v) return 0;
    int i;
    if (RT_string2int( v, i)) {
	if (i > 1) i = 1;
	if (i < 0) i = 0;
	rt_PickDebug = i;
    }
    return 0;
}

char *RT_writeRefractedShadowsTRC(ClientData, Tcl_Interp *, char*, char *, int) {
    char *v = Tcl_GetVar( rt_Ip, "rt_RefractedShadows", TCL_GLOBAL_ONLY );
    if (!v) return 0;
    int i;
    if (RT_string2int( v, i)) {
	if (i > 1) i = 1;
	if (i < 0) i = 0;
	rt_RefractedShadows = i;
    }
    return 0;
}

char *RT_writeYARTProgramTRC(ClientData, Tcl_Interp *, char*, char *, int) {
    char *v = Tcl_GetVar( rt_Ip, "rt_YARTProgram", TCL_GLOBAL_ONLY );
    if (!v) return 0;
    rt_YARTProgram = v;
    return 0;
}

// pure initialization (only interpretative class system + delete):

int RT_pureInit(Tcl_Interp *ip) {

#ifdef OSF1_2
    signal(SIGFPE, SIG_IGN);
#endif

    if (!ip) ip = Tcl_CreateInterp();
    rt_Ip = ip;
    Tcl_InitHashTable( &rt_Hash, TCL_STRING_KEYS );
    rt_InputServer = new RT_InputServer;
    rt_Objects = new RT_GlobalList;
    rt_Output = new RT_SystemOutput;
    rt_AttributeObject = new RT_AttributeObject;
    
    // general commands:
    RTM_command( "delete", RT_deleteCMD );

    // additional commands needed for the TclClasses:
    rt_initTclClassCommands( ip );

    // some Tcl stuff:
    char *pth = getenv( RT_GOOD_ROOT_DIR );
    if (pth &&	Tcl_VarEval( ip, "source ", pth, "/YART/bin/yart.tcl", 0 ) == TCL_ERROR) {
	rt_Output->errorVar( "Error when evaluating */yart.tcl: ", ip->result, 0 );
	return TCL_ERROR;
    }
    return TCL_OK;
}

int RT_init( Tcl_Interp *ip) {
    if (RT_pureInit( ip ) == TCL_ERROR) return TCL_ERROR;

    // in case, ip was initialized in RT_pureInit():
    ip = rt_Ip;

    // control flags:

    Tcl_SetVar( ip, "rt_RayDebug", "0", TCL_GLOBAL_ONLY );
    Tcl_TraceVar( ip, "rt_RayDebug", TCL_TRACE_WRITES, RT_writeRayDebugTRC, 0 );
    
    Tcl_SetVar( ip, "rt_PickDebug", "0", TCL_GLOBAL_ONLY );
    Tcl_TraceVar( ip, "rt_PickDebug", TCL_TRACE_WRITES, RT_writePickDebugTRC, 0 );

    Tcl_SetVar( ip, "rt_RefractedShadows", "0", TCL_GLOBAL_ONLY );
    Tcl_TraceVar( ip, "rt_RefractedShadows", TCL_TRACE_WRITES, RT_writeRefractedShadowsTRC, 0 );

    Tcl_SetVar( ip, "rt_YARTProgram", (char*)rt_YARTProgram, TCL_GLOBAL_ONLY );
    Tcl_TraceVar( ip, "rt_YARTProgram", TCL_TRACE_WRITES, RT_writeYARTProgramTRC, 0 );
    
    // the YART Tcl/C++ functions:
    RTM_command( "RT_save", RT_saveCMD );
    RTM_command( "RT_sleep", RT_sleepCMD );
    RTM_command( "RT_packages", RT_packCMD );
    RTM_command( "RT_primitives", RT_primitivesCMD );
    RTM_command( "RT_primitiveClasses", RT_primClassCMD );

    // access to default attributes:
    RTM_command( RTN_ATTRIBUTE_OBJECT, RT_AttributeObject::attributeCMD );

    // append default attributes in the default's list
    // additionals may be added in user's initialization code
    rt_DefaultAttributes.append( &RT_ResolutionAttribute::Default );
    rt_DefaultAttributes.append( &RT_SurfaceAttribute::Default );
    rt_DefaultAttributes.append( &RT_FillstyleAttribute::Default );
    rt_DefaultAttributes.append( &RT_MappingAttribute::Default );

    // primitives:
    // "RTM_primCommand" cannot be used out of this file!

    rt_PrimitiveClassList = "{Primitives {The built-in primitives of the YART graphics kernel} {";
    RTM_primCommand( RTN_AXES, RT_Axes::classCMD );
    RTM_primCommand( RTN_BEZIER, RT_Bezier::classCMD );
    RTM_primCommand( RTN_BSPLINE, RT_BSpline::classCMD );
    RTM_primCommand( RTN_CONE, RT_Cone::classCMD );
    RTM_primCommand( RTN_CYLINDER, RT_Cylinder::classCMD );
    RTM_primCommand( RTN_ELLIPSOID, RT_Ellipsoid::classCMD );
    RTM_primCommand( RTN_HEIGHT_FIELD, RT_HeightField::classCMD );
    RTM_primCommand( RTN_OBA_PRIMITIVE, RT_OBAPrimitive::classCMD );
    RTM_primCommand( RTN_OFF_POLYHEDRON, RT_OFFPolyhedron::classCMD );
    RTM_primCommand( RTN_OFF_POLYGON, RT_OFFPolygon::classCMD );
    RTM_primCommand( RTN_OFF_QUADMESH, RT_OFFQuadmesh::classCMD );
    RTM_primCommand( RTN_PLANE, RT_Plane::classCMD );
    RTM_primCommand( RTN_POLYGON, RT_Polygon::classCMD );
    RTM_primCommand( RTN_POLYHEDRON, RT_Polyhedron::classCMD );
    RTM_primCommand( RTN_POLYLINE, RT_Polyline::classCMD );
    RTM_primCommand( RTN_POLYMARKER, RT_Polymarker::classCMD );
    RTM_primCommand( RTN_QUADER, RT_Quader::classCMD );
    RTM_primCommand( RTN_QUADMESH, RT_Quadmesh::classCMD );
    RTM_primCommand( RTN_QUADRIC, RT_Quadric::classCMD );
    RTM_primCommand( RTN_ROTATION_SURFACE, RT_RotationSurface::classCMD );
    RTM_primCommand( RTN_SPHERE, RT_Sphere::classCMD );
    RTM_primCommand( RTN_SPLINE_SURFACE, RT_SplineSurface::classCMD );
    RTM_primCommand( RTN_TEXT, RT_Text::classCMD );
    RTM_primCommand( RTN_TOP, RT_Top::classCMD );
    RTM_primCommand( RTN_TORUS, RT_Torus::classCMD );
    rt_PrimitiveClassList += "}} ";
    
    // scenes:
    RTM_command( RTN_SCENE, RT_Scene::classCMD );

#ifdef RTD_RSY
    RTM_command( RTN_RSY_SCENE, RT_RSYScene::classCMD );
#endif    

    // cameras:
    RTM_command( RTN_ONE_RAY_CAMERA, RT_OneRayCamera::classCMD );
    RTM_command( RTN_LOOKAT_CAMERA, RT_LookatCamera::classCMD );
    RTM_command( RTN_RAY_IMAGE_LOOKAT_CAMERA, RT_RayImageLookatCamera::classCMD );
    
    // etc.:
    RTM_command( RTN_IMAGE_RECORDER, RT_ImageRecorder::classCMD );
    
    // lights:
    RTM_command( RTN_POINT_LIGHT, RT_PointLight::classCMD );
    RTM_command( RTN_AMBIENT_LIGHT, RT_AmbientLight::classCMD );

    // pixmaps:
    RTM_command( RTN_PIXMAP_DISPLAY, RT_PixmapDisplay::classCMD );

    // input devices:
    RTM_command( RTN_LOCATOR, RT_Locator::classCMD );
    RTM_command( RTN_PICK, RT_Pick::classCMD );
    RTM_command( RTN_FILE_DEVICE, RT_FileDevice::classCMD );
    RTM_command( RTN_MANIPULATOR, RT_Manipulator::classCMD );
    RTM_command( RTN_VERTEX_MANIPULATOR, RT_VertexManipulator::classCMD );
    
    // short names:
    RTM_command( RTSN_ORC, RT_OneRayCamera::classCMD );
    RTM_command( RTSN_RILC, RT_RayImageLookatCamera::classCMD );
    RTM_command( RTSN_LC, RT_LookatCamera::classCMD );
    RTM_command( RTSN_PD, RT_PixmapDisplay::classCMD );
    RTM_command( RTSN_PL, RT_PointLight::classCMD );
    RTM_command( RTSN_AL, RT_AmbientLight::classCMD );

    rt_initMathCommands( ip );
    rt_initMappingCommands( ip );
    rt_initImageCommands( ip );
    rt_initTextureCommands( ip );
    
#ifdef RTD_SC
     rt_initScientCommands( ip );
#endif

    // stand-alone utility commands:
    Tcl_CreateCommand (ip, "RT_fixedCoordRot", RT_fixedCoordRotCMD , 0, 0 );
    Tcl_CreateCommand (ip, "RT_fixedCoordScale", RT_fixedCoordScaleCMD , 0, 0 );
    Tcl_CreateCommand (ip, "RT_fixedCoordTrans", RT_fixedCoordTransCMD , 0, 0 );
    Tcl_CreateCommand (ip, "RT_fixedPointRot", RT_fixedPointRotCMD , 0, 0 );
    
    // initialization stuff:
    rt_PackageList = "Primitives ";
    
    return TCL_OK;
}

void RT_exit() {
    delete rt_InputServer;
    delete rt_Objects;
    Tcl_DeleteInterp( rt_Ip ); 
    Tcl_DeleteHashTable( &rt_Hash );
}

char *RT_eval(char *c) {
    Tcl_GlobalEval( rt_Ip, c );
    return rt_Ip->result;
}

RT_GeneralList *RT_primitives() {
    RT_GeneralList *list = new RT_GeneralList;

    class LFunctoid: public RT_GeneralListFunctoid {
	RT_GeneralList *list;
      public:
	LFunctoid(RT_GeneralList *l) { list = l; }
	void exec(RT_GeneralListEntry *e, void * = 0) {
	    // append all non-hidden primitives at a list
	    if ( e->isA( RTN_PRIMITIVE ) && !((RT_Primitive*)e)->get_hide()) list->append( e );
	}
    } func( list );
    rt_Objects->doWithElements( &func );
    return list;
}

