////////////////////////////////////////////////////////////////////////////////
//  Definition of a heightfield - based on a quadmesh.                        //  
//  LAST EDIT: Wed Mar  8 08:52:46 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __HEIGHTFIELD_H__
#define __HEIGHTFIELD_H__

#include "quadmesh.h"

extern const char *RTN_HEIGHT_FIELD;

class RT_HeightField: public RT_Primitive {
    RT_Quadmesh *qm;
    static RT_ParseEntry table[]; 
    //##### statics for parameter parsing:
    static int normF, normG, getXF, getYF, cnF ;
    static RT_Vector normV;

  public:
    void newGeometry(int x, int y) { qm->newGeometry( x, y ); }
    // clears the old arrays of points, surfaces, normals
    // and creates a new empty array
    void computeNormals() { qm->computeNormals(); }

    const RT_Quadmesh *getQuadmesh() {return qm;}

    //##### Tcl/C++ methods:
    RT_HeightField( char *, int X, int Y, const double *, const RT_Surface * = 0, const RT_Vector * = 0);

    int copy(RT_Primitive *) const;

    // inquire dimensions:
    int get_x() const { return qm->get_x(); }
    int get_y() const { return qm->get_y(); }

    // set/get height value:
    void vtValue(int x, int y, double h) {
	RT_Vector v = qm->get_vtPoint( x, y );
	v.y = h;
	qm->vtPoint( x, y, v );
    }
 
    double get_vtValue(int x, int y) const {
	return (qm->get_vtPoint( x, y )).y;
    }
 
    // set the global normal:
    void gnormal(const RT_Vector &v) { qm->gnormal( v ); }

    // return the global normal:
    const RT_Vector &get_gnormal() const { return qm->get_gnormal(); } 

    // set/get surface:
    void vtSurface(int x, int y, const RT_Surface &s) { qm->vtSurface( x, y, s ); }

    const RT_Surface &get_vtSurface(int x, int y) const { 
    // return surface of vertex- if vertex hasnt one return global
	return qm->get_vtSurface( x, y );
    }

    void vtDeleteSurface(int x, int y) { qm->vtDeleteSurface( x, y ); }
	// delete surface at specified vertex

    // set/get normal vector:
    void vtNormal(int x, int y, const RT_Vector &n) { qm->vtNormal( x, y, n ); }

    const RT_Vector &get_vtNormal(int x, int y) const { return qm->get_vtNormal( x, y ); } 

    // get normal of specified vertex
    // if vertex has not a normal - return object global normal
    void vtDeleteNormal( int x, int y ) { qm->vtDeleteNormal( x,y ); }
    // clear normal

    void printCon(FILE *) const;
    void print(FILE *) const;

    const char *get_description() const { return "A heigth field is a uniform two dimensional lattice with a height value at each point. The space between the points is 1.0 in each direction. The height values are mapped to the y coordinate. The object will be centered at the origin of its modeling coordinates system. Vertex (0,0) has the smallest x and z coordinate."; }
    const char *get_class() const { return RTN_HEIGHT_FIELD; }
    int isA(const char *_c) const { return  RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_HEIGHT_FIELD ); }

    //#### raytracer interface:
    int intersect(const RT_Ray&, RT_InterSectionList&);
    void normal(const RT_Vector& R, RT_Vector& N) {qm->normal(R,N);}

    //#### the tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *argv[]);
};

#endif

