#ifndef __USEFUL_PRIM_H__
#define __USEFUL_PRIM_H__

////////////////////////////////////////////////////////////////////////////////
//  Definitions of some hi-level primitives.                                  //  
//  LAST EDIT: Fri Aug  5 08:54:56 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "poly.h"

///// the class AXES

extern const char *RTN_AXES;

class RT_Axes: public RT_Primitive {
    static RT_Vector pts[15];
    static int fl;
  public:
    //##### the Tcl/C++ methods:
    RT_Axes(char *_name): RT_Primitive( _name ) {
	if (!fl) { 
	    fl = 1;
	    int i = 0;
	    pts[i++] = RT_Vector( 0.0, 0.1, 0.9 );
	    pts[i++] = RT_Vector( 0.0, 0.0, 1.0 );
	    pts[i++] = RT_Vector( 0.0, -.1, 0.9 );
	    pts[i++] = RT_Vector( 0.0, 0.0, 1.0 );
	    pts[i++] = RT_Vector( 0.0, 0.0, 0.0 );
	    pts[i++] = RT_Vector( 0.0, 1.0, 0.0 );
	    pts[i++] = RT_Vector( 0.1, 0.9, 0.0 );
	    pts[i++] = RT_Vector( 0.0, 1.0, 0.0 );
	    pts[i++] = RT_Vector( 0.0, 0.9, 0.1 );
	    pts[i++] = RT_Vector( 0.0, 1.0, 0.0 );
	    pts[i++] = RT_Vector( 0.0, 0.0, 0.0 );
	    pts[i++] = RT_Vector( 1.0, 0.0, 0.0 );
	    pts[i++] = RT_Vector( 0.9, 0.1, 0.0 );
	    pts[i++] = RT_Vector( 1.0, 0.0, 0.0 );
	    pts[i++] = RT_Vector( 0.9, -.1, 0.0 );
	}
	(new RT_Polyline( 0, 15, pts ))->father( this );
    }

    const char *get_description() const { return "A simple axes cross lying approx. in the 0-1 area. The y-axis is different from the other axes giving you orientation."; }
    const char *get_class() const { return RTN_AXES; }
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_AXES ); }

    void printCon(FILE *f) const { RT_Object::printCon( f ); }
    void print(FILE *f) const { RT_Primitive::print( f ); }

    RT_Bounds get_bounds() {
	RT_Bounds b;
	b.max.x = b.max.y = b.max.z = 1;
	b.min.x = b.min.z = 0;
	b.min.y = -0.1;
	return b;
    } 

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

extern const char *RTN_TOP;

class RT_Top: public RT_Primitive  {
  public:
    //#### the Tcl/C++ methods:
    RT_Top(char *a = 0) : RT_Primitive( a ) {};
    const char *get_class() const { return RTN_TOP; }
    const char *get_description() const { return "A top object for hierarchical object structures.";}
    int isA(const char *_c) const { return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_TOP ); }
 
    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

#endif
