////////////////////////////////////////////////////////////////////////////////
//  Implementation of image base class.                                       //  
//  LAST EDIT: Fri Aug  5 08:55:28 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "image.h"
#include "pixmap.h"

const char *RTN_IMAGE = "Image";

// image global stuff:

int RT_Image::checkIndices(int _x, int _y ) const {
    if ( (_x < 0 )|| (_x >= xsize) || (_y < 0) || (_y >= ysize) ) {
	rt_Output->errorVar( get_name(), ": zz Indices out of area!", 0 );
	return 0;
    }
    return 1;
}

RT_Color RT_Image::get_icolor(double x, double y) const {
    // this method should be extended to perform a interpolation
    // between the four color values

    RT_Color c;
    if ((x < 0) || (x > 1) || (y < 0) || (y > 1)) {
	rt_Output->errorVar( get_name(), ": Indices out of area!", 0 );
	return c;
    }
    int xx = (int)(x * (xsize-1)); if (xx >= xsize) xx = xsize - 1;
    int yy = (int)(y * (ysize-1)); if (yy >= ysize) yy = ysize - 1;
    return get_color( xx, yy ); 
}

int RT_Image::rdF, RT_Image::wrF, RT_Image::fnF, RT_Image::fnG;
int RT_Image::clF, RT_Image::clG, RT_Image::wiV, RT_Image::wiF;
int RT_Image::wiG, RT_Image::hgV, RT_Image::hgF, RT_Image::hgG;
char *RT_Image::fnV; int RT_Image::icG, RT_Image::extG; 
int RT_Image::pxF; char *RT_Image::pxV;

RT_ParseEntry RT_Image::table[] = {
    { "-read", RTP_NONE, 0, &rdF, "Read from the pixmap file. Returns 1 if successful, 0 else.", RTPS_NONE },
    { "-write", RTP_NONE, 0, &wrF, "Write into the pixmap file. Returns 1 if successful, 0 else.", RTPS_NONE },
    { "-readPixmap", RTP_STRING, (char*)&pxV, &pxF, "Read from a {ARG 1 Pixmap} object.", "Object" },
    { "-filename", RTP_STRING, (char*)&fnV, &fnF, "Set a new {ARG 1 Filename}.", RTPS_FILE },
    { "-get_filename", RTP_NONE, 0, &fnG, "Get the current filename.", RTPS_NONE },
    { "-width", RTP_INTEGER, (char*)&wiV, &wiF, "Set a new {ARG 1 Width} for the image. The old contents will be lost.", RTPS_INTEGER },
    { "-get_width", RTP_NONE, 0, &wiG, "Get the current width of the image.", RTPS_NONE },
    { "-height", RTP_INTEGER, (char*)&hgV, &hgF, "Set a new {ARG 1 Height} for the image. The old contents will be lost.", RTPS_INTEGER },
    { "-get_height", RTP_NONE, 0, &hgG, "Get the current height of the image.", RTPS_NONE },
    { "-color", RTP_SPECIAL, 0, &clF, "Set {ARG 3 Color} on Point {ARG 1 X}, {ARG 2 Y}.", "Integer Integer Color" },
    { "-get_color", RTP_SPECIAL, 0, &clG, "Get the color of Point {ARG 1 X}, {ARG 2 Y}.", "Integer Integer" },
    { "-get_icolor", RTP_SPECIAL, 0, &icG, "Get the color of Point {ARG 1 X}, {ARG 2 Y} by computing a linear interpolation. The range for {ARG 1 X} is {RANGE 1 \"0 1\"}, the range for {ARG 2 Y} is {RANGE 2 \"0 1\"} .", "Double Double" },
    { "-get_extension", RTP_NONE, 0, &extG, "Get the standard file extension of the image.", RTPS_NONE },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Image::objectCMD(char *argv[]) { 
    int ret = 0;
    RT_parseTable( argv, table );
    if (rdF) RT_Object::result( read() ? "1" : "0 " );
    if (wrF) RT_Object::result( write() ? "1" : "0 " );

    if (pxF) {
	RT_Object *obj = RT_Object::getObject( pxV );
	if (obj && obj->isA( RTN_PIXMAP )) { readPixmap( (RT_Pixmap*)obj ); ret++;}
	else rt_Output->errorVar( "No such pixmap object: ", pxV, "! ", 0 );
    }

    if (fnF) filename( fnV );
    if (fnG) RT_Object::result( get_filename() );

    if (wiF) {
	if (wiV > 0) {
	    ret++; width( wiV );
	}
	else rt_Output->error( "Image width must be greater than zero." );
    }
    if (wiG) {
	ret++; char tmp[10];
	RT_int2string( get_width(), tmp );
	RT_Object::result( tmp );
    }

    if (hgF) {
	if (hgV > 0) {
	    ret++; height( hgV );
	}
	else rt_Output->error( "Image height must be greater than zero." );
    }
    if (hgG) {
	ret++; char tmp[10];
	RT_int2string( get_height(), tmp );
	RT_Object::result( tmp );
    }

    { 	int start, diff1 = 0, diff2 = 0, diff3 = 0;
	int posx, posy; RT_Color c;
	if ((start = RT_findString( argv, "-color" )) >= 0) 
	    if ( RT_getInt( &argv[ start + 1 ], posx, diff1) ) 
		if ( RT_getInt( &argv[ start + 2 ], posy, diff2) ) 
		    if ( RT_getColor( &argv[ start + 3 ], c, diff3) )	{ 
			color( posx, posy, c ); ret++; 
		    }
	RT_clearArgv( argv, start, diff1 + diff2 + diff3 );
    }

    { 	int start, diff1 = 0, diff2 = 0;
	int posx, posy;
	if ((start = RT_findString( argv, "-get_color" )) >= 0) 
	    if ( RT_getInt( &argv[ start + 1 ], posx, diff1) ) 
		if ( RT_getInt( &argv[ start + 2 ], posy, diff2) ) {
		    char tmp[60]; ret++;
		    RT_color2string( get_color(posx, posy), tmp );
		    RT_Object::result( tmp );
		}
	RT_clearArgv( argv, start, diff1 + diff2 );
    }

    { 	int start, diff1 = 0, diff2 = 0;
	double posx, posy;
	if ((start = RT_findString( argv, "-get_icolor" )) >= 0) 
	    if ( RT_getDouble( &argv[ start + 1 ], posx, diff1) ) 
		if ( RT_getDouble( &argv[ start + 2 ], posy, diff2) ) {
		    char tmp[60]; ret++;
		    RT_color2string( get_icolor(posx, posy), tmp );
		    RT_Object::result( tmp );
		}
	RT_clearArgv( argv, start, diff1 + diff2 );
    }

    if (extG) RT_Object::result( get_extension() );

    return ret + rdF + wrF + fnF + fnG + extG;
}

void RT_Image::readPixmap(RT_Pixmap *p) {
    p->activate();
    // setup dimensions:
    width( p->getW() ); height( p->getH() );
    for (int i = 0; i < get_width(); i++ )
	for (int j = 0; j < get_height(); j++ )
	    color(i, j, p->getPixel( i, j ));
}



