////////////////////////////////////////////////////////////////////////////////
//  Implementation of set of integers.                                        //  
//  LAST EDIT: Fri Aug  5 08:55:12 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "intset.h"
#include "assert.h"

RT_IntSet::RT_IntSet(int maxsize) {
    pos = 0;
    size = sizeof( long );
    int tmp = size;
    ldsize = 3;
    while ( tmp = tmp >> 1 ) ldsize++;
    size *= 8;
    length = ( maxsize >> ldsize ) + 1;
    array = new long[ length ];
    for (int i = 0; i < length; i++) array[ i ] = 0;
}

void RT_IntSet::setId(int num) {
    int i;
    pos = num >> ldsize;
    if (pos > length-1) { 
	long *tmp= new long[ pos+1 ];
	for (i = 0; i <length ; i++) tmp[ i ] = array[i];
	for (i = length; i < pos+1; i++) tmp[ i ] = 0;
	delete array;
	array = tmp;
	length = pos+1;
    }
    long mask = 1;
    array[pos]=array[pos] | mask << num % size ;
}

void RT_IntSet::firstId() {
    last_Id = -1;
}

int RT_IntSet::getNextId() {
    long value;
    long mask;
    
    if (last_Id == -1) {
	pos = 0;
    } else {
	pos = last_Id >> ldsize;
	mask = 1;
	value = array[pos];
	mask = mask << last_Id-pos+1;
	for ( int i = last_Id-pos+1; i < size; i++) {
	    if ( (value & mask )) {
		last_Id = ( pos << ldsize ) + i;
		return last_Id ;
	    }
	    mask = mask << 1;
	}
	pos++;
    }
    
    for (;pos<length; pos++) {
	mask = 1;
	value = array[pos];
	for ( int i=0; i<size; i++) {
	    if ( (value & mask )) {
		last_Id = ( pos << ldsize ) + i;
		return last_Id ;
	    }
	    mask = mask << 1;
	}
    }
    last_Id = -1;
    return -1;
}


void RT_IntSet::deleteId(int id) {
    pos = id >> ldsize;
    id = id % size;
    long mask = 1;
    for (int i = 0; i < id; i++) mask = mask << 1;
    array[ pos ] = array[ pos ] & ( - 1 - mask);
}

int RT_IntSet::numElements() {
    firstId();
    int num=0;
    while(-1!=getNextId()) { num++; }
    return num;
}


// some test examples for the IntSet:

#ifdef NEVER
#include <stdio.h>
main () {
    int val;
    printf("Set with the size 10 test set get and overflow\n");
    RT_IntSet s(10);
    printf("Number of Elements in Set = %d\n",s.numElements());
    
    s.setId(0);
    s.setId(2);
    s.setId(3);
    s.setId(0);
    s.setId(3);
    printf("Number of Elements in Set = %d\n",s.numElements());
    
    s.firstId();
    while ((val=s.getNextId()) != -1) {
	printf("Test set with 0,2 and 3 get the value: %d\n",val);
    }
    s.deleteId(0);
    printf("Number of Elements in Set = %d\n",s.numElements());
    s.firstId();
    while ((val=s.getNextId()) != -1) {
	printf("Test set with 2 and 3 get the value: %d\n",val);
    }
    s.setId(53);
    s.setId(4711);
    printf("Number of Elements in Set = %d\n",s.numElements());
    s.firstId();
    while ((val=s.getNextId()) != -1) 
	printf("Test set with 2,3,53 and 4711 get the value: %d\n",val);
    s.deleteId(53);
    s.deleteId(4711);
    s.deleteId(2);
    s.deleteId(3);
    printf("Number of Elements in Set = %d\n",s.numElements());
    s.firstId();
    while ((val=s.getNextId()) != -1) {
	printf("fuck you: %d\n",val);
	assert(1);
    }
    printf("Empty set ok!\n");
}

#endif
