////////////////////////////////////////////////////////////////////////////////
// Implementation of the class RT_Object - the essential base class of the    //
// YART system.                                                               //  
// LAST EDIT: Mon Aug  8 10:38:04 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "object.h"

const char *RTN_OBJECT = "Object";

char *RT_Object::printV; int RT_Object::printF;
int RT_Object::classG; int RT_Object::nameG;
int RT_Object::deleteF; int RT_Object::descG;
int RT_Object::kwdG;
int RT_Object::isF; char *RT_Object::isV;
RT_String RT_Object::res(10000);

RT_ParseEntry RT_Object::table[] = {
    { "-get_class", RTP_NONE, 0, &classG, "Get the class name.", RTPS_NONE },
    { "-isA", RTP_STRING, (char*)&isV, &isF, "Returns 1 if it is an object of {ARG 1 Class} or an object of a subclass of {ARG 1 Class}.", RTPS_CLASS },
    { "-get_name", RTP_NONE, 0, &nameG, "Get the object name.", RTPS_NONE }, 
    // only for compatibility to C++ language binding
    { "-get_description", RTP_NONE, 0, &descG, "Get description of the class.", RTPS_NONE },
    { "-get_keywords", RTP_NONE, 0, &kwdG, "Get keywords of the class.", RTPS_NONE },
    { "-print", RTP_STRING, (char*)&printV, &printF, "Print the contents of the object to a file with the descriptor {ARG 1 File}. As file descriptors are supported: stdout and stderr and return values of the Tcl procedure open().", RTPS_STRING },
    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_Object::generalCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    resResult(); 
    // reset the Tcl result

    if (!argv[1]) return TCL_OK;
    
    int fnd = (argc > 1) && !strcmp ( argv[1], RT_HELP ); 
    RT_Object *o = (RT_Object*)cd;
    RT_parseTable( &argv[1], table ); // skip over the first arg

    if (printF) {
	if ( !strcmp( printV, "stdout") ) { o->print( stdout ); fnd++; }
	else if ( !strcmp( printV, "stderr") ) { o->print( stderr ); fnd++; }
	else {
	    FILE *f; 
	    if (Tcl_GetOpenFile( ip, printV, 1, 0, &f ) == TCL_OK) 
		{ fnd++; o->print( f ); }
	}
    }

    if (classG) { result( o->get_class() ); fnd++; }
    if (nameG) { result( o->get_name() ); fnd++; }
    if (kwdG) { result( o->get_keywords() ); fnd++; }
    if (descG) { result( o->get_description() ); fnd++; }
    if (isF) { result( o->isA( isV ) ? "1" : "0" ); fnd++; }

    if (argv[1]) fnd += o->objectCMD( &argv[1] );
    
    if (!fnd ) {
	if (argv[1]) {
	    RT_String rargs(100);
	    char **args = &argv[1];
	    while (*args) {
		rargs += "{";
		rargs += *args++;
		rargs += "} ";
	    }

	    rt_Output->errorVar( argv[0], ": Could not perform any method! Remaining args: ", (char*)rargs, "." , 0 );
	}
	else rt_Output->errorVar( argv[0], ": Could not perform any method!" , 0 );
    }
    
    int len = strlen((char*)getResult());
    if ( !len ) Tcl_SetResult( rt_Ip, "", TCL_VOLATILE );
    else {
	static RT_String xres( 200 );
	char *tmpr = strDup( (char*)getResult() );
	// remove the last whitespace:
	if (tmpr[ len - 1 ] == ' ') tmpr[ len - 1 ] = 0;
	xres = "set {} "; xres += tmpr; 
	if (Tcl_Eval( rt_Ip, (char*)xres ) != TCL_OK) {
	    // there is more than one value in result:
	    xres = "set {} {"; xres += tmpr; xres += "}";
	    Tcl_Eval( rt_Ip, (char*)xres );
	}
	delete tmpr;
    }
    return TCL_OK; 
}

int RT_Object::_classCMD(ClientData, Tcl_Interp *, int argc, char *argv[]) { 
    if (argc < 2 ) return TCL_ERROR;
    if (!strcmp( argv[1], RT_HELP)) return TCL_HELP;
    Tcl_VarEval( rt_Ip, "lsearch [info commands] ", argv[1], NULL);
    int pos, i;
    RT_getInt( &rt_Ip->result, pos, i );
    Tcl_SetResult( rt_Ip, "", TCL_VOLATILE );
    if (pos >= 0) {
	rt_Output->errorVar( "Object ", argv[1], " already exists (or a Tcl command with the same name).", 0 );
	return TCL_ERROR;
    }
    return TCL_OK;
}

void rt_error(char *name) { rt_Output->errorVar( "Object ", name, " already exists!", 0 ); }
// AT&T's cfront doesn't allow to call this errorVar at the place where now rt_error stands
// "error: call of pure virtual function RT_Output::errorVar()" ???

RT_Object::RT_Object( char *_name) {
#ifdef RTD_DEBUG
    fprintf( stderr, "new object %s\n", _name );
#endif
    if (_name) {
	name = new char[strlen(_name) + 1 ];
	strcpy( name, _name );
	
	Tcl_HashEntry *entry = Tcl_FindHashEntry( &rt_Hash, _name );
	if (entry) rt_error( name );
	int i;
	Tcl_CreateHashEntry( &rt_Hash, name, &i )->clientData = (ClientData)this;
	Tcl_CreateCommand( rt_Ip, name, RT_Object::generalCMD, (ClientData)this, NULL ); 
	rt_Objects->append( this );
    }
    else name = 0;
}

RT_Object::~RT_Object() {
#ifdef RTD_DEBUG
    fprintf( stderr, "delete object %s\n", name );
#endif
    class LFunctoid: public RT_GeneralListFunctoid {
	RT_Object *o;
      public:
	LFunctoid(RT_Object *_o): o( _o) {}
	void exec(RT_GeneralListEntry *e, void * ) {
	    ((RT_Object*)e)->objectKilled( o ); }
    } func( this );
    relObjects.doWithElements( &func );

    if (name) {
	rt_Objects->remove( this );
	Tcl_DeleteCommand( rt_Ip, name );
	Tcl_DeleteHashEntry( Tcl_FindHashEntry( &rt_Hash, name ));
	delete name;
    }
}

RT_Object *RT_Object::getObject( const char *x) {
    Tcl_HashEntry *entry = Tcl_FindHashEntry( &rt_Hash, (char*)x );
    return entry ? (RT_Object*)entry->clientData : 0;
}

