#ifndef __POLY_H__
#define __POLY_H__

////////////////////////////////////////////////////////////////////////////////
// Declarations of Point list based output primitives.                        //  
//  LAST EDIT: Tue Mar  7 20:13:32 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "primitiv.h"
#include "vertex.h"
#include "predattr.h"

extern const char *RTN_POLYVERTEX;

class RT_Polyvertex: public RT_Primitive, public RT_GeneralList  {
    static RT_ParseEntry table[];
    void add(const RT_Vector &v, const RT_Surface *s = 0, const RT_Vector *n = 0) {
	append( new RT_Vertex( v, s, n )); 
    }

    //#### the statics for parameter parsing:
    static int vtDelSuV, vtDelSuF, getNumF;
    static int vtGetSuGV, vtGetSuGF, pointGF, pointGV;
    static int delV, delF, vtGetNrGV, vtGetNrGF;
    static int vtDelNrV, vtDelNrF;
    static RT_Vector normV; static int normF, normG;

  protected:
    static int createPoly(Tcl_Interp *, int, char **, int &,RT_Vector *&, RT_Surface *&, RT_Vector *&);
    // create arg lists from ascii lists
    RT_Vector xnormal;    // the default normal:
    int use_xnormal; // use the xnormal if true
    RT_Polyvertex( char *, int, RT_Vector*, RT_Surface* = 0, RT_Vector* = 0);
  public:

    RT_Vertex *get(int) const;
    //#### Tcl/C++ methods:
    virtual ~RT_Polyvertex();
    void printCon(FILE *) const;
    void print(FILE *) const;
    int isA(const char * _c) const {  return RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_POLYVERTEX ); }
    // else ambiguous! 

    int copy(RT_Primitive*) const;

    void gnormal(const RT_Vector &_n) {
	xnormal = _n ;
	use_xnormal = !(_n == RT_NULL_NORMAL);
	primChanged();
    }
    const RT_Vector &get_gnormal() const { return xnormal; }

    int get_number() const;
    // get number of vertexes

    void vtInsert(int, const RT_Vector &, const RT_Surface * = 0, const RT_Vector * = 0);
    // insert at that position 
    void vtDelete(int);
    // delete vt at specified pos

    void vtPoint(int, const RT_Vector&);
    // overwrite point of vertex
    const RT_Vector &get_vtPoint(int) const;
    // get point of vertex

    void vtSurface(int, const RT_Surface&);
    // set surface for specified vertex
    const RT_Surface &get_vtSurface(int) const;
    // get surface of specified vertex
    void vtDeleteSurface(int);
    // delete surface of vt at specified pos
    // if vertex has not surface - return object global surface

    void vtNormal(int, const RT_Vector&);
    // set normal for specified vertex
    const RT_Vector &get_vtNormal(int) const;
    // get normal of specified vertex
    // if vertex has not a normal - return object global normal
    void vtDeleteNormal(int);
    // delete normal of vt at specified pos

    RT_Bounds get_bounds();

    //#### the Tcl methods:
    int objectCMD(char *[]);
};

///// the class POLYMARKER

extern const char *RTN_POLYMARKER;

class RT_Polymarker: public RT_Polyvertex {
  public:
    RT_Polymarker( char *a, int b, RT_Vector *c, RT_Surface *d = 0, RT_Vector *e = 0) :  RT_Polyvertex( a, b, c, d, e) {}
    //#### the generic primitive methods:
    const char *get_description() const { return "A polymarker object containing an ordered set of points."; }
    const char *get_class() const { return RTN_POLYMARKER; }
    int isA(const char * _c) const {  return RT_Polyvertex::isA( _c ) || RTM_isA(_c, RTN_POLYMARKER ); }
    //#### shader interface:
    void render();
    // platform dependend implemented!
    //#### raytracer interface:
    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *argv[]) { return RT_Polyvertex::objectCMD( argv ); }
};

///// the class POLYLINE

extern const char *RTN_POLYLINE;

class RT_Polyline: public RT_Polyvertex {
  public:
    RT_Bounds get_bounds();
    RT_Polyline( char *a, int b, RT_Vector *c, RT_Surface *d = 0, RT_Vector *e = 0) :  RT_Polyvertex( a, b, c, d, e) {}
    //#### the generic primitive methods:
    const char *get_description() const { return "An editable polyline."; }
    const char *get_class() const { return RTN_POLYLINE; }
    int isA(const char * _c) const {  return RT_Polyvertex::isA( _c ) || RTM_isA(_c, RTN_POLYLINE ); }
    //#### shader interface:
    void render();
    // platform dependend implemented!
    //#### raytracer interface:
    int intersect(const RT_Ray &, RT_InterSectionList&);
    void normal(const RT_Vector &P, RT_Vector &N); 
    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
};

///// the class POLYGON

extern const char *RTN_POLYGON;

class RT_Polygon: public RT_Polyvertex, public RT_FillstyleAttrImpl {
    RT_FillstyleAttribute *xfillstyle;
    double dist;// distance of plane
    void create();
    RT_ifunc_ptr ifunc;
    int poly_segs;
    RT_Vector *polygon;
    int poly_valid;
    RT_Vector _normal; // the computed normal
  public:
    RT_Polygon( char *, int, RT_Vector *, RT_Surface * = 0, RT_Vector * = 0);
    virtual ~RT_Polygon();
    //#### the generic primitive methods:
    const char *get_description() const { return "An editable polygon that must be simple and planar. But it can be concave. A global normal may be specified (facet normal) and additionally a normal for each vertex. The vertices should be specified clockwise seen from the top of the normal vector."; }
    const char *get_class() const { return RTN_POLYGON; }
    int isA(const char * _c) const {  return RT_Polyvertex::isA( _c ) || RTM_isA(_c, RTN_POLYGON ); }
    void checkAttributes() { 
	RT_Primitive::checkAttributes();
	if (xfillstyle->isChanged()) geomChanged(); 
    }
    void createReferences(const RT_AttributeList &list) {
	RT_Primitive::createReferences( list );
	// create fillstyle reference:
	RT_FillstyleAttribute *tmp = xfillstyle;
	xfillstyle = (RT_FillstyleAttribute*)list.retraverse( RTN_FILLSTYLE_ATTR, this );
	if (( tmp != xfillstyle) || (*tmp != *xfillstyle)) geomChanged();
    }
    //#### shader interface:
    void render();
    // platform dependend implemented!
    //#### raytracer interface:
    int intersect(const RT_Ray &, RT_InterSectionList&);
    void normal(const RT_Vector &P, RT_Vector &N); 
    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    //#### interface of FILLSTYLE-attribute:
    void fillstyle(int s) {
	xfillstyle = (RT_FillstyleAttribute*)attributes->get( RTN_FILLSTYLE_ATTR );
	if (!xfillstyle) 
	    attributes->insert( xfillstyle = new RT_FillstyleAttribute);
	xfillstyle->fillstyle( s );
    }
    int get_fillstyle() const { return xfillstyle->get_fillstyle(); }
};

#endif
