#ifndef __QUADMESH_H__
#define __QUADMESH_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of the base primitive Quadmesh                                 //  
//  LAST EDIT: Tue Mar  7 15:41:42 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <limits.h>
#include "primitiv.h"
#include "vertex.h"
#include "intrsect.h"

// definition of a simple intersection cache for quadmesh intersection:

class RT_IntersectionCacheEntry {
    RT_IntersectionCacheEntry *next;
    RT_Vector p; // the intersection point
    int i,j; // the cell indices
    int triangle; // the first or second triangle
    RT_Vector n; // the normal
    friend class RT_IntersectionCache;
  public:
    RT_IntersectionCacheEntry(const RT_Vector& _p, const int _i , const int _j ,
			      const int _t, const RT_Vector& _n) {
	next = 0; p = _p; i = _i; j = _j; triangle = _t; n = _n;
    }
    RT_IntersectionCacheEntry(const RT_IntersectionCacheEntry& e) {
	*this = e;
	next = 0;
    }
    const RT_Vector& GetPoint() const {return p;}
    const RT_Vector& GetNormal() const {return n;}
    int Geti() const {return i;}
    int Getj() const {return j;}
    int GetTriangle() const { return triangle; }
};

class RT_IntersectionCache {
    RT_IntersectionCacheEntry *root,*pos;
    int end;
  public:
    RT_IntersectionCache() { root = 0; restart(); }
    ~RT_IntersectionCache();
    void restart() { pos = 0; end = root == 0; }
    int at_end() { return end; }
    const RT_IntersectionCacheEntry* next();
    void add(const RT_IntersectionCacheEntry& e);
};

///// the class Quadmesh

extern const char *RTN_QUADMESH;

class RT_Quadmesh: public RT_Primitive, public RT_FillstyleAttrImpl {
    RT_FillstyleAttribute *xfillstyle;
    static RT_ParseEntry table[]; 
    //##### statics for parameter parsing:
    static int normF, normG, getXF, getYF, cnF;
    static RT_Vector normV;
    //##### private data:
    int x, y;
    RT_Vertex *vertices;
    RT_Vector xnormal;
    // the global normal
    RT_IntersectionCache icache;
  protected:
    void checkAttributes() { 
	RT_Primitive::checkAttributes();
	if (xfillstyle->isChanged()) primChanged(); 
    }
    void createReferences(const RT_AttributeList &list) {
	RT_Primitive::createReferences( list );
	// create fillstyle reference:
	RT_FillstyleAttribute *tmp = xfillstyle;
	xfillstyle = (RT_FillstyleAttribute*)list.retraverse( RTN_FILLSTYLE_ATTR, this );
	if (( tmp != xfillstyle) || (*tmp != *xfillstyle)) primChanged();
    }

  public:

    RT_Vertex *get( int ) const; 
    // get the XX * y + x th element
    RT_Vertex *get( int xx, int yy) const ; 
    // get the [xx,yy]th element
    
   void newGeometry(int X, int Y);
    // clears the old arrays of points, surfaces, normals
    // and creates a new empty array

    //##### Tcl/C++ methods:
    RT_Quadmesh( char *, int X, int Y, const RT_Vector *, const RT_Surface * = 0, const RT_Vector * = 0);
    virtual ~RT_Quadmesh() { if (vertices) delete [] vertices; }
    
    int get_x() const { return x; }
    // return x size
    int get_y() const { return y; }
    // return y size
    
    void gnormal(const RT_Vector &v) { xnormal = v; primChanged();} 
    // set the global normal
    const RT_Vector &get_gnormal() const { return xnormal; } 
    // return the global normal

    void vtPoint(int, int, const RT_Vector&);
    // set point for vertex
    const RT_Vector &get_vtPoint(int, int) const;
    // get point

    void vtSurface(int X, int Y, const RT_Surface &s);
    // set surface for specified vertex
    const RT_Surface &get_vtSurface(int, int ) const;
    // return surface of vertex- if vertex hasnt one return global
    void vtDeleteSurface(int, int);
    // delete surface at specified vertex

    void vtNormal(int, int, const RT_Vector &);
    // set normal for vertex
    const RT_Vector &get_vtNormal(int, int) const;
    // get normal of specified vertex
    // if vertex has not a normal - return object global normal
    void vtDeleteNormal( int, int );
    // clear normal

    const char *get_description() const { return "A quadmesh containing a twodimensional array of points."; }
    const char *get_class() const { return RTN_QUADMESH; }
    int isA(const char *_c) const { return  RT_Primitive::isA( _c ) || RTM_isA(_c, RTN_QUADMESH ); }

    RT_Bounds get_bounds();

    int copy(RT_Primitive *) const;

    void printCon(FILE *) const;
    void print(FILE *) const;
 
    void computeNormals();

    //#### shader interface:
    void render();
    // platform dependent implemented

    //#### raytracer interface:
    int intersect(const RT_Ray&, RT_InterSectionList&);
    int _intersect(int, int, const RT_Ray&, const RT_Ray&,RT_InterSectionList&);
    void normal(const RT_Vector&, RT_Vector &);

#ifdef RTD_RSY
    //#### radiosity interface:
    void toRSY(RT_RSYScene *);
    // insert the primitive and its childs and parts into a radiosity scene
#endif

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *argv[]);

    //#### interface of FILLSTYLE attribute:
    void fillstyle(int s) {
	xfillstyle = (RT_FillstyleAttribute*)attributes->get( RTN_FILLSTYLE_ATTR );
	if (!xfillstyle) 
	    attributes->insert( xfillstyle = new RT_FillstyleAttribute); 
	xfillstyle->fillstyle( s );
    }
    int get_fillstyle() const { return xfillstyle->get_fillstyle(); }
    RT_IntersectionCache* GetICache() {return &icache;}
};

#endif

