#ifndef __RLIST_H__
#define __RLIST_H__

////////////////////////////////////////////////////////////////////////////////
//  Definition of a universal double-linked list. The list has only a few     //
//  methods, but it can be extended easyly with functoids.                    //  
//  LAST EDIT: Tue Mar  7 14:40:34 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "global.h"

class RT_GeneralListEntry {
  public:
    RT_GeneralListEntry() {}
    virtual ~RT_GeneralListEntry() {}
    virtual int operator==(const RT_GeneralListEntry &e) { return this == &e; }
    virtual void print(FILE*) const = 0;
    // output for debugging purpose

    virtual int isA(const char*) const = 0;
};

class RT_GeneralListFunctoid {
  public:
    virtual void exec(RT_GeneralListEntry*,void* = 0)=0;
};

class RT_GeneralListElem {
  public:
    RT_GeneralListEntry* elem;
    RT_GeneralListElem* prev;
    RT_GeneralListElem* next;
    RT_GeneralListElem() { elem = 0; }
};

class RT_GeneralList {
  protected:
    RT_GeneralListElem *root;
    RT_GeneralListElem *last;
  public:
    RT_GeneralList() { root = 0; last = 0; }
    virtual ~RT_GeneralList();
    void append(RT_GeneralListEntry* element) { appendAtEnd( element ); }
    void appendAtBegin(RT_GeneralListEntry*);
    void appendAtEnd(RT_GeneralListEntry*);
    void remove(RT_GeneralListEntry* element){ removeFromBegin( element ); }
    void removeFromBegin(RT_GeneralListEntry*);
    void removeFromEnd(RT_GeneralListEntry*);
    void doWithElements(RT_GeneralListFunctoid*,void* = 0) const;
    virtual void print(FILE*) const;
    int getNumber() const;
    // return number of entries
    virtual void removeAll();
};

#endif

