#ifndef __RS_MVGEN_H__
#define __RS_MVGEN_H__

////////////////////////////////////////////////////////////////////////////////
//                 Root class for matrices and vectors.                       //   
//  LAST EDIT: Fri Aug  5 08:55:08 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //
//              yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "rs_defs.h"
#include "stdio.h"
//#include "alloc.h"

// general class for deriving Vector or Matrix classes (abstract)
class RT_RS_MVGeneral
{ 
protected:
  int nr;      // Number of rows
  int nc;      // Number of columns
  int nelem;  // Number of elements (nr * nc);
  void freet() { if(temp == 'y') freeh(); } //Frees the heap memory if object is a temporary.
public:
  char temp;  // temp = 'y' is vector is temporary, otherwise 'n'
  RT_RS_MVGeneral() {}
  virtual ~RT_RS_MVGeneral() {}
  virtual void freeh() = 0; //Frees the heap memory used for the object.
  int get_rows() { return nr; }
  int get_columns() { return nc; }
  int get_elements() { return nelem; }
};

#endif

