////////////////////////////////////////////////////////////////////////////////
//  Implementation of the Radiosity-YART-Scene.                               //  
//  LAST EDIT: Fri Aug  5 08:55:04 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

const char *RTN_RSY_SCENE = "RSYScene";

#include "rsyscene.h"
#include "rs_pnts.h"
#include "rs_areas.h"

#include "../light.h"
#include "../primitiv.h"

class RT_toRSYLightFunc: public RT_GeneralListFunctoid {
  public:
    void exec(RT_GeneralListEntry *e, void * rsc) {
      if(e->isA( RTN_LIGHT)) ((RT_Light*)e)->toRSY((RT_RSYScene*)rsc); }
};

class RT_toRSYPrimitiveFunc: public RT_GeneralListFunctoid {
  public:
    void exec(RT_GeneralListEntry *e, void * rsc) {
	if (e->isA( RTN_PRIMITIVE )) {
        RT_Primitive *p = ((RT_Primitive*)e);
        if(!p->get_father()) ((RT_Primitive*)e)->toRSYHierarchical((RT_RSYScene*)rsc);
      }
    }
};

int RT_RSYScene::to_rsyF; int RT_RSYScene::divideF; int RT_RSYScene::solveF;
int RT_RSYScene::writeF;            int RT_RSYScene::readF;
int RT_RSYScene::autoF;             int RT_RSYScene::autoG;
int RT_RSYScene::eval_insF;         int RT_RSYScene::eval_insG;
int RT_RSYScene::fastF;             int RT_RSYScene::fastG;
int RT_RSYScene::max_unshootF;      int RT_RSYScene::max_unshootG;
int RT_RSYScene::fast_max_unshootF; int RT_RSYScene::fast_max_unshootG;
int RT_RSYScene::fast_max_areaF;    int RT_RSYScene::fast_max_areaG;
int RT_RSYScene::view_scaleF;       int RT_RSYScene::view_scaleG;
int RT_RSYScene::max_scaleF;        int RT_RSYScene::max_scaleG;
int RT_RSYScene::diff_min_areaF;    int RT_RSYScene::diff_min_areaG;
int RT_RSYScene::ins_min_areaF;     int RT_RSYScene::ins_min_areaG;
int RT_RSYScene::edge_min_areaF;    int RT_RSYScene::edge_min_areaG;
int RT_RSYScene::shadow_min_areaF;  int RT_RSYScene::shadow_min_areaG;
int RT_RSYScene::light_min_areaF;   int RT_RSYScene::light_min_areaG;
int RT_RSYScene::grad_min_areaF;    int RT_RSYScene::grad_min_areaG;
int RT_RSYScene::grad_max_deltaF;   int RT_RSYScene::grad_max_deltaG;
int RT_RSYScene::nr_shootsF;        int RT_RSYScene::nr_shootsG; 
int RT_RSYScene::shootsG; int RT_RSYScene::meshsG; int RT_RSYScene::stateF;
int RT_RSYScene::spar_dimF;         int RT_RSYScene::spar_dimG;
int RT_RSYScene::spar_dimV;

char *RT_RSYScene::fname;
int RT_RSYScene::autoV; int RT_RSYScene::eval_insV;  
int RT_RSYScene::fastV; int RT_RSYScene::nr_shootsV;
double RT_RSYScene::max_unshootV;
double RT_RSYScene::fast_max_unshootV; double RT_RSYScene::fast_max_areaV;
double RT_RSYScene::view_scaleV; double RT_RSYScene::max_scaleV;
double RT_RSYScene::diff_min_areaV; double RT_RSYScene::ins_min_areaV;
double RT_RSYScene::edge_min_areaV; double RT_RSYScene::shadow_min_areaV;
double RT_RSYScene::light_min_areaV;
double RT_RSYScene::grad_min_areaV; double RT_RSYScene::grad_max_deltaV;

RT_ParseEntry RT_RSYScene::table[] = {
    { "-toRSY", RTP_NONE, 0, &to_rsyF,
      "Convert the objects of the scene to the radiosity representation.", RTPS_NONE },

    { "-divide", RTP_NONE, 0, &divideF,
      "Subdivide the polygons of the radiosity scene.", RTPS_NONE },

    { "-solve", RTP_NONE, 0, &solveF,
      "Compute the intensity distribution of the radiosity scene.", RTPS_NONE },

    { "-write", RTP_STRING, (char*)&fname, &writeF,
      "Write the radiosity scene representation to {ARG 1 File}.", RTPS_STRING },
    { "-read", RTP_STRING, (char*)&fname, &readF,
      "Read a radiosity scene representation from {ARG 1 File}.", RTPS_STRING },

    { "-auto", RTP_INTEGER, (char*)&autoV, &autoF,
      "Set the {ARG 1 AutoMeshMode}. Possible values are 0 (off), 1 (on). Default is on.", RTPS_INTEGER },
    { "-get_auto", RTP_NONE, 0, &autoG,
      "Return auto mesh mode.", RTPS_NONE },

    { "-evalnd", RTP_INTEGER, (char*)&eval_insV, &eval_insF,
      "Set the {ARG 1 EvaluationMode }. Possible values are 0 (diffuse only), 1 (diffuse + non-diffuse). Default is 1.", RTPS_INTEGER },
    { "-get_evalnd", RTP_NONE, 0, &eval_insG,
      "Return evaluation mode.", RTPS_NONE },

    { "-fast", RTP_INTEGER, (char*)&fastV, &fastF,
      "Set the {ARG 1 FastConvergenceMode }. Possible values are 0 (off), 1 (on). Default is on.", RTPS_INTEGER },
    { "-get_fast", RTP_NONE, 0, &fastG,
      "Return fast convergence mode.", RTPS_NONE },

    { "-nrshoots", RTP_INTEGER, (char*)&nr_shootsV, &nr_shootsF,
      "Set the {ARG 1 NumberOfIterations }. Default is 300.", RTPS_INTEGER },
    { "-get_nrshoots", RTP_NONE, 0, &nr_shootsG,
      "Return specified number of iterations.", RTPS_NONE },

  { "-spardim", RTP_INTEGER, (char*)&spar_dimV, &spar_dimF,
      "Set the {ARG 1 SpatialPartitioningSolution}. Default is 20 (each dimension).", RTPS_INTEGER
},
    { "-get_spardim", RTP_NONE, 0, &spar_dimG,
      "Return solution of the spatial partitioning structure.", RTPS_NONE },

	
    { "-unshoot", RTP_DOUBLE, (char*)&max_unshootV, &max_unshootF,
      "Set {ARG 1 MaxUnshootValue }. Defines convergence. Default is 0.1.", RTPS_DOUBLE },
    { "-get_unshoot", RTP_NONE, 0, &max_unshootG,
      "Return max. unshoot value.", RTPS_NONE },

    { "-funshoot", RTP_DOUBLE, (char*)&fast_max_unshootV, &fast_max_unshootF,
      "Set {ARG 1 FastMaxUnshootValue }. If fast mode is enabled: upper intensity bound to build a cluster. Default is 5.", RTPS_DOUBLE },
    { "-get_funshoot", RTP_NONE, 0, &fast_max_unshootG,
      "Return fast max. unshoot value.", RTPS_NONE },

    { "-farea", RTP_DOUBLE, (char*)&fast_max_areaV, &fast_max_areaF,
      "Set {ARG 1 FastMaxAreaValue }. If fast mode is enabled: upper area bound to build a cluster. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_farea", RTP_NONE, 0, &fast_max_areaG,
      "Return fast max. area value.", RTPS_NONE },

    { "-dconst", RTP_DOUBLE, (char*)&diff_min_areaV, &diff_min_areaF,
      "Set {ARG 1 MinConstantDiffuseAreaValue } for constant subdivision of diffuse patches. 0 will skip this pass. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_dconst", RTP_NONE, 0, &diff_min_areaG,
      "Return min. constant diffuse area value.", RTPS_NONE },

    { "-ndconst", RTP_DOUBLE, (char*)&ins_min_areaV, &ins_min_areaF,
      "Set {ARG 1 MinConstantNonDiffuseAreaValue } for constant subdivision of non-diffuse patches. 0 will skip this pass. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_ndconst", RTP_NONE, 0, &ins_min_areaG,
      "Return min. constant non-diffuse area value.", RTPS_NONE },

    { "-edge", RTP_DOUBLE, (char*)&edge_min_areaV, &edge_min_areaF,
      "Set {ARG 1 MinEdgeAreaValue } for edge subdivision pass. 0 will skip this pass. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_edge", RTP_NONE, 0, &edge_min_areaG,
      "Return min. edge area value.", RTPS_NONE },

    { "-shadow", RTP_DOUBLE, (char*)&shadow_min_areaV, &shadow_min_areaF,
      "Set {ARG 1 MinShadowAreaValue } for shadow boundaries subdivision pass. 0 will skip this pass. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_shadow", RTP_NONE, 0, &shadow_min_areaG,
      "Return min. shadow area value.", RTPS_NONE },

    { "-light", RTP_DOUBLE, (char*)&light_min_areaV, &light_min_areaF,
      "Set {ARG 1 MinLightAreaValue } for subdivision of primary light sources. 0 will skip this pass. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_light", RTP_NONE, 0, &light_min_areaG,
      "Return min. light area value.", RTPS_NONE },

    { "-gdelta", RTP_DOUBLE, (char*)&grad_max_deltaV, &grad_max_deltaF,
      "Set {ARG 1 MaxIntensityDeltaValue } for subdivision during solution. 0: no subdivision. Default is 1.0.", RTPS_DOUBLE },
    { "-get_gdelta", RTP_NONE, 0, &grad_max_deltaG,
      "Return max. intensity delta value.", RTPS_NONE },

    { "-garea", RTP_DOUBLE, (char*)&grad_min_areaV, &grad_min_areaF,
      "Set {ARG 1 MinAreaValue } for subdivision during solution. 0: no subdivision. Default: Will be generated if auto mesh mode is enabled, else 0.", RTPS_DOUBLE },
    { "-get_garea", RTP_NONE, 0, &grad_min_areaG,
      "Return min. area value.", RTPS_NONE },

    { "-viewscale", RTP_DOUBLE, (char*)&view_scaleV, &view_scaleF,
      "Set {ARG 1 ViewScaleValue }. if value is 0: auto view scale mode is enabled (default).", RTPS_DOUBLE },
    { "-get_viewscale", RTP_NONE, 0, &view_scaleG,
      "Get view scale value.", RTPS_NONE },

    { "-maxscale", RTP_DOUBLE, (char*)&max_scaleV, &max_scaleF,
      "Set {ARG 1 MaxScaleValue }. if value is 0: will be generated (default).", RTPS_DOUBLE },
    { "-get_maxscale", RTP_NONE, 0, &max_scaleG,
      "Get max. scale value.", RTPS_NONE },
    
    { "-get_shoots", RTP_NONE, 0, &shootsG,
      "Return number of iterations.", RTPS_NONE },

    { "-get_meshs", RTP_NONE, 0, &meshsG,
      "Return number of meshs.", RTPS_NONE },

    { "-get_state", RTP_NONE, 0, &stateF,
      "Display state of the radiosity scene representation.", RTPS_NONE },

    { 0, RTP_END, 0, 0, 0, 0 }
};

int RT_RSYScene::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
  int res;
  res = _classCMD(cd, ip, argc, argv);
  if (res == TCL_HELP) {
	  Tcl_AppendResult( ip, "{", RTN_RSY_SCENE, " {String} {Creates a new radiosity scene called {ARG 1 Name}.}}", 0 );
	  return TCL_OK;
  }
  if ( res  == TCL_OK ) {  
      new RT_RSYScene( argv[1] ); 
      RTM_classReturn;
  }
  return res; 
}

int RT_RSYScene::objectCMD(char *argv[])
{ 
  int ret = RT_Scene::objectCMD(argv);
  RT_parseTable(argv, table);

  if (to_rsyF) { toRSY(); ret++; }
  if (divideF) { rscene->Areas->subdivide_init(); ret++; }
  if (solveF) { rscene->Points->shoot(); ret++; }
  if (writeF) { rscene->write(fname); ret++; }
  if (readF) { rscene->read(fname); ret++; }
  if (autoF) { rscene->Areas->auto_mesh = autoV > 0 ? 1 : 0; ret++; }
  if (autoG) {
      static char tmp[20]; ret++;
      RT_int2string(rscene->Areas->auto_mesh, tmp);
      RT_Object::result(tmp);
  }
  if (eval_insF) {
      rscene->Points->cur_eval_ins = eval_insV > 0 ? 1 : 0; ret++;
  }
  if (eval_insG) {
      static char tmp[20]; ret++;
      RT_int2string(rscene->Points->cur_eval_ins, tmp);
      RT_Object::result(tmp);
  }
  if (nr_shootsF) {
      rscene->Points->nr_shoots = nr_shootsV < 1 ? 1 : nr_shootsV; ret++;
  }
  if (nr_shootsG) {
      static char tmp[20]; ret++;
      RT_int2string(rscene->Points->nr_shoots, tmp);
      RT_Object::result(tmp);
  }

  if (spar_dimF) {
      rscene->Points->spar_dim = spar_dimV < 1 ? 1 : spar_dimV; ret++;
      rscene->Points->init_spatpar();
  }
  if (spar_dimG) {
      static char tmp[20]; ret++;
      RT_int2string(rscene->Points->spar_dim, tmp);
      RT_Object::result(tmp);
  }

  if (fastF) {
      rscene->Points->fast = fastV > 0 ? 1 : 0; ret++;
  }
  if (fastG) {
      static char tmp[20]; ret++;
      RT_int2string(rscene->Points->fast, tmp);
      RT_Object::result(tmp);
  }
  if (max_unshootF) {
      rscene->Points->max_unshoot = (float)max_unshootV; ret++;
  }
  if (max_unshootG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Points->max_unshoot, tmp);
      RT_Object::result(tmp);
  }
  if (fast_max_unshootF) {
      rscene->Points->fast_max_unshoot = (float)fast_max_unshootV; ret++;
  }
  if (fast_max_unshootG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Points->fast_max_unshoot, tmp);
      RT_Object::result(tmp);
  }
  if (fast_max_areaF) {
      rscene->Points->fast_max_area = (float)fast_max_areaV; ret++;
  }
  if (fast_max_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Points->fast_max_area, tmp);
      RT_Object::result(tmp);
  }
  if (diff_min_areaF) {
      rscene->Areas->diff_min_area = (float)diff_min_areaV; ret++;
  }
  if (diff_min_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->diff_min_area, tmp);
      RT_Object::result(tmp);
  }
  if (ins_min_areaF) {
      rscene->Areas->ins_min_area = (float)ins_min_areaV; ret++;
  }
  if (ins_min_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->ins_min_area, tmp);
      RT_Object::result(tmp);
  }
  if (edge_min_areaF) {
      rscene->Areas->edge_min_area = (float)edge_min_areaV; ret++;
  }
  if (edge_min_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->edge_min_area, tmp);
      RT_Object::result(tmp);
  }
  if (shadow_min_areaF) {
      rscene->Areas->shadow_min_area = (float)shadow_min_areaV; ret++;
  }
  if (shadow_min_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->shadow_min_area, tmp);
      RT_Object::result(tmp);
  }
  if (light_min_areaF) {
      rscene->Areas->light_min_area = (float)light_min_areaV; ret++;
  }
  if (light_min_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->light_min_area, tmp);
      RT_Object::result(tmp);
  }
  if (grad_max_deltaF) {
      rscene->Areas->grad_max_delta = (float)grad_max_deltaV; ret++;
  }
  if (grad_max_deltaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->grad_max_delta, tmp);
      RT_Object::result(tmp);
  }
  if (grad_min_areaF) {
    rscene->Areas->grad_min_area = (float)grad_min_areaV; ret++;
  }
  if (grad_min_areaG) {
      static char tmp[20]; ret++;
      RT_float2string(rscene->Areas->grad_min_area, tmp);
      RT_Object::result(tmp);
  }
  if (view_scaleF) {
    rscene->Points->view_scale = (float)view_scaleV;  //0 = auto mode
    ret++;
  }
  if (view_scaleG) {
      ret++;
      static char tmp[20];
      RT_float2string(rscene->Points->view_scale, tmp);
      RT_Object::result(tmp);
  }
  if (max_scaleF) {
      rscene->Points->max_scale = (float)max_scaleV;  //0 = auto mode
      ret++;
  }
  if (max_scaleG) {
      ret++;
      static char tmp[20];
      RT_float2string(rscene->Points->max_scale, tmp);
      RT_Object::result(tmp);
  }
  if (shootsG) {
      static char tmp[20]; ret++;
      RT_int2string(rscene->Points->shoots, tmp);
      RT_Object::result(tmp);
  }
  if (meshsG) {
      char static tmp[20]; ret++;
      RT_long2string(rscene->Areas->get_mesh_nr(), tmp);
      RT_Object::result(tmp);
  }
  if (stateF) {
      rscene->print(stderr, "State of the radiosity scene representation:", 12, 6);
    ret++;
  }
  return ret;
}

RT_RSYScene::RT_RSYScene(char *_name) : RT_Scene(_name) {
  char *rs_name = new char[strlen(_name) + 1];
  strcpy(rs_name, _name);
  rscene = new RT_RS_Scene(rs_name, NULL, NULL, NULL);
}

void RT_RSYScene::toRSY() {
  rscene->clear();  //clear the contents of the radiosity scene
  RT_toRSYLightFunc lfunc;
  RT_toRSYPrimitiveFunc pfunc;
  update();
  doWithElements(&lfunc, this);    //convert lights
  doWithElements(&pfunc, this);    //convert primitivs
#ifdef RS_DEBUG
  rscene->Areas->check_mesh();
#endif
  rscene->Points->init_spatpar(); //initialize spatial partitioning structure
}


