#ifndef __RSYSCENE_H__
#define __RSYSCENE_H__

////////////////////////////////////////////////////////////////////////////////
//  This class provides the (Tcl) interface between the radiosity and YART.   //  
//  LAST EDIT: Fri Aug  5 08:55:07 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include "../scene.h"
#include "rs_scene.h"
#include "rs_pnts.h"
#include "rs_areas.h"

extern const char *RTN_RSY_SCENE;

class RT_RSYScene : public RT_Scene {
    static RT_ParseEntry table[];
    //##### statics for parameter parsing:
    static int to_rsyF, divideF, solveF, writeF, readF, autoF, autoG,
    eval_insF, eval_insG, fastF, fastG,
    max_unshootF, max_unshootG,
    fast_max_unshootF, fast_max_unshootG, fast_max_areaF, fast_max_areaG,
    view_scaleF, view_scaleG, max_scaleF, max_scaleG,
    diff_min_areaF, diff_min_areaG, ins_min_areaF, ins_min_areaG,
    edge_min_areaF, edge_min_areaG, shadow_min_areaF, shadow_min_areaG,
    light_min_areaF, light_min_areaG,
    grad_min_areaF, grad_min_areaG, grad_max_deltaF, grad_max_deltaG,
    shootsG, meshsG, stateF, nr_shootsF, nr_shootsG, spar_dimF, spar_dimG,
    autoV, eval_insV, fastV, nr_shootsV, spar_dimV;
    static char *fname;
    static double max_unshootV, fast_max_unshootV, fast_max_areaV, view_scaleV, max_scaleV,
    diff_min_areaV, ins_min_areaV, edge_min_areaV, shadow_min_areaV,
    light_min_areaV, grad_min_areaV, grad_max_deltaV;  
    RT_RS_Scene* rscene;  //points to the radiosity representation of the scene
  public:
    //##### the public methods:
    RT_RSYScene(char *_name);
    ~RT_RSYScene() { delete rscene; }
    const char *get_description() const { return "A Scene with an interface to radiosity."; }
    int isA(const char *n) const { return RT_Scene::isA( n ) || RTM_isA( n, RTN_RSY_SCENE); }
    const char *get_class() const { return RTN_RSY_SCENE; }
    RT_RS_Scene* get_rscene() { return rscene; }
    void toRSY();   // convert to radiosity description
    //#### the tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 
    int objectCMD(char *[]);
};

#endif

