//  LAST EDIT: Fri Aug  5 13:29:25 1994 by ekki(@prakinf.tu-ilmenau.de)
#include "fisher.h"


void InitMesh() // delete it later !!
{
  /* Speicher fuer Mesh besorgen     */
  static boolean newinit = true;   /* statische Var.: Speicher da    */
  int x;

  if (!newinit)
    return;
  for (x = 0; x <= maxPnts; x++) { /* Speicher holen  */
    _WrkArr[x] = (_MeshPntTyp *)malloc(sizeof(_MeshLineTyp));
    if(_WrkArr[x] == NULL)
      GraphError("InitMesh: nicht genug Speicher");
  }
  newinit = false;   /* Speicher ist da */
}

void InitXYMesh(int xs , int ys)
{
  /* Speicher fuer Mesh besorgen     */
  int i;

  for (i = 0; i < xs; i++) { /* Speicher holen  */
    _WrkArr[i] = (_MeshPntTyp *)malloc(ys*sizeof(_MeshPntTyp));
    if(_WrkArr[i] == NULL)
      GraphError("InitMesh: nicht genug Speicher");
  }
}

void DeleteXYMesh(int xs, int ) // ysize not used 
{
  int i;

  for (i = 0; i < xs; i++)  // delete mesharrays
    free(_WrkArr[i]);
 
}

void PutInMesh(long x, long y, vertex *p)
{
  /* Punkt p in Mesh[x,y] speichern */
  _WrkArr[x][y].a = *p;
}

void CLineP_Interpol(double t, vct4 a, vct4 *b)
{
  b->w = a.w + t * (b->w - a.w);
  b->x = a.x + t * (b->x - a.x);
  b->y = a.y + t * (b->y - a.y);
  b->z = a.z + t * (b->z - a.z);
}

boolean CLineP_ClipIt(double g1, double g2, vct4 *a, vct4 *b)
{
  double t;
  if (g1 > 0) {
    if (g2 <= 0) {
      t = g1 / (g1 - g2);
      CLineP_Interpol(t, *a, b);
    }
  }
  if (g2 <= 0)
    return (g1 > 0 || g2 > 0);  if (g1 <= 0) {
    t = g2 / (g2 - g1);
    CLineP_Interpol(t, *b, a);
  }
  return (g1 > 0 || g2 > 0);
}


void CLineP(vct4 a, vct4 b)
{
  /* Funktion siehe Cline (CLIPPING.INC).
     Unterschied: Wenn ein Begrenzungsvolumen definiert ist, wird nur an den
     noetigen Begrenzungsflaechen geclippt. Vorteil: schneller als Cline       */
  double x1, y1, x2, y2;

  if (!((ClipMode == inside) ||
       ((ClipMode == toClip) &&
        (((VolClipCode &  1) == 0) || CLineP_ClipIt(a.w - a.y, b.w - b.y, &a, &b)) &&
        (((VolClipCode &  2) == 0) || CLineP_ClipIt(      a.y,       b.y, &a, &b)) &&
        (((VolClipCode &  4) == 0) || CLineP_ClipIt(a.w - a.x, b.w - b.x, &a, &b)) &&
        (((VolClipCode &  8) == 0) || CLineP_ClipIt(      a.x,       b.x, &a, &b)) &&
        (((VolClipCode & 16) == 0) || CLineP_ClipIt(a.w - a.z, b.w - b.z, &a, &b)) &&
   	    (((VolClipCode & 32) == 0) || CLineP_ClipIt(      a.z,       b.z, &a, &b))
       ))
     )
    return;
  NPCtoDC(a, &x1, &y1);
  NPCtoDC(b, &x2, &y2);
  line2d(x1, y1, x2, y2);
}


void DefineClipVolume(float xm, float ym, float zm)
{
  /* Eckpunkte des Wuerfels [(-xm,xm);(-ym,ym);(-zm,zm)] als Begrenzungswuerfel
     fuer Mesh definiern.
     DefineClipVolume berechnet anhand des Wuerfels den Modus des Meshes
     (inside,outside,toClip). Vorgehen: Transformation der Eckpunkte des
     Umgebungswuerfels ins NPC und setzen der entsprechenden Bits in
     VolClipCode, wenn Punkt auszerhalb der der Begrenzungsflaechen des
     Einheitswuerfels. Wenn in der Variablen out nach dem Durchlauf der
     Schleife eines der unteren sechs Bit nicht(!) gesetzt ist, so bedeutet
     dies, dasz keiner der acht Eckpunkte des Umgebungsvolumens innerhalb des
     Einheitswuerfels (NPC) ist. ClipMode ist dann outside.                   */
  vct3 a;
  vct4 h;
  int i, out;

  updateMats();    /* Matrizen aktualisieren, damit MCtoNPC funktioniert  */
  VolClipCode = 0; /* VolClipCode initialisieren */
  out = 0;         /* out initialisieren         */
  for (i = 0; i <= 7; i++) {  /* fuer die acht Eckpunkte:    */
    if ((i & 1) == 1)
      a.x = -xm;
    else
      a.x = xm;
    if ((i & 2) == 2)
      a.y = -ym;
    else
      a.y = ym;
    if ((i & 4) == 4)
      a.z = -zm;
    else
      a.z = zm;
    MCtoNPC(a, &h);   /* ins NPC                    */
    /* Je nach dem ob innen oder auszen die entsprechenden Bits setzen:     */
    if (h.y > h.w)
      VolClipCode |= 1;
    else
      out |= 1;
    if (h.y < 0)
      VolClipCode |= 2;
    else
      out |= 2;
    if (h.x > h.w)
      VolClipCode |= 4;
    else
      out |= 4;
    if (h.x < 0)
      VolClipCode |= 8;
    else
      out |= 8;
    if (h.z > h.w)
      VolClipCode |= 16;
    else
      out |= 16;
    if (h.z < 0)
      VolClipCode |= 32;
    else
      out |= 32;
  }
  /* ClipMode setzen: */
  if (VolClipCode == 0) {
    ClipMode = inside;
    return;
  }
  if (out < 0x3f)
    ClipMode = outside;
  else
    ClipMode = toClip;
}


void UnDefClipVolume()
{
  /* Dient zum Zuruecksetzen der Parameter fuer Umgebungsklippen und sollte
     beim Verlassen von Routinen aufgerufen werden, die mit DefineClipVolume
     einen Umgebungswuerfel definieren */
  VolClipCode = 0xff;   /* Alle Bits an zum Clippen */
  ClipMode = toClip;   /* Clippen noetig            */
}


/* Local variables for Mesh: */
typedef long IndArrTyp[8];
struct LOC_Mesh {
  long pc;
  _MeshPntTyp Pol[8], CPol[8];   /* Temporaere Polygone  */
  IndArrTyp IndArr;
} ;

void MCtoWCifNeed(_MeshPntTyp *P)
{
  /* transformiert P ins WC (Koordinaten, Normalen u. Farbe),
     wenn er nicht schon dort ist                                          */
  if (!P->isInWC) {
    MCtoWC_vertex(P->a, &P->a);
    P->isInWC = true;
  }
}

/* Local variables for MeshPol: */
struct LOC_MeshPol {
  struct LOC_Mesh *LINK;
  _MeshPntTyp preP, aktP, firP;
  float t;
  IndArrTyp OldIndArr;
} ;

/* Aehnlich wie aus Pol durch das Clippen CPol
                           entsteht, wird aus OldIndArr IndArr       */

void MeshPol_Interpol(_MeshPntTyp *intP, _MeshPntTyp *aktP,
                      struct LOC_MeshPol *LINK)
{
  /* Siehe Interpol in PolyClip
     Unterschied: Transformation ins WC nur dann, wenn nicht schon da.   */
  /* neuer Punkt im NPC (nur Koordinaten): */
  intP->h.w = LINK->preP.h.w + LINK->t * (aktP->h.w - LINK->preP.h.w);
  intP->h.x = LINK->preP.h.x + LINK->t * (aktP->h.x - LINK->preP.h.x);
  intP->h.y = LINK->preP.h.y + LINK->t * (aktP->h.y - LINK->preP.h.y);
  intP->h.z = LINK->preP.h.z + LINK->t * (aktP->h.z - LINK->preP.h.z);
  MCtoWCifNeed(&LINK->preP);
  MCtoWCifNeed(aktP);
  intP->a.crd.x = LINK->preP.a.crd.x +
		  LINK->t * (aktP->a.crd.x - LINK->preP.a.crd.x);
  intP->a.crd.y = LINK->preP.a.crd.y +
		  LINK->t * (aktP->a.crd.y - LINK->preP.a.crd.y);
  intP->a.crd.z = LINK->preP.a.crd.z +
		  LINK->t * (aktP->a.crd.z - LINK->preP.a.crd.z);
  intP->a.nrm.x = LINK->preP.a.nrm.x +
		  LINK->t * (aktP->a.nrm.x - LINK->preP.a.nrm.x);
  intP->a.nrm.y = LINK->preP.a.nrm.y +
		  LINK->t * (aktP->a.nrm.y - LINK->preP.a.nrm.y);
  intP->a.nrm.z = LINK->preP.a.nrm.z +
		  LINK->t * (aktP->a.nrm.z - LINK->preP.a.nrm.z);
  if (DoNorm(&intP->a.nrm))
    GraphError("Normale durch Clippen=(0,0,0)");
  intP->a.c.r = LINK->preP.a.c.r + LINK->t * (aktP->a.c.r - LINK->preP.a.c.r);
  intP->a.c.g = LINK->preP.a.c.g + LINK->t * (aktP->a.c.g - LINK->preP.a.c.g);
  intP->a.c.b = LINK->preP.a.c.b + LINK->t * (aktP->a.c.b - LINK->preP.a.c.b);
  intP->isInWC = true;   /* merken, dass neuer Punkt in der Welt */
  intP->isInNPC = true;   /* merken, dass neuer Punkt im NPC      */
  intP->isInDC = false;   /* merken, dass neuer Punkt nicht im DC */
}

void MeshPol_DoClip(long i, double g1, double g2, struct LOC_MeshPol *LINK)
{
  /* Siehe DoClip in PolyClip
     Unterschied: Der Index des Punktes, der geclippt wird, wird in
     IndArr gespeichert (-1, wenn neuer Punkt)                           */
  LINK->aktP = LINK->LINK->Pol[i];
  if (i == 0) {
    LINK->firP = LINK->aktP;
    LINK->LINK->pc = 0;
  } else if (g1 > 0 && g2 <= 0 || g1 <= 0 && g2 > 0) {
    LINK->t = g1 / (g1 - g2);
    LINK->LINK->IndArr[LINK->LINK->pc] = -1;
	/* neuer Punkt, deshalb Index=-1 */
    MeshPol_Interpol(&LINK->LINK->CPol[LINK->LINK->pc], &LINK->aktP, LINK);
    LINK->LINK->pc++;
  }
  LINK->preP = LINK->aktP;
  if (g2 <= 0)
    return;
  LINK->LINK->CPol[LINK->LINK->pc] = LINK->aktP;
  LINK->LINK->IndArr[LINK->LINK->pc] = LINK->OldIndArr[i];
      /* Index eintragen */
  LINK->LINK->pc++;
}

boolean MeshPol_LastClip(double g1, double g2, struct LOC_MeshPol *LINK)
{
  /* Siehe Lastlip in PolyClip
     Unterschied: Der Index des Punktes, der geclippt wird, wird in
     IndArr gespeichert (-1, wenn neuer Punkt)                           */
  long i, FORLIM;

  if (g1 > 0 && g2 <= 0 || g1 <= 0 && g2 > 0) {
    LINK->t = g1 / (g1 - g2);
    LINK->LINK->IndArr[LINK->LINK->pc] = -1;
	/* neuer Punkt, deshalb Index=-1 */
    MeshPol_Interpol(&LINK->LINK->CPol[LINK->LINK->pc], &LINK->firP, LINK);
    LINK->LINK->pc++;
  }
  FORLIM = LINK->LINK->pc;
  for (i = 0; i < FORLIM; i++)
    LINK->LINK->Pol[i] = LINK->LINK->CPol[i];
  memcpy(LINK->OldIndArr, LINK->LINK->IndArr, sizeof(IndArrTyp));
      /* OldIndArr -> IndArr kopieren  */
  return (LINK->LINK->pc == 0);
}

void MeshPol(struct LOC_Mesh *LINK)
{
  /* Clippt und zeichnet das Viereck, dasz in Pol abgespeichert ist.
     Das Prinzip ist das selbe wie in PolyClip
     Unterschied: die Punkte werden nur dann transformiert, wenn sie es nicht
     schon sind. Da dasz i.A. bei drei von vier Punkten der Fall ist, kann
     erhebliche Rechenzeit gespart werden.
     Zweiter Unterschied: Es wird nur an den Ebenen geclippt, die in
     CalcVolClipCode bestimmt wurden. Da die meisten Objekte ganz oder gar
     nicht zu sehen sind, wird noch einmal erheblich Rechenzeit gespart.   */
  static struct LOC_MeshPol V;
  long i, FORLIM;
  _MeshPntTyp *WITH;
  SHD_VTX *WITH1;
  rgbB hc;

  V.LINK = LINK;
  /* Viereck sichtbar? */
  if (ClipMode == outside ||
      !(LINK->Pol[0].isVis || LINK->Pol[1].isVis || LINK->Pol[2].isVis ||
	LINK->Pol[3].isVis))
  {   /* Polygon ganz auszerhalb? */
    LINK->pc = 0;   /* Das wars denn!   */
    return;
  }
  /* Rueckflaeche?             */
  /* Viereck in NPC, wenn nicht schon da: */
  for (i = 0; i <= 3; i++) {
    WITH = &LINK->Pol[i];
    V.OldIndArr[i] = i;
    LINK->IndArr[i] = i;
    if (!WITH->isInNPC) {
      MCtoNPC(WITH->a.crd, &WITH->h);
      WITH->isInNPC = true;
    }
  }
  /* Viereck clippen: */
  if (ClipMode == toClip) {  /* clippen noetig?        */
    if ((VolClipCode & 1) == 1) {  /* oben clippen noetig?   */
      FORLIM = LINK->pc;
      for (i = 0; i < FORLIM; i++)
	      MeshPol_DoClip(i, V.preP.h.w - V.preP.h.y,
		  LINK->Pol[i].h.w - LINK->Pol[i].h.y, &V);
      if (MeshPol_LastClip(V.preP.h.w - V.preP.h.y, V.firP.h.w - V.firP.h.y, &V))
	      return;
    }
    if ((VolClipCode & 2) == 2) {  /* unten clippen noetig?  */
      FORLIM = LINK->pc;
      for (i = 0; i < FORLIM; i++)
	      MeshPol_DoClip(i, V.preP.h.y, LINK->Pol[i].h.y, &V);
      if (MeshPol_LastClip(V.preP.h.y, V.firP.h.y, &V))
	      return;
    }
    if ((VolClipCode & 4) == 4) {  /* rechts clippen noetig? */
      FORLIM = LINK->pc;
      for (i = 0; i < FORLIM; i++)
	      MeshPol_DoClip(i, V.preP.h.w - V.preP.h.x,
		  LINK->Pol[i].h.w - LINK->Pol[i].h.x, &V);
      if (MeshPol_LastClip(V.preP.h.w - V.preP.h.x, V.firP.h.w - V.firP.h.x, &V))
	      return;
    }
    if ((VolClipCode & 8) == 8) {  /* links clippen noetig?  */
      FORLIM = LINK->pc;
      for (i = 0; i < FORLIM; i++)
	      MeshPol_DoClip(i, V.preP.h.x, LINK->Pol[i].h.x, &V);
      if (MeshPol_LastClip(V.preP.h.x, V.firP.h.x, &V))
	      return;
    }
    if ((VolClipCode & 16) == 16) {  /* vorne clippen noetig?  */
      FORLIM = LINK->pc;
      for (i = 0; i < FORLIM; i++)
	      MeshPol_DoClip(i, V.preP.h.w - V.preP.h.z,
		  LINK->Pol[i].h.w - LINK->Pol[i].h.z, &V);
      if (MeshPol_LastClip(V.preP.h.w - V.preP.h.z, V.firP.h.w - V.firP.h.z, &V))
	      return;
    }
    if ((VolClipCode & 32) == 32) {  /* hinten clippen noetig? */
      FORLIM = LINK->pc;
      for (i = 0; i < FORLIM; i++)
	      MeshPol_DoClip(i, V.preP.h.z, LINK->Pol[i].h.z, &V);
      if (MeshPol_LastClip(V.preP.h.z, V.firP.h.z, &V))
	      return;
    }
  }
  FORLIM = LINK->pc;
  /* alle Punkte, die noch nicht in der Welt sind, dort hin.
     Dann ins DC und Lighting, wenn nicht schon passiert.              */
  for (i = 0; i < FORLIM; i++) {
    WITH = &LINK->Pol[i];
    WITH1 = &LINK->Pol[i].l;
    MCtoWCifNeed(&LINK->Pol[i]);
    if (!WITH->isInDC) {
      WCtoDC(WITH->a.crd, &WITH1->x, &WITH1->y, &WITH1->z);
      hc.r = (uchar)WITH1->c.r;
      hc.g = (uchar)WITH1->c.g;
      hc.b = (uchar)WITH1->c.b;
      DoLight(WITH->a, &hc);
      WITH1->c.r = hc.r;
      WITH1->c.g = hc.g;
      WITH1->c.b = hc.b;
      WITH->isInDC = true;
    }
  }
  FORLIM = LINK->pc;

  if(FORLIM < 1) return;

  /* Shading: */
    int j;
    if (TriFillEnable)
    	for (j = 2; j < FORLIM; j++) FillTria(LINK->Pol[0].l, LINK->Pol[j - 1].l, LINK->Pol[j].l);
    else {
           for (j = 0; j < FORLIM-1; j++) FillTria(LINK->Pol[j].l, LINK->Pol[j+1].l, LINK->Pol[j+1].l);
           FillTria(LINK->Pol[0].l, LINK->Pol[j].l, LINK->Pol[j].l);           
    }

//  for (i = 2; i < FORLIM; i++)
//    FillTria(LINK->Pol[0].l, LINK->Pol[i - 1].l, LINK->Pol[i].l);
}


void Mesh(long nx, long ny)
{
  /* Zeichnet ein Mesh mit nx*ny Punkten. Die Punkte muessen vorher mit
     PutInMesh definiert werden                                              */
  struct LOC_Mesh V;
  long i, ind, x, y, xx, yy;
  /* Pol wird vor dem Clippen mit vier Eckpunkten (Index 0..3) gefuellt
     und dann geclippt. Hierbei kann maximal ein Achteck entstehen.
     (Ich hab zumindest noch nichts anderes erlebt. Aufruf an den geneigten
     Mathematiker: Wieviele Schnittpunkte koennen die Kanten eines konvexen,
     nicht unbedingt planaren Vierecks mit einem Einheiswuerfel haben?
     Loesungen bitte an die c't-Redaktion)
     Die Werte in Indarr geben an, ob ein Punkt des geclippten Polygons
     identisch mit einem Punkt des urspruenglichen Polygons ist. Wenn ja,
     so gilt: IndArr[i]=k mit k>0
              Der i-te Punkt in Pol nach dem clippen ist identisch mit dem
              k-ten Punkt in Pol vor dem clippen.
              (k=-1: Punkt ist bei Clippen neu entstanden)               */
  boolean b1, b2, b3;
      /* Flags fuer Wireframe: Pkt. des Dreiecks sichtbar   */
  _MeshPntTyp *WITH;
  long FORLIM2;
  SHD_VTX *WITH1;
  rgbB hc;

  updateMats();   /* Matrizen aktualisieren               */
  for (x = 0; x < nx; x++) {  /* Mesh  flippen und Status eintragen:  */
    for (y = 0; y < ny; y++) {
      WITH = &_WrkArr[x][y];
      WITH->isVis = FlipNormal(&WITH->a);
      WITH->isInNPC = false;
      WITH->isInWC = false;
      WITH->isInDC = false;
    }
  }
  if (ClipMode == inside)   /* ClipMode=inside */
  {  /* Mesh braucht nicht geclippt werden:  */
    if (WireFrame)   /* if wireframe */
    {  /* Drahtmodell?    */
      for (x = 0; x <= nx - 2; x++) {
	      for (y = 0; y <= ny - 2; y++) {
	        b1 = _WrkArr[x][y].isVis;   /* Punkt sichtbar? */
	        b2 = _WrkArr[x][y + 1].isVis;   /* Punkt sichtbar? */
	        b3 = _WrkArr[x + 1][y].isVis;   /* Punkt sichtbar? */
	        if (b1 || b2 || b3) {
	          WITH = &_WrkArr[x][y];
	          if (!WITH->isInDC) {
	            MCtoDCi(WITH->a.crd, &WITH->l.x, &WITH->l.y);
	            WITH->isInDC = true;
	          }
	        }
	        if (b1 || b2) {
	          WITH = &_WrkArr[x][y + 1];
	          if (!WITH->isInDC) {
	            MCtoDCi(WITH->a.crd, &WITH->l.x, &WITH->l.y);
	            WITH->isInDC = true;
	          }
            RGB_Line((int)_WrkArr[x][y].l.x, (int)_WrkArr[x][y].l.y,
                     (int)_WrkArr[x][y + 1].l.x, (int)_WrkArr[x][y + 1].l.y,
                     255, 255, 255);
	        }
	        if (b1 || b3) {
	          WITH = &_WrkArr[x + 1][y];
	          if (!WITH->isInDC) {
	            MCtoDCi(WITH->a.crd, &WITH->l.x, &WITH->l.y);
	            WITH->isInDC = true;
	          }
            RGB_Line((int)_WrkArr[x][y].l.x, (int)_WrkArr[x][y].l.y,
                     (int)_WrkArr[x + 1][y].l.x, (int)_WrkArr[x + 1][y].l.y,
                     255, 255, 255);
	        }
	      }  /* for y */
      }  /* for x */
      return;
    }
    for (x = 0; x <= nx - 2; x++) {
      for (y = 0; y <= ny - 2; y++) {
	      if (_WrkArr[x][y].isVis || _WrkArr[x + 1][y].isVis ||
	          _WrkArr[x][y + 1].isVis || _WrkArr[x + 1][y + 1].isVis)
	      {   /* einer der Punkte sichtbar */
	        for (xx = 0; xx <= 1; xx++) {
	          for (yy = 0; yy <= 1; yy++) {  /* fuer die vier Pkt. */
	            WITH = &_WrkArr[x + xx][y + yy];
	            WITH1 = &_WrkArr[x + xx][y + yy].l;
	            if (!WITH->isInWC) {  /* ins WC, wenn noetig        */
		            MCtoWC_vertex(WITH->a, &WITH->a);
		            WITH->isInWC = true;
	            }
	            if (!WITH->isInDC) {  /* ins DC u. Light., wenn noetig  */
		            WCtoDC(WITH->a.crd, &WITH1->x, &WITH1->y, &WITH1->z);
                hc.r = (uchar)WITH1->c.r;
                hc.g = (uchar)WITH1->c.g;
                hc.b = (uchar)WITH1->c.b;
                DoLight(WITH->a, &hc);
                WITH1->c.r = hc.r;
                WITH1->c.g = hc.g;
                WITH1->c.b = hc.b;
                WITH->isInDC = true;
	            }
	          }
	        }
	        /* Viereck schattieren: */
               if (TriFillEnable) {
  	        FillTria(_WrkArr[x][y].l, _WrkArr[x + 1][y].l,
		               _WrkArr[x + 1][y + 1].l);
	        FillTria(_WrkArr[x][y].l, _WrkArr[x][y + 1].l,
		               _WrkArr[x + 1][y + 1].l);
	        } else { 
                  FillTria(_WrkArr[x][y].l,_WrkArr[x+1][y].l,_WrkArr[x+1][y].l);
                  FillTria(_WrkArr[x+1][y].l,_WrkArr[x+1][y+1].l,_WrkArr[x+1][y+1].l);
                  FillTria(_WrkArr[x+1][y+1].l,_WrkArr[x][y+1].l,_WrkArr[x][y+1].l);
                  FillTria(_WrkArr[x][y+1].l,_WrkArr[x][y].l,_WrkArr[x][y].l); 
                }
              }
      }  /* for y */
    }  /* for x */
    return;
  }
  if (ClipMode != toClip) {
    return;
  }  /* ClipMode=toClip */
  if (WireFrame)   /* if wireframe */
  {  /* wie bei inside, jetzt allerdings */
    for (x = 0; x <= nx - 2; x++) {  /* erst ins NPC, dann CLineP        */
      for (y = 0; y <= ny - 2; y++) {
	      b1 = _WrkArr[x][y].isVis;
	      b2 = _WrkArr[x][y + 1].isVis;
	      b3 = _WrkArr[x + 1][y].isVis;
	      if (b1 || b2 || b3) {
	        WITH = &_WrkArr[x][y];
	        if (!WITH->isInNPC) {
	          MCtoNPC(WITH->a.crd, &WITH->h);
	          WITH->isInNPC = true;
	        }
	      }
	      if (b1 || b2) {
	        WITH = &_WrkArr[x][y + 1];
	        if (!WITH->isInNPC) {
	          MCtoNPC(WITH->a.crd, &WITH->h);
	          WITH->isInNPC = true;
	        }
	        CLineP(_WrkArr[x][y].h, _WrkArr[x][y + 1].h);
	      }
	      if (b1 || b3) {
	        WITH = &_WrkArr[x + 1][y];
	        if (!WITH->isInNPC) {
	          MCtoNPC(WITH->a.crd, &WITH->h);
	          WITH->isInNPC = true;
	        }
	        CLineP(_WrkArr[x][y].h, _WrkArr[x + 1][y].h);
	      }
      }  /* for y */
    }  /* for x */
    return;
  }
  for (x = 0; x <= nx - 2; x++) {
    for (y = 0; y <= ny - 2; y++) {
      V.Pol[0] = _WrkArr[x][y];   /* Teil aus Array in Polygon */
      V.Pol[1] = _WrkArr[x][y + 1];
      V.Pol[2] = _WrkArr[x + 1][y + 1];
      V.Pol[3] = _WrkArr[x + 1][y];
      V.pc = 4;
      MeshPol(&V);   /* flippen, clippen, transformieren, lighting, shading */
      FORLIM2 = V.pc;
      for (i = 0; i < FORLIM2; i++) {  /* fuer das entstandene Polygon: */
	      ind = V.IndArr[i];
	      if (ind != -1) {  /* Punkt kein neuer             */
	        xx = x + (((unsigned long)ind) >> 1); /* x-Index im Array             */
	        if (ind < 1 || ind > 2)   /* y-Ind. */
	          yy = y;
       	  else
	          yy = y + 1;
	        _WrkArr[xx][yy] = V.Pol[i];   /* Polygonpunkt in Array        */
	      }  /* Punkt kein neuer */
      }  /* Entstandenes Polygon ist in Array uebertragen */
    }  /* for y */
  }  /* for x */
}
