//  LAST EDIT: Fri Aug  5 14:45:24 1994 by ekki(@prakinf.tu-ilmenau.de)
#include "fisher.h"


void PutPnt(SHD_VTX *p)
{
  /* Fuehrt eine z-Buffervergleich durch und stellt den Punkt dar, wenn
     er sichtbar ist */
  TzBuffer *l;                            /* Adresse im Z-Buffer */

  l = &zBuffer[p->y][p->x];               /* Adresse berechnen      */
  if (p->z > *l) {                        /* Z-Buffervergleich      */
    *l = (unsigned int)p->z;                            /* neuen Wert in Z-Buffer */
    RGB_Dot((int)(p->x), (int)(p->y),    	/* Punkt ausgeben         */
            (int)(p->c.r), (int)(p->c.g), (int)(p->c.b));
  }
}


void line2d(double x1r, double y1r, double x2r, double y2r)
{
  RGB_Line((int)floor(x1r + 0.5), (int)floor(y1r + 0.5),
	   (int)floor(x2r + 0.5), (int)floor(y2r + 0.5), 255, 255, 255);
}

void SLine(SHD_VTX &rp1, SHD_VTX &rp2)
{
  /* Zeichnen einer Linie mit Farbinterpolation und Z-Buffervergleich. Da
     keine Bereichsueberpruefung vorgenommen wird, muss die Linie bereits
     geclippt sein. */
    SHD_VTX p1= rp1, p2= rp2;
  float x, y, z;               /* aktuelle Koordinaten                     */
  float dyDdx, dxDdy, dzDdt;   /* Steigungen                               */
  rgb c, dcDdt;                /* aktuelle Farbe und Steigung              */
  long dx, dy,                 /* Koordinatendifferenzen                   */
       ix, iy, iz;             /* ganzzahlige Anteile der Koordinaten      */
  SHD_VTX ph;                  /* Hilfsvariable zum Vertauschen der Punkte */
  TzBuffer *l;                 /* Adresse im Z-Buffer */

  dx = fabs(p2.x - p1.x);
  dy = fabs(p2.y - p1.y);
  if (dy > dx)
  {                            /* y treibt; (y>0,x>=0)         */
    if (p2.y < p1.y) {         /* sortieren                    */
      ph = p1;
      p1 = p2;
      p2 = ph;
    }                          /* p1 ueber p2                   */
    z = p1.z + 0.5;            /* z-Koordinate Anfangswert     */
    c.r = p1.c.r + 0.5;        /* Farbe Anfangswert            */
    c.g = p1.c.g + 0.5;        /* Farbe Anfangswert            */
    c.b = p1.c.b + 0.5;        /* Farbe Anfangswert            */
    dzDdt = p2.z - p1.z;       /* Zaehler Steigung z-Koordinate */
    dcDdt.r = p2.c.r - p1.c.r; /* Zaehler Steigung Farbe        */
    dcDdt.g = p2.c.g - p1.c.g; /* Zaehler Steigung Farbe        */
    dcDdt.b = p2.c.b - p1.c.b; /* Zaehler Steigung Farbe        */
    PutPnt(&p1);               /* p1 ausgeben                  */
    x = p1.x + 0.5;            /* Anfangswert x                */
    dxDdy = p2.x - p1.x;       /* Zaehler Steigung x            */
    dxDdy /= dy;               /* Steigung dx/dy               */
    dzDdt /= dy;               /* Steigung dz/dy               */
    dcDdt.r /= dy;             /* Steigung dc/dy               */
    dcDdt.g /= dy;             /* Steigung dc/dy               */
    dcDdt.b /= dy;             /* Steigung dc/dy               */
    while (p1.y < p2.y - 1) {  /* Fuer alle Punkte zwischen p1 und p2 */
      p1.y++;                  /* y treibt                     */
      x += dxDdy;              /* x inkrementieren             */
      z += dzDdt;              /* z inkrementieren             */
      c.r += dcDdt.r;          /* Farbe inkrementieren         */
      c.g += dcDdt.g;          /* Farbe inkrementieren         */
      c.b += dcDdt.b;          /* Farbe inkrementieren         */
      ix = (long)floor(x);     /* ganzzahliger Anteil          */
      iz = (long)floor(z);     /* ganzzahliger Anteil          */
      l = &zBuffer[p1.y][ix];  /* Z-Bufferadresse              */
      if (iz > *l) {           /* Z-Buffervergleich            */
      	*l = (unsigned int)iz;               /* Punkt setzen                 */
      	RGB_Dot((int)ix, (int)p1.y, (int)floor(c.r), (int)floor(c.g), (int)floor(c.b));
      }
    }
    PutPnt(&p2);               /* letzten Punkt ausgeben       */
  } else {         /* Gleiches Spiel, aber x treibt; (y>=0,x>=0) */
    if (p2.x < p1.x) {
      ph = p1;
      p1 = p2;
      p2 = ph;
    }
    z = p1.z + 0.5;              /* z-Koordinate Anfangswert     */
    c.r = p1.c.r + 0.5;          /* Farbe Anfangswert            */
    c.g = p1.c.g + 0.5;          /* Farbe Anfangswert            */
    c.b = p1.c.b + 0.5;          /* Farbe Anfangswert            */
    dzDdt = p2.z - p1.z;         /* Zaehler Steigung z-Koordinate */
    dcDdt.r = p2.c.r - p1.c.r;   /* Zaehler Steigung Farbe        */
    dcDdt.g = p2.c.g - p1.c.g;   /* Zaehler Steigung Farbe        */
    dcDdt.b = p2.c.b - p1.c.b;   /* Zaehler Steigung Farbe        */
    PutPnt(&p1);
    if (dx != 0) {               /* mehr als ein Punkt */
      y = p1.y + 0.5;
      dyDdx = p2.y - p1.y;
      dyDdx /= dx;
      dzDdt /= dx;
      dcDdt.r /= dx;
      dcDdt.g /= dx;
      dcDdt.b /= dx;
      while (p1.x < p2.x - 1) {
        p1.x++;
        y += dyDdx;
        z += dzDdt;
        c.r += dcDdt.r;
        c.g += dcDdt.g;
        c.b += dcDdt.b;
        iy = (long)floor(y);
        iz = (long)floor(z);
        l = &zBuffer[iy][p1.x];
        if (iz > *l) {
          *l = (unsigned int)iz;
          RGB_Dot((int)p1.x, (int)iy, (int)floor(c.r), (int)floor(c.g), (int)floor(c.b));
        }
      }
    }                           /* Ende  mehr als ein Punkt */
    PutPnt(&p2);
  }
}  /* Ende SLine() */

void Span(boolean LtoR, int y, int x1, int x2, float z, const rgb &rc,
	  float dz, const rgb &dc) {
     long iz;
   rgb c= rc;
  if (LtoR) {
    while (x1 < x2 - 1) {  /* Fuer alle Zwischenpunkte     */
      x1++;          /* x1 weiter                   */
      z+= dz;        /* z-Koordinate inkrementieren */
      c.r += dc.r;   /* Farbe inkrementieren        */
      c.g += dc.g;   /* Farbe inkrementieren        */
      c.b += dc.b;   /* Farbe inkrementieren        */
      iz = (long)floor(z);
      if (iz > zBuffer[y][x1]) {  /* Z-Buffervergleich           */
      	zBuffer[y][x1] = (unsigned int)iz;       	    /* Punkt in Z- u. Framebuffer  */
      	RGB_Dot((int)x1, (int)y, (int)floor(c.r), (int)floor(c.g), (int)floor(c.b));
      }
    }
    return;
  }
  while (x1 > x2 + 1) {  /* gleiche Spiel von rechts nach links */
    x1--;
    z -= dz;
    c.r -= dc.r;
    c.g -= dc.g;
    c.b -= dc.b;
    iz = (long)floor(z);
    if (iz > zBuffer[y][x1]) {  /* Z-Buffervergleich           */
    	zBuffer[y][x1] = (unsigned int)iz;      /* Punkt in Z- u. Framebuffer  */
     	RGB_Dot((int)x1, (int)y, (int)floor(c.r), (int)floor(c.g), (int)floor(c.b));
    }
  }
}

void FillTria(const SHD_VTX &rp1, const SHD_VTX &rp2, const SHD_VTX &rp3)

{/*  Zeichnen eines gouraudschattierten Dreiecks incl. Z-Buffervergleich.
     Da keine Bereichsueberpruefung vorgenommen wird, muss das Dreieck komplett
     im aktuellen Fenster liegen. Dies ist aber der Fall, wenn im NPC geclippt
     wurde */

    SHD_VTX p1= rp1, p2= rp2, p3= rp3;

  long x21, x31, x32;   /* x-Differenzen der drei Kanten    */
  long y21, y31, y32;   /* y-Differenzen der drei Kanten    */
  long z21, z31, z32;   /* z-Differenzen der drei Kanten    */
  long iex,iez,ie1x,ie1z;
  rgbI c21, c31, c32;   /* Farb-Differenzen der drei Kanten */
  float ex, ez;
  rgb ec;     /* aktuelle Werte lange Kante */
  float e1x, e1z;
  rgb e1c;    /* aktuelle Werte kurze Kante */
  float edx, edz;
  rgb edc;    /* Steigungen lange Kante     */
  float e1dx, e1dz;
  rgb e1dc;   /* Steigungen kurze Kante     */
  float dzDdx;
  rgb dcDdx;  /* Steigungen Span            */
  long N;     /* Nenner Steigung Span       */
  SHD_VTX ph; /* Hilfsvariable zum Sortieren der Pkt. */
  rgbB cmit;  /* Mittelwert der Farbe bei Flatshading */
  TzBuffer *l;/* Adresse im Z-Buffer                  */

  if (p1.c.r >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p1.c.r = ColRange - 1;
  if (p2.c.r >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p2.c.r = ColRange - 1;
  if (p3.c.r >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p3.c.r = ColRange - 1;
  if (p1.c.g >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p1.c.g = ColRange - 1;
  if (p2.c.g >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p2.c.g = ColRange - 1;
  if (p3.c.g >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p3.c.g = ColRange - 1;
  if (p1.c.b >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p1.c.b = ColRange - 1;
  if (p2.c.b >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p2.c.b = ColRange - 1;
  if (p3.c.b >= ColRange)   /* Vermeidung von Ueberlaeufen */
    p3.c.b = ColRange - 1;
  if (ShadingMethod == Flat) {
    cmit.r = (p1.c.r + p2.c.r + p3.c.r) / 3;
	/* Mittelwert Farben berechnen */
    p1.c.r = cmit.r;
    p2.c.r = cmit.r;
    p3.c.r = cmit.r;   /* Farben auf Mittelwert       */
    cmit.g = (p1.c.g + p2.c.g + p3.c.g) / 3;
	/* Mittelwert Farben berechnen */
    p1.c.g = cmit.g;
    p2.c.g = cmit.g;
    p3.c.g = cmit.g;   /* Farben auf Mittelwert       */
    cmit.b = (p1.c.b + p2.c.b + p3.c.b) / 3;
	/* Mittelwert Farben berechnen */
    p1.c.b = cmit.b;
    p2.c.b = cmit.b;
    p3.c.b = cmit.b;   /* Farben auf Mittelwert       */
  }
  if (!TriFillEnable) {
    SLine(p1, p2);
    SLine(p1, p3);
    SLine(p2, p3);     /* Nur die Kanten zeichnen     */
    return;
  }
  if (p1.y > p2.y) {
    ph = p1;
    p1 = p2;
    p2 = ph;
  }  /* p1,p2,p3 sor-  */
  if (p1.y > p3.y) {
    ph = p1;
    p1 = p3;
    p3 = ph;
  }  /* tieren. Es gilt*/
  if (p2.y > p3.y) {
    ph = p2;
    p2 = p3;
    p3 = ph;
  }  /* p1y<=p2y<=p3y  */
  y31 = p3.y - p1.y;   /* Laenge der 'langen' Kante  */
  if (y31 == 0) {      /* Dreieck keine hor. Linie? */
    SLine(p1, p3);
    return;
  }  /* Ende keine vertikale Linie */
  y21 = p2.y - p1.y;
  x21 = p2.x - p1.x;   /* Differenzen 'kurze' Kante */
  x31 = p3.x - p1.x;   /* Breite der langen Kante   */
  N = y21 * x31 - y31 * x21;
  if (N == 0) {        /* kein entartetes Dreieck:  */
    SLine(p1, p3);
    return;
  }
  PutPnt(&p1);         /* obersten Punkt ausgeben   */
  p1.y++;              /* p1.y = treibender Wert    */
  z31 = p3.z - p1.z;
  z21 = p2.z - p1.z;   /* dz lange u. kurze Kante   */
  c31.r = p3.c.r - p1.c.r;
  c21.r = p2.c.r - p1.c.r;   /* dc lange u. kurze Kante   */
  c31.g = p3.c.g - p1.c.g;
  c21.g = p2.c.g - p1.c.g;   /* dc lange u. kurze Kante   */
  c31.b = p3.c.b - p1.c.b;
  c21.b = p2.c.b - p1.c.b;   /* dc lange u. kurze Kante   */
  ex = p1.x + 0.5;           /* Anfangswert x lange Kante */
  ez = p1.z + 0.5;           /* Anfangswert z lange Kante */
  ec.r = p1.c.r + 0.5;       /* Anfangswert c lange Kante */
  ec.g = p1.c.g + 0.5;       /* Anfangswert c lange Kante */
  ec.b = p1.c.b + 0.5;       /* Anfangswert c lange Kante */
  edx = (float)x31 / y31;    /* dx/dy lange Kante         */
  edz = (float)z31 / y31;    /* dz/dy lange Kante         */
  edc.r = (float)c31.r / y31;/* dc/dy lange Kante         */
  edc.g = (float)c31.g / y31;/* dc/dy lange Kante         */
  edc.b = (float)c31.b / y31;/* dc/dy lange Kante         */
  dzDdx = (float)(y21 * z31 - y31 * z21) / N;       /* dz/dx in Spans     */
  dcDdx.r = (float)(y21 * c31.r - y31 * c21.r) / N; /* dc/dx in den Spans */
  dcDdx.g = (float)(y21 * c31.g - y31 * c21.g) / N;
  dcDdx.b = (float)(y21 * c31.b - y31 * c21.b) / N;
  if (y21 != 0) {   /* Kante (P1,P2) nicht horiz.     */
    e1x = ex;       /* Anfangswerte obere kurze       */
    e1z = ez;       /* Kante=Anfangswerte lange Kante */
    e1c.r = ec.r;
    e1c.g = ec.g;
    e1c.b = ec.b;
    e1dx = (float)x21 / y21;      /* dx/dy kurze Kante         */
    e1dz = (float)z21 / y21;      /* dz/dy kurze Kante         */
    e1dc.r = (float)c21.r / y21;  /* dc/dy kurze Kante         */
    e1dc.g = (float)c21.g / y21;  /* dc/dy kurze Kante         */
    e1dc.b = (float)c21.b / y21;  /* dc/dy kurze Kante         */
//! Span(N < 0, p1.y-1, p1.x, (int)floor(ex+edx), ez, ec, dzDdx, dcDdx); /* Span ]e,e1[  */
    while (p1.y < p2.y) {  /* fuer alle Zeilen zwischen p1y u. p2y: */
      ec.r += edc.r;   /* alle Komponenten von e    */
      ec.g += edc.g;   /* alle Komponenten von e    */
      ec.b += edc.b;   /* alle Komponenten von e    */
      ex += edx;       /* inkrementieren. Als y-Ko- */
      ez += edz;       /* ordinate dient p1.y       */
      e1x += e1dx;     /* alle Komponenten von e1   */
      e1z += e1dz;     /*     inkrementieren        */
      e1c.r += e1dc.r;
      e1c.g += e1dc.g;
      e1c.b += e1dc.b;
      iex = (long)floor(ex);
      iez = (long)floor(ez);
      l = &zBuffer[p1.y][iex];   /* Adresse von e im Z-Buffer */
      if (iez > *l) {            /* Z-Buffervergleich         */
       	*l = (unsigned int)iez;                /* e ausgeben                */
  	    RGB_Dot((int)iex, (int)p1.y, (int)floor(ec.r), (int)floor(ec.g), (int)floor(ec.b));
      }
      ie1x = (long)floor(e1x);
      ie1z = (long)floor(e1z);
      l = &zBuffer[p1.y][ie1x];   /* Adresse von e1 im Z-Bufer */
      if (ie1z > *l) {            /* Z-Buffervergleich         */
	      *l = (unsigned int)ie1z;                /* e1 ausgeben               */
      	RGB_Dot((int)ie1x, (int)p1.y, (int)floor(e1c.r), (int)floor(e1c.g), (int)floor(e1c.b));
      }
      Span(N < 0, (int)p1.y, (int)iex, (int)ie1x, ez, ec, dzDdx, dcDdx); /* Span ]e,e1[  */
      p1.y++;           /* y fuer e,e1 u. Span weiter */
    }                   /* Ende alle Spans ueber P2   */
    ex += edx;          /* e inkrementieren. e liegt */
    ez += edz;          /*  jetzt auf gleicher Hoehe  */
    ec.r += edc.r;      /*          wie P2           */
    ec.g += edc.g;      /*          wie P2           */
    ec.b += edc.b;      /*          wie P2           */
  }  /* Ende Kante (P1,P2) nicht waagerecht */
  p1.y = p2.y;          /* y-Koordinate fuer e,e1 u. Spans      */
  iex = (long)floor(ex);
  iez = (long)floor(ez);
  l = &zBuffer[p1.y][iex];   /* Z-Bufferadr. des Pkt. gegenueber P2  */
  if (iez > *l) {            /* Z-Buffervergleich         */
    *l = (unsigned int)iez;          	     /* Punkt ausgeben            */

    RGB_Dot((int)iex, (int)p1.y, (int)floor(ec.r), (int)floor(ec.g), (int)floor(ec.b));
  }
  PutPnt(&p2);   /* P2 ausgeben         */
  Span(N < 0, (int)p1.y, (int)iex, (int)p2.x, ez, ec, dzDdx, dcDdx); /* Span in Hoehe P2     */
  p1.y++;   /* y einen tiefer      */
  /* Ab hier folgt nun das gleiche Spiel fuer die untere kurze Kante.
     Das Prinzip ist identisch, so dass auf Kommentar verzichtet
     wird. (.. wenn Turbo doch Spaltenbloecke kopieren koennte!)       */
  y32 = p3.y - p2.y;
  if (y32 != 0) {  /* Kante (P2,P3) nicht waagerecht */
    x32 = p3.x - p2.x;
    z32 = p3.z - p2.z;
    c32.r = p3.c.r - p2.c.r;
    c32.g = p3.c.g - p2.c.g;
    c32.b = p3.c.b - p2.c.b;
    e1x = p2.x + 0.5;
    e1z = p2.z + 0.5;
    e1c.r = p2.c.r + 0.5;
    e1c.g = p2.c.g + 0.5;
    e1c.b = p2.c.b + 0.5;
    e1dx = (float)x32 / y32;
    e1dz = (float)z32 / y32;
    e1dc.r = (float)c32.r / y32;
    e1dc.g = (float)c32.g / y32;
    e1dc.b = (float)c32.b / y32;
    while (p1.y < p3.y) {
      ex += edx;
      ez += edz;
      ec.r += edc.r;
      ec.g += edc.g;
      ec.b += edc.b;
      e1x += e1dx;
      e1z += e1dz;
      e1c.r += e1dc.r;
      e1c.g += e1dc.g;
      e1c.b += e1dc.b;
      ie1x = (long)floor(e1x);
      ie1z = (long)floor(e1z);
      l = &zBuffer[p1.y][ie1x];   /* Adresse von e1 im Z-Bufer */
      if (ie1z > *l) {            /* Z-Buffervergleich         */
	      *l = (unsigned int)ie1z;                /* e1 ausgeben               */
      	RGB_Dot((int)ie1x, (int)p1.y, (int)floor(e1c.r), (int)floor(e1c.g), (int)floor(e1c.b));
      }
      iex = (long)floor(ex);
      iez = (long)floor(ez);
      l = &zBuffer[p1.y][iex];   /* Adresse von e im Z-Buffer */
      if (iez > *l) {            /* Z-Buffervergleich         */
       	*l = (unsigned int)iez;                /* e ausgeben                */
  	    RGB_Dot((int)iex, (int)p1.y, (int)floor(ec.r), (int)floor(ec.g), (int)floor(ec.b));
      } 
      Span(N < 0, (int)p1.y, (int)iex, (int)ie1x, ez, ec, dzDdx, dcDdx);
      p1.y++;
    }  /* Ende alle Spans  unter P2 */
  }  /* Ende untere kurze Kante nicht senkrecht */
  PutPnt(&p3);

  /* Ende trifillenabled */
}  /* Ende FillTria() */

