////////////////////////////////////////////////////////////////////////////////
// Implementation of the tcl output devices.                                  //  
//  LAST EDIT: Fri Aug  5 08:55:24 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRIGHT which should be distributed with this //
//  file. If COPYRIGHT is not available or for more info please contact:      //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

extern "C" {
#include <tcl.h>
}

#include <tclerror.h>
#include <stdlib.h>
#include <stdarg.h>
#include "strings.h"

extern Tcl_Interp *rt_Ip;	
static char TclOutputObjectCmd[] = "rt_Output ";

void RT_TclOutput::callTclObject(const char *method, const char *s) {
    if (inside) fprintf( stderr,"YART TCL %s: %s",method,s);
    else {
	RT_String cmd;
	cmd = "if [catch { ";
	cmd += TclOutputObjectCmd;
	cmd += method;
	cmd += " {";
	cmd += s;
	cmd += "} }] {puts stderr {Error: no object rt_Output!\n";
	cmd += "YART error: ";
	cmd += s;
	cmd += "\n}}";


	inside = 1;
	Tcl_Eval(rt_Ip,cmd.getValue());
	inside = 0;
	va_end( args );
    }
}

void RT_TclOutput::errorVar(const char *s ...) {
    RT_String str(s);
    va_list args;
    va_start( args,s);
    while ( s = va_arg( args, char*)) str += s;
    va_end( args );\
    callTclObject("-error",(char *)str);
};

void RT_TclOutput::messageVar(const char *s ...) {
    RT_String str(s);
    va_list args;
    va_start( args,s);
    while ( s = va_arg( args, char*)) str += s;
    va_end( args );\
    callTclObject("-message",(char *)str);
};

void RT_TclOutput::warningVar(const char *s ...) {
    RT_String str(s);
    va_list args;
    va_start( args,s);
    while ( s = va_arg( args, char*)) str += s;
    va_end( args );\
    callTclObject("-warning",(char *)str);
};

void RT_TclOutput::fatalVar(const char *s ...) {
    RT_String str(s);
    va_list args;
    va_start( args,s);
    while ( s = va_arg( args, char*)) str += s;
    va_end( args );\
    callTclObject("-fatal",(char *)str);
};

void RT_TclOutput::specialVar(const char *s ...) {
    RT_String str(s);
    va_list args;
    va_start( args,s);
    while ( s = va_arg( args, char*)) str += s;
    va_end( args );\
    callTclObject("-special",(char *)str);
};







