////////////////////////////////////////////////////////////////////////////////
//  This is a very rudimentary demo for testing multiple references. Will be  //
//  finished in future.                                                       //  
//  LAST EDIT: Fri Aug  5 09:09:25 1994 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1994 YART team                                               //
////////////////////////////////////////////////////////////////////////////////

#include <yart.h>

RT_LookatCamera *cam;

class MyConsoleInputCB: public RT_ConsoleInputCB {
    void exec(RT_InputDevice*) {
	if (evalCmd()) cam->rendering();
    }
};

extern const char *RTN_REFERENCE;
const char *RTN_REFERENCE = "Reference";

class RT_Reference:public RT_Primitive {
    // the referenced primitive:
    RT_Primitive *refPrim;
  public:

    //#### Tcl/C++ methods:
    RT_Reference( char *_name, RT_Primitive *_prim):RT_Primitive( _name ) {
	refPrim = _prim;
    }   
    const char *get_class() const { return refPrim->get_class(); }
    const char *get_description() const { return refPrim->get_description();}
    int isA(const char *_c) const { 
	return RT_Primitive::isA( _c )
	    || RTM_isA(_c, RTN_REFERENCE )
		|| refPrim->isA( _c );
    }

    //#### the Tcl commands:
    static int classCMD(ClientData, Tcl_Interp *, int, char *[]); 

    //#### shading interface:
    void render() {
	refPrim->father( this );
	refPrim->update( 1 );
	refPrim->render();
	refPrim->father( 0 );
    }
    void createReferences(const RT_AttributeList &list) {
	refPrim->createReferences(list); 
    }
};

int RT_Reference::classCMD(ClientData cd, Tcl_Interp *ip, int argc, char *argv[]) { 
    int res;
    res = _classCMD(cd, ip, argc, argv);
    if (res == TCL_HELP) {
	Tcl_AppendResult( ip, "{", RTN_REFERENCE, " {String Object} {Creates a new reference {ARG 1 Name} that references {ARG 2 Object}.}}", 0 );
	return TCL_OK;
    }

    if ( res  == TCL_OK ) {  
	if ( argc != 3 ) {
	    Tcl_AppendResult( ip, "Bad syntax. Must be: ", argv[0], " <name> <object>! ", 0 );
	    return TCL_ERROR;
	}
	RT_Object *obj = RT_Object::getObject( argv[2] );
	if (!obj || !(obj->isA( RTN_PRIMITIVE )) ) {
	    Tcl_AppendResult( ip, "No primitive ", argv[2], "!", 0 );
	    return TCL_OK;
	}
	new RT_Reference( argv[1], (RT_Primitive*)obj ); 
	RTM_classReturn;
    }
    return res; 
}

main() {
    RT_init();
    RTM_command( RTN_REFERENCE, RT_Reference::classCMD );

    RT_PixmapDisplay *dis = new RT_PixmapDisplay( "dis", 200, 200 );
    cam = new RT_LookatCamera( "cam", RT_Vector( 0,0,10 ),
					       RT_Vector( 0,0,0 ));
    cam->scene( new RT_Scene( "sc" )); cam->pixmap( dis );

    RT_FileDevice *console = (RT_FileDevice *)RT_Object::getObject( "console" );
    ( new RT_FileDevice( "console", 0, 1 ))->addCB( new MyConsoleInputCB );
    
    rt_InputServer->loop();
}
