////////////////////////////////////////////////////////////////////////////////
//  A utility class for vertices. A vertex contains coordinates, a surface and//
//  a normal vector. Surface and normal are optional.                         //  
//  LAST EDIT: Wed Mar  8 14:29:49 1995 by ekki(@prakinf.tu-ilmenau.de)
////////////////////////////////////////////////////////////////////////////////
//  This file belongs to the YART implementation. Copying, distribution and   //
//  legal info is in the file COPYRGHT which should be distributed with this  //
//  file. If COPYRGHT is not available or for more info please contact:       //
//                                                                            //  
//		yart@prakinf.tu-ilmenau.de                                    //
//                                                                            //  
// (C) Copyright 1993 - 1995 YART team                                        //
////////////////////////////////////////////////////////////////////////////////

#ifndef __VERTEX_H__
#define __VERTEX_H__

#define RTN_VERTEX "Vertex"

class RT_Vertex: public RT_GeneralListEntry {
    void print(FILE *f) const { fprintf( f, "VERTEX: "); p.print( f ); if (s) s->print( f ); if (n) n->print( f ); }
    RT_Vector p;
    RT_Surface *s;
    RT_Vector *n;
  public:
    RT_Vertex() { s = 0; n = 0; } // default constructor for arrays
    RT_Vertex(const RT_Vector &_p, const RT_Surface *_s = 0, const RT_Vector *_n = 0) { 
	p = _p;
	s = _s ? new RT_Surface : 0; 
	if (s) *s = *_s;
	n = _n ? new RT_Vector : 0; 
	if (n) *n = *_n;
    }
    RT_Vertex(const RT_Vertex *v) {
	p = v->p;
	s = v->s ? new RT_Surface : 0;
	if (s) *s = *v->s;
	n = v->n ? new RT_Vector : 0;
	if (n) *n = *v->n;
    }
    void operator=(const RT_Vertex &v) {
	p = v.p;
	if (v.s) {
	    if (!s) s = new RT_Surface( *(v.s) );
	    else *s = *(v.s);
	}
	if (v.n) {
	    if (!n) n = new RT_Vector( *(v.n) );
	    else *n = *(v.n);
	}
    }

    ~RT_Vertex() { if (s) delete s; if (n) delete n; }

    int isA(const char *_c) const { return RTM_isA( _c, RTN_VERTEX ); }

    // set&get coordinates:
    void point(const RT_Vector &_p) { p = _p; }
    const RT_Vector &getPoint() const { return p; }

    // set, get &delete surface:
    void surface(const RT_Surface &_s) {
	if (!s) s = new RT_Surface;
	*s = _s;
    }
    const RT_Surface *getSurface() const { return s; }
    // return value must be a pointer!
    void deleteSurface() {
	if (s) delete s;
	s = 0;
    }

    // set, get &delete normal:
    void normal(const RT_Vector &_n) { 
	if (!n) n = new RT_Vector;
	*n = _n;
    }
    const RT_Vector *getNormal() const { return n; }
    // return value must be a pointer!
    void deleteNormal() {
	if (n) delete n;
	n = 0;
    }
};

#endif
