#include <vga.h>
#include <stdlib.h>

#include "sintab.h"

#define S() (srand48(getpid()))
#define R(x) (drand48()*x)

#define XSIZE 40
#define YSIZE 25
#define XMAG 4
#define YMAG 4
#define WAVES 6

int waves[WAVES][3];
char line[XSIZE*XMAG];

frame() {
	static int time=0;
	int x,y,xx,yy,i;
	char *lp;

	time++;
	yy=0;
	for(y=0;y<YSIZE;y++) {
		lp=line;
		for(x=0;x<XSIZE;x++) {
			i=0;
			for(xx=0;xx<WAVES;xx++) i+=SIN(time*waves[xx][0]+x*waves[xx][1]+y*waves[xx][2]);
			i=(i/(TABMAG/256))/(WAVES*2)+128;
			for(xx=0;xx<XMAG;xx++) *(lp++)=i;
		}
		for(xx=0;xx<YMAG;xx++) vga_drawscansegment(line,0,yy++,XSIZE*XMAG);
	}
}
	
main(int argc, char **argv[]) {
	int i;

	S();

	for(i=0;i<WAVES;i++) {
		waves[i][0]=(int)R(TABSIZE/32)-TABSIZE/64;
		waves[i][1]=(int)R(XMAG*TABSIZE/64)-XMAG*TABSIZE/128;
		waves[i][2]=(int)R(YMAG*TABSIZE/64)-YMAG*TABSIZE/128;
	}
	vga_setmode(G320x200x256);
	for(i=0;i<256;i++) vga_setpalette(i,i/4,i/4,i/4);

 	while(1) frame();
}
