int and, add;

#include <vga.h>

#define WIDTH 640
#define HEIGHT 480
#define MODE G640x480x256

unsigned char buffer[2][WIDTH];
int sline=0, bline=0;

void oneline(void)  {
  int i;
  char *source=buffer[1-bline],*dest=buffer[bline];
  
  dest[0]=((source[0]*2+source[1]+add)/3)&and;
  for(i=1;i<(WIDTH-1);i++)
    dest[i]=((source[i-1]+source[i]+source[i+1]+add)/3)&and;
  dest[WIDTH-1]=((source[WIDTH-2]+source[WIDTH-1]*2+add)/3)&and;
  vga_drawscanline(sline,dest);
  vga_drawscanline((sline+HEIGHT)%(2*HEIGHT),dest);
  vga_setdisplaystart(WIDTH*(sline%HEIGHT));
  bline=1-bline;
  sline=(sline+1)%(2*HEIGHT);
}

void graypal(void)  {
  int i;
  
  for(i=0;i<256;i++) vga_setpalette(i,i/4,i/4,i/4);
}

main()  {
  int i;
  vga_init();
  vga_setmode(MODE);
  
  graypal();
  
  add=3; and=255;
  srand(getpid());
  
  for(i=0;i<WIDTH;i++) buffer[1][i]=rand();
  while(1)
    oneline();
  vga_setmode(TEXT);
}
