
#include <vga.h>

#define ADD 3
#define WIDTH 320
#define HEIGHT 200
#define MODE G320x200x16M

unsigned char buffer[3][2][WIDTH];
unsigned char sbuffer[WIDTH][3];
int sline=0, bline=0;

void oneline(void)  {
  int i,j;
  static int k;
  char *source,*dest;

  for(j=0;j<3;j++) {
    char *source=buffer[j][1-bline],*dest=buffer[j][bline];

    sbuffer[0][j]=dest[0]=rand();

    for(i=1;i<(WIDTH-1);i++)
      sbuffer[i][j]=dest[i]=((source[i-1]+source[i]+source[i+1]+ADD)/3);
    sbuffer[WIDTH-1][j]=dest[WIDTH-1]=rand();
  }
  vga_drawscanline(sline,sbuffer);
  vga_setdisplaystart(sline%HEIGHT*WIDTH*3);
  vga_drawscanline((sline+HEIGHT)%(2*HEIGHT),sbuffer);
  bline=1-bline;
  sline=sline-1; if(sline<0)sline+=2*HEIGHT;
  /* sline=(sline+1)%(2*HEIGHT); */
}

void graypal(void)  {
  int i;
  
  for(i=0;i<256;i++) vga_setpalette(i,i/4,i/4,i/4);
}
main()  {
  int i,j;
  vga_init();
  vga_setmode(MODE);
  
  graypal();

  srand(getpid());
  
  for(j=0;j<3;j++) for(i=0;i<WIDTH;i++) buffer[j][1][i]=rand();
  while(1)
    oneline();
  vga_setmode(TEXT);
}
