#ifndef lint
static       char    rcsid[] = "$Header: parse.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	parse.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * static	CHAR	*DxfFileName;	 * DXF file name, defined in data.c *
 * static	INT	DxfAscOrBin;	 * 0 for ASCII DXF file, 1 for BINARY *
 * static	LONG	DxfFileLine;	 * DXF file line counter, for ASCII *
 *					 * DXF file, defined in data.c *
 * static	LONG	DxfFileByte;	 * DXF file byte counter, for BINARY *
 *					 * DXF file, defined in data.c *
 */

static	FILE	*DxfFile;		/* DXF file handler */
static	CHAR	DxfFileBuf[BUFSIZ];	/* DXF file buffer */
static	GROUP	DxfGroup;		/* group in DXF file */

/*
 * define the header of a binary DXF file
 */

#define	BinaryDxfHeaderLength	22

static	CHAR	BinaryDxfHeader[BinaryDxfHeaderLength] = {
	'A', 'u', 't', 'o', 'C', 'A', 'D', ' ',
	'B', 'i', 'n', 'a', 'r', 'y', ' ',
	'D', 'X', 'F', 0xd, 0xa,0x1a, 0x0
};

/*
 * convert an INT2 integer from VAX (i.e. INTEL 8086) format into IEEE format
 */

#if !defined(MSDOS) && !defined(vax) && !defined(VAX)
VOID	VAX_INT_2_TO_IEEE_INT_2(src, dst)
CHAR	src[2];
CHAR	dst[2];
{
	dst[0] = src[1];
	dst[1] = src[0];
}
#endif

/*
 * convert a FLOAT_8 integer from IEEE format into VAX format
 *
 * i do not know how to do it :-(
 */

#if defined(vax) || defined(VAX)
/*ARGSUSED*/
VOID	IEEE_FLOAT_8_TO_VAX_FLOAT_8(src, dst)
CHAR	src[8];
CHAR	dst[8];
{
	GENERR("\nIEEE_FLOAT_8_TO_VAX_FLOAT_8 UNDEFINED %s", "\n");
}
#endif

/*
 * get next group of code and value from an ASCII DXF file
 * note: the result is stored in a static area
 */

VOID	AsciiGetNextGroup()
{
	/*
	 * get the group code
	 */

	if (fgets(DxfFileBuf, BUFSIZ, DxfFile) == NULL)
		DXFERR("read error when getting a group code %s", "\n");

	DxfFileLine++;

	/*
	 * check the group code
	 * note: it should be no negative integer in FORTRAN I3 format
	 */

	Group->code = atoi(DxfFileBuf);

	if (Group->code < 0 || Group->code > 999)
		DXFERR("wrong group code %d\n", Group->code);

	/*
	 * get the group value
	 */

	if (fgets(DxfFileBuf, BUFSIZ, DxfFile) == NULL)
		DXFERR("read error when getting a group value %s", "\n");

	DxfFileLine++;

	/*
	 * Group code range - Following value
	 *      0 - 9         String
	 *     10 - 59        Floating-point
	 *     60 - 79        Integer
	 *    210 - 239       Floating-point
	 *       999          Comment (string)
	 */

	/*
	 * strip off "\n" or "\r"
	 */

	Group->string = strtok(DxfFileBuf, "\r\n");

	if (Group->code >= 0 && Group->code <= 9) {
		Group->type = GROUP_VALUE_STRING;
		return;
	}

	if (Group->code >= 10 && Group->code <= 59) {
		Group->type = GROUP_VALUE_FLOAT;
		Group->fltnum = atof(DxfFileBuf);
		if (fabs(Group->fltnum) < TOE)
			Group->fltnum = 0.0;
		return;
	}

	if (Group->code >= 60 && Group->code <= 79) {
		Group->type = GROUP_VALUE_INTEGER;
		Group->intnum = atoi(DxfFileBuf);
		return;
	}

	if (Group->code >= 210 && Group->code <= 239) {
		Group->type = GROUP_VALUE_FLOAT;
		Group->fltnum = atof(DxfFileBuf);
		if (fabs(Group->fltnum) < TOE)
			Group->fltnum = 0.0;
		return;
	}

	if (Group->code == 999) {
		Group->type = GROUP_VALUE_STRING;
		return;
	}

	DXFERR("wrong group code %d\n", Group->code);
}

/*
 * get next group of code and value from a BINARY DXF file
 * note: the result is stored in a static area
 *
 * note: the group code in a BINARY DXF file is a single-byte
 * binary value, and the value that follows is one of the following
 * 1. a two-byte integer with the least significant byte first and
 *    the most significant byte last (i.e. VAX or 8086 format)
 * 2. an eigth-byte IEEE double precision floating-point number stored with
 *    the least siginificant byte first and the most significant byte last
 * 3. an ASCII string terminated by a zero (NULL) byte
 *
 * the type of the datum following a group is determined from the group code
 * according to the same rules used in decoding ASCII DXF files. translation
 * of angles to degrees is performed for BINARY files as well as for ASCII
 * DXF files. the comment group, 999, is not used in binary DXF files
 */

VOID	BinaryGetNextGroup()
{
	INT	i;
	INT2	intnum;
	FLOAT8	fltnum;
#if !defined(MSDOS) && !defined(vax) && !defined(VAX)
	INT2	tint;
#endif
#if defined(vax) || defined(VAX)
	FLOAT8	tflt;
#endif

	/*
	 * get the group code
	 */

	Group->code = 0;
	if (fread(&Group->code, sizeof(CHAR), 1, DxfFile) < 1)
		DXFERR("read error when getting a group code %s", "\n");

	DxfFileByte++;

	/*
	 * check the group code
	 * note: the group code got from the BINARY DXF file
	 */

	if (Group->code < 0 || Group->code > 239)
		DXFERR("wrong group code %d\n", Group->code);

	/*
	 * get the group value
	 *
	 * Group code range - Following value
	 *      0 - 9         String
	 *     10 - 59        Floating-point
	 *     60 - 79        Integer
	 *    210 - 239       Floating-point
	 *       999          Comment (string)
	 */

	if (Group->code >= 0 && Group->code <= 9) {
		Group->type = GROUP_VALUE_STRING;
		i = 0;
		do
			if (fread(&DxfFileBuf[i], sizeof(CHAR), 1, DxfFile) < 1) {
				DXFERR("reading error when getting a string %s", "\n");
			}
		while (DxfFileBuf[i++] != '\0');
		DxfFileByte += i;
		return;
	}

	if (Group->code >= 10 && Group->code <= 59) {
		Group->type = GROUP_VALUE_FLOAT;
		if (fread(&fltnum, sizeof(FLOAT8), 1, DxfFile) < 1)
				DXFERR("reading error when getting a float-point number %s", "\n");
#if defined(vax) || defined(VAX)
		IEEE_FLOAT_8_TO_VAX_FLOAT_8((CHAR *) &fltnum, (CHAR *) &tflt);
		Group->fltnum = (FLOAT) tflt;
#else
		Group->fltnum = (FLOAT) fltnum;
#endif
		if (fabs(Group->fltnum) < TOE)
			Group->fltnum = 0.0;
		(VOID) sprintf(DxfFileBuf, "%g", Group->fltnum);
		DxfFileByte += 8;
		return;
	}

	if (Group->code >= 60 && Group->code <= 79) {
		Group->type = GROUP_VALUE_INTEGER;
		if (fread(&intnum, sizeof(INT2), 1, DxfFile) < 1)
				DXFERR("reading error when getting an integer %s", "\n");
#if !defined(MSDOS) && !defined(vax) && !defined(VAX)
		VAX_INT_2_TO_IEEE_INT_2((CHAR *) &intnum, (CHAR *) &tint);
		Group->intnum = (INT) tint;
#else
		Group->intnum = (INT) intnum;
#endif
		(VOID) sprintf(DxfFileBuf, "%d", Group->intnum);
		DxfFileByte += 2;
		return;
	}

	if (Group->code >= 210 && Group->code <= 239) {
		Group->type = GROUP_VALUE_FLOAT;
		if (fread(&fltnum, sizeof(FLOAT8), 1, DxfFile) < 1)
				DXFERR("reading error when getting a float-point number %s", "\n");
#if defined(vax) || defined(VAX)
		IEEE_FLOAT_8_TO_VAX_FLOAT_8((CHAR *) &fltnum, (CHAR *) &tflt);
		Group->fltnum = (FLOAT) tflt;
#else
		Group->fltnum = (FLOAT) fltnum;
#endif
		if (fabs(Group->fltnum) < TOE)
			Group->fltnum = 0.0;
		(VOID) sprintf(DxfFileBuf, "%g", Group->fltnum);
		DxfFileByte += 8;
		return;
	}

	DXFERR("wrong group code %d\n", Group->code);
}

/*
 * skip over a section of a DXF file
 */

VOID	SkipSection()
{
	do
		GetNextGroup();
	while (CmpGroupString(Group, 0, "ENDSEC") == 0);

	GetNextGroup();
}

/*
 * parse BLOCKS section of a DXF file
 */

static	BLOCK	*BlockListTail = NULL;

VOID	ParseBlocksSection()
{
	BLOCK	*block;

	GetNextGroup();

	do
		if (CmpGroupString(Group, 0, "ENDSEC") == 0) {

			/*
			 * parse a block and insert it into the block list
			 */

			block = BlockDxfParse();
			if (BlockList == NULL)
				BlockList = BlockListTail = block;
			else {
				BlockListTail->next = block;
				BlockListTail = block;
			}
		}
	while (CmpGroupString(Group, 0, "ENDSEC") == 0);

	GetNextGroup();
}

/*
 * parse ENTITIES section of a DXF file
 */

static	ENTITY	*EntityListTail = NULL;

VOID	ParseEntitiesSection()
{
	ENTITY	*entity;

	GetNextGroup();

	do
		if (CmpGroupString(Group, 0, "ENDSEC") == 0) {

			/*
			 * parse an entity and insert it into the entity list
			 */

			entity = EntityDxfParse(&LayerList);
			if (entity != NULL)
				if (EntityList == NULL)
					EntityList = EntityListTail = entity;
				else {
					EntityListTail->next = entity;
					EntityListTail = entity;
				}
		}
	while (CmpGroupString(Group, 0, "ENDSEC") == 0);

	GetNextGroup();
}

/*
 * skip over END OF FILE
 */

VOID	SkipEndOfFile()
{
	if (CmpGroupString(Group, 0, "EOF") == 0)
		DXFERR("expect EOF but get %s\n", Group->string);

	/*
	 * should we check more ?
	 */

	return;
}

/*
 * main body for parsing a DXF file
 */

VOID	ParseDxfFile(FileName)
CHAR	*FileName;
{

	DxfFileName = FileName;

#ifdef	MSDOS
	DxfFile = fopen(DxfFileName, "rb");
#else
	DxfFile = fopen(DxfFileName, "r");
#endif
	if (DxfFile == NULL) {
		fprintf(stderr, "\n%s: DXF file %s - cannot be opened\n",
				ProgName, DxfFileName);
		return;
	}

	/*
	 * check if the DXF file is ascii or binary
	 */

	if (fread(DxfFileBuf, BinaryDxfHeaderLength, sizeof(CHAR), DxfFile) < 1) {
		fprintf(stderr, "\n%s: DXF file %s - cannot read file header\n",
				ProgName, DxfFileName);
		return;
	}

	if (strcmp(BinaryDxfHeader, DxfFileBuf) != 0)
		DxfAscOrBin = 0;
	else
		DxfAscOrBin = 1;

	DxfFileLine = 0;
	DxfFileByte = BinaryDxfHeaderLength;

	if (DxfAscOrBin == 0) {
		(VOID) fclose(DxfFile);
#ifdef	MSDOS
		DxfFile = fopen(DxfFileName, "rb");
#else
		DxfFile = fopen(DxfFileName, "r");
#endif
		if (DxfFile == NULL) {
			fprintf(stderr, "\n%s: DXF file %s - cannot be opened\n",
					ProgName, DxfFileName);
			return;
		}
	}

	Group = &DxfGroup;
	Group->string = DxfFileBuf;

	GetNextGroup();
	while (CmpGroupString(Group, 0, "SECTION") != 0) {
		GetNextGroup();
		if (CmpGroupString(Group, 2, "HEADER") != 0)
			SkipSection();
		else
		if (CmpGroupString(Group, 2, "TABLES") != 0)
			SkipSection();
		else
		if (CmpGroupString(Group, 2, "BLOCKS") != 0)
			ParseBlocksSection();
		else
		if (CmpGroupString(Group, 2, "ENTITIES") != 0)
			ParseEntitiesSection();
		else
		if (Group->code == 2)
			DXFERR("invalid section %s\n", Group->string);
	}

	SkipEndOfFile();

	(VOID) fclose(DxfFile);
}
