/* Copyright (c) 1988 Regents of the University of California */

#ifndef lint
static char SCCSid[] = "@(#)ra_im.c 2.1 11/12/91 LBL";
#endif

/*
 *  ra_im.c - convert Radiance picture to imagetools raw format.
 *
 *	9/16/88
 */

#include <stdio.h>


#define PCOMM		"pvalue -h -b -db"

#define MINVAL		1
#define MAXVAL		252

extern FILE	*popen(), *freopen();


main(argc, argv)
int	argc;
char	*argv[];
{
	register int	c;
	register FILE	*fp;

	if (argc > 3) {
		fputs("Usage: ", stderr);
		fputs(argv[0], stderr);
		fputs(" [infile [outfile]]\n", stderr);
		exit(1);
	}
	if (argc > 1 && freopen(argv[1], "r", stdin) == NULL) {
		perror(argv[1]);
		exit(1);
	}
	if (argc > 2 && freopen(argv[2], "w", stdout) == NULL) {
		perror(argv[2]);
		exit(1);
	}
	if ((fp = popen(PCOMM, "r")) == NULL) {
		perror(argv[0]);
		exit(1);
	}
	while ((c = getc(fp)) != EOF) {
		if (c < MINVAL)
			putc(MINVAL, stdout);
		else if (c > MAXVAL)
			putc(MAXVAL, stdout);
		else
			putc(c, stdout);
	}
	exit(pclose(fp));
}
