/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           Animation.c
 *  Filetyp:            Modul
 *  Studienarbeit Nr.:  1198
 ********************************************************************************
 *  Modulname:          
 *  Version:            1.1
 *  letzte Aenderung:   
 *  Autor:              Andreas 
 *  Status:             finished, only bugs will be fixed
 *
 *  imp. Bezeichner:    
 * 
 *  exp. Bezeichner:
 *     void SequenzRechneAnzeige (Widget, XtPointer, XtPointer):
 *                   die Routine initialisiert verschiedene Daten und bringt
 *                   das Animations-Fenster auf den Bildschirm.
 *  Beschreibung:
 *  -------------
 *  In diesem Modul wird das Animationsfenster aufgebaut und verwaltet. D.h.
 *  zu allen Funktionalitten wurden Routinen geschrieben, die dieselben unter-
 *  sttzen.
 * 
 *
 *  Versionsgeschichte:
 *  -------------------
 *  -10.12.92: Bereitstellen der Funktionalitt
 *   11.12.92: Hinzufgen neuer Funktionalitten (diese nderung ist in Folge
 *             einer Neuformulierung des Editors geschehen). Erste 'laufende' 
 *             Bilder.
 *   16.12.92: Einbauen des Synchronisationskonzeptes.
 *   08.01.93: Einbinden fast aller Synchronisationsoperationen. Dabei wurde ein
 *             Mangel in der Konzeption von TWelt erkannt: Pointer auf den akt.
 *             Sync-Point fehlt.
 *   13.01.93: nderung der Sync-Operationen.
 *   14.01.93: Hinzufgen von clearSync-Funktionalitt.
 *   28.01.93: Es wird die eigentliche FolgeBildRoutine statt einer Dummy-Routine
 *             eingebunden. 
 *   05.05.93: Raytracen ist nun mglich.
 *   09.03.94: Anpassung an die Raytracerausgabe fr POVray 2.x
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Dialog.h>

#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "Welt.h"
#include "anzeigeconst.h"
#include "rayausg.h"
#include "bitmap/firstSync.xbm"
#include "bitmap/lastSync.xbm"
#include "bitmap/nextSync.xbm"
#include "bitmap/prevSync.xbm"
#include "bitmap/step.xbm"
#include "bitmap/play.xbm"
#include "bitmap/stop.xbm"


/********************************************************************************
 * Importierte Routinen von Anzeige.c (Hartmut)
 ********************************************************************************/
   extern  void OeffneAnimation (XtAppContext *, Widget);
   extern  void SchliesseAnimation (XtAppContext *, Widget);
   extern  void AnzeigeAnimation (Widget, TKamera, TZustand *, int);

/********************************************************************************
 * Importierte Routienen von Kopie.c
 ********************************************************************************/
   extern  void KopiereWelt (TWelt **, TWelt *);
   extern  void entferneWelt (TWelt **);

/********************************************************************************
 * Importierte Routienen aus verschiedenen Modulen
 ********************************************************************************/
   extern  void KameraInit (Widget, XtPointer, XtPointer);
   extern  void toggleNOStatus (TBoolean);
   extern  void UnHighLight (TKoerper *);
   extern  void HighLight (TKoerper *);
   extern  void DObjektEinfuegen (void);
   extern  void SchreibeSequenz (char *, TBoolean);
   extern  void KameraDefaults (Widget, XtPointer, XtPointer);

/********************************************************************************
 *  Global definierte Variablen (Editor.c)
 ********************************************************************************/
extern Widget topLevel, AW_Animation, AW_Shell, AW_box, AW_Pause, AW_Play, 
              AW_prevSync, AW_Step, AW_toggleSync, AW_nextSync, AW_firstSync,  
              AW_Close, AW_FrameCnt, AW_Kamera, AW_toggleSzenenAnfang,
              AW_lastSync, KW_Shell, AW_Raytracing;
extern XtAppContext appContext;
extern TWelt *firstSync, *lastSync, *aktuelleWelt;
extern TReal ZeitIncrement;
extern TKamera AnimKamera;
extern int KoordAnAus, KoerperKoordAnAus, dreiD;
extern TKoerper *selektiertesObjekt;
extern TBoolean AnimKameraOpen;
extern char *raytracedFile;
extern long raytracerVersion;


/********************************************************************************
 *  nur in diesem Modul sichtbare Variablen
 ********************************************************************************/
static TModusAnimation modusAnimation = anim_PAUSE;
static TBoolean NeuerSzenenAnfang = TRUE;
static TBoolean RaytracingOn = FALSE;
static TBoolean Ungeaendert, Sequenz;
static Widget GRN_getRayName, GRN_Dialog, AW_dreiD, AW_Sequenz;
static char rayName[80];



/*******************************************************************************
 *  TBoolean isGleich (TReal a, TReal b)
 *
 *  TReal     a, b    : zu vergleichende Werte
 *  TBoolean  isGleich: liefert TRUE zurck, wenn die Werte a und b innerhalb
 *                      eines Epsilon-Bereiches liegen, sonst FALSE
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine wird bentigt, um Rundungsfehler, die durch die Verwendung von 
 *  Gleitkommazahlen zustande kommen vernachlssigbar werden. Liegen die Werte a
 *  und b innerhalb eines Epsilon-Bereiches, wird angenommen, da sie gleich 
 *  sind. Diese Annahme kann getroffen werden, da es sich bei den Werten a und b
 *  nur um (diskrete) Zeitwerte handelt. 
 ********************************************************************************/

TBoolean isGleich (TReal a, TReal b)
{
     TReal Epsilon = ZeitIncrement/10;

     if (a-Epsilon <= b && a+Epsilon >= b)
	  return (TRUE);
     else return (FALSE);
}


/*******************************************************************************
 *  void sucheObjekt (TBoolean Anzeige)
 *  TBoolean Anzeige: Gibt an, ob das Bild sofort angezeigt werden soll
 *
 *  Beschreibung:
 *  -------------
 *  Seit die Kamera an ein Objekt 'gemountet'werden kann, gibt es Probleme mit 
 *  den Szenenanfngen. Da die Referenzierung eines Objektes ber einen Pointer
 *  bei einem Szenenanfang keinen Sinn hat, mu das Objekt in der Objektliste
 *  des Szenenanfangs gesucht werden. Ein Objekt ist durch seine Objektnummer 
 *  eineindeutig markiert.
 *  Ist das Objekt im der neuen Szene nicht mehr enthalten, werden die Standard-
 *  einstellungen fr die Kamera genommen.
 ********************************************************************************/

void sucheObjekt (TBoolean Anzeige)
{
     TKoerper *help;
     TBoolean NotFound = TRUE ;

     help = aktuelleWelt->Welt.Koerper;
     while (help != NULL && NotFound)
	  if (help->KoerperId == AnimKamera.MountObjId)
	       NotFound = FALSE;
	  else
	       help = help->Naechster;
     if (NotFound)
     {
	  KameraDefaults (topLevel, (XtPointer) Anzeige, NULL);
	  AnimKamera.MountObj = NULL;
	  AnimKamera.MountObjId = 0;
     }
     else 
     {
	  AnimKamera.MountObj = help;
	  AnimKamera.Position[0] = help->Position[0]+AnimKamera.Offset[0];
	  AnimKamera.Position[1] = help->Position[1]+AnimKamera.Offset[1];
	  AnimKamera.Position[2] = help->Position[2]+AnimKamera.Offset[2];
	  if (Anzeige)
	       AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
				 KoordAnAus|KoerperKoordAnAus|dreiD);
     }
}


void pruefeSyncButtons (void)
{
     char frameNr[20];
     
     sprintf (frameNr, "%12ld", aktuelleWelt->FrameCounter);
     XtVaSetValues (AW_FrameCnt, XtNlabel, frameNr, NULL);
     if (aktuelleWelt->thisSync != NULL)
	  XtVaSetValues (AW_toggleSync, XtNlabel, "   sync  ", NULL);
     else
	  XtVaSetValues (AW_toggleSync, XtNlabel, " no sync ", NULL);
     XtSetSensitive (AW_toggleSync, TRUE);
     if (aktuelleWelt->SzenenAnfang)
	  XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel,"  new scene ", NULL); 
     else
	  XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel, " same scene ", NULL); 
     if (firstSync != NULL)
	  XtSetSensitive (AW_firstSync, TRUE);
     else 
	  XtSetSensitive (AW_firstSync, FALSE); 
     if (aktuelleWelt->prevSync != NULL)
	  XtSetSensitive (AW_prevSync, TRUE); 
     else
	  XtSetSensitive (AW_prevSync, FALSE);
     if (aktuelleWelt->nextSync != NULL)
	  XtSetSensitive (AW_nextSync, TRUE);
     else
	  XtSetSensitive (AW_nextSync, FALSE);
     if (lastSync != NULL)
	  XtSetSensitive (AW_lastSync, TRUE);
     else
	  XtSetSensitive (AW_lastSync, FALSE);
}



/*******************************************************************************
 *  void SequenzRechneAnzeige (Widget w, XtPointer clientData, XtPointer garbage)
 *  
 *  Beschreibung:
 *  -------------
 *  Die Routine "offnet die Animations-Shell (nur 3-D Ansicht) und initalisiert
 *  die f"ur die Grafik ben"otigten Attribute und Variablen."
 ********************************************************************************/

void SequenzRechneAnzeige (Widget w, XtPointer muell, XtPointer garbage)
{
     char frameNr[20];
     TWelt *help, *help1;

     XtPopup (AW_Shell, XtGrabExclusive);
     OeffneAnimation (&appContext, AW_Animation);
     if (AnimKamera.MountObj != NULL)
	  sucheObjekt (TRUE);
     else
	  AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
			    KoordAnAus|KoerperKoordAnAus|dreiD);
     toggleNOStatus (FALSE);
     UnHighLight (selektiertesObjekt);
     selektiertesObjekt = NULL;
     
     RaytracingOn = FALSE;
     XtVaSetValues (AW_Raytracing, XtNstate, FALSE, NULL);

     aktuelleWelt->SzenenAnfang = TRUE;
     if (firstSync == NULL)
     {
	  KopiereWelt (&firstSync, aktuelleWelt);
	  aktuelleWelt->thisSync = firstSync; 
	  lastSync = firstSync;
     }
     else 
     {
	  if (aktuelleWelt->thisSync != NULL)
	       entferneWelt (&aktuelleWelt->thisSync);
	  
	  help = aktuelleWelt->nextSync;
	  while (help != NULL && !help->SzenenAnfang)
	  {
	       aktuelleWelt->nextSync = help->nextSync;
	       entferneWelt (&help);
	       help = aktuelleWelt->nextSync;
	  }
	  help1 = NULL;      
	  KopiereWelt (&help1, aktuelleWelt);
	  aktuelleWelt->thisSync = help1;
	  if (aktuelleWelt->prevSync != NULL)
	       aktuelleWelt->prevSync->nextSync = aktuelleWelt->thisSync;
	  else
	       firstSync = aktuelleWelt->thisSync;
	  if (aktuelleWelt->nextSync != NULL)
	       aktuelleWelt->nextSync->prevSync = aktuelleWelt->thisSync;
	  else
	       lastSync = aktuelleWelt->thisSync;
     }
     XtVaSetValues (AW_toggleSync, XtNlabel,"    sync   ", NULL); 
     XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel,"  new scene ", NULL); 
     
     sprintf (frameNr, "%12ld", aktuelleWelt->FrameCounter);
     XtVaSetValues (AW_FrameCnt, XtNlabel, frameNr, NULL);
     XtSetSensitive (AW_toggleSync, TRUE); 
     pruefeSyncButtons();
     Ungeaendert = FALSE;
}


/*******************************************************************************
 *  void berechneSequenz (char *fileName, int Bilder)
 *  char *fileName: Dateiname unter dem die Sequenz abgelegt werden soll.
 *  int Bilder:     Anzahl der zu berechnenden Bilder.
 *
 *  Beschreibung:
 *  -------------
 *  Diese Routine berechnet von einer Sequenz bzw. Zustand die Anzahl 'Bilder' 
 *  Zust"ande. Die Zust"ande werden zun"achst in Sync-Punkten zwischengespeichert,
 *  nach Berechnung aller Bilder werden dann alle Sync-Punkte auf Platte ge-
 *  schrieben. Werden sehr viele Bilder berechnet, kann die Datei unter Umst"anden
 *  sehr lange werden.
 ********************************************************************************/

void berechneSequenz (char *fileName, int Bilder)
{
     TWelt *help;
     int i = 1;

     /*****************************************************************************
      * Zuyn"achst erfolgt die Initialisierung, in der die Sequenz-Datei und das 
      * Verzeichnis ge"offnet werden. dann kann die Rechnerei beginnen.
      *****************************************************************************/

     Ungeaendert = FALSE;
     /*****************************************************************************
      * Umsetzen der Sync-Pointer, wenn man einen Sync-Punkt 'passiert'.
      *****************************************************************************/
     while (i <= Bilder)
     {
	  aktuelleWelt->FrameCounter ++;
	  if (aktuelleWelt->thisSync != NULL)
	  {
	       aktuelleWelt->prevSync = aktuelleWelt->thisSync;
	       aktuelleWelt->thisSync = NULL;
	  }
	  if (aktuelleWelt->nextSync != NULL)
	  {
	       if (isGleich (aktuelleWelt->Welt.Zeit+ZeitIncrement, 
			     aktuelleWelt->nextSync->Welt.Zeit))
	       {
		    aktuelleWelt->thisSync = aktuelleWelt->nextSync;
		    aktuelleWelt->nextSync = aktuelleWelt->nextSync->nextSync;
		    if (aktuelleWelt->thisSync->SzenenAnfang /* == TRUE */)
		    {
			 help = aktuelleWelt->thisSync;
			 entferneWelt (&aktuelleWelt);
			 KopiereWelt (&aktuelleWelt, help);
			 Ungeaendert = FALSE;
		    }
		    else 
		    {
			 if (Ungeaendert)
			      UngeaendertFBB (&aktuelleWelt->Welt); 
			 FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
			 Ungeaendert = TRUE;
			 aktuelleWelt->SzenenAnfang = FALSE;
		    }
	       }
	       else
	       {
		    aktuelleWelt->thisSync = NULL;
		    aktuelleWelt->SzenenAnfang = FALSE;
		    if (Ungeaendert)
			 UngeaendertFBB (&aktuelleWelt->Welt); 
		    FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
		    Ungeaendert = TRUE;
	       }
	  }
	  else 
	  {
	       if (Ungeaendert)
		    UngeaendertFBB (&aktuelleWelt->Welt); 
	       FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
	       aktuelleWelt->SzenenAnfang = FALSE;
	  }   
	  if (aktuelleWelt->thisSync == NULL)
	  {
	       aktuelleWelt->SzenenAnfang = TRUE;
	       help = NULL;
	       KopiereWelt (&help, aktuelleWelt);
	       if (help->prevSync != NULL)
		    help->prevSync->nextSync = help;
	       if (help->nextSync != NULL)
		    help->nextSync->prevSync = help;
	       aktuelleWelt->thisSync = help;
	  }
	  i++;
     }
     SchreibeSequenz (fileName, TRUE);
}


/*******************************************************************************
 *  NextAnimation (Widget w, XEvent *event, String *params, Cardinal *num_params)
 *  
 *  Beschreibung:
 *  -------------
 *  Diese Routine ist als Action eingetragen. Die Routine wird aufgerufen, wenn 
 *  ein 'ClientMessageEvent' beim Animations-Fenster (AW_Animation) angekommen ist.
 *  Zunchst ruft diese Routine eine Prozedur zur Bestimmung des Folgezustandes
 *  auf und zeigt diesen dann mit dem Aufruf von AnzeigeAnimation an.
 *      Wenn das Flag modusAnimation auf anim_PLAY steht, wird ein 'ClientMessage'
 *  Event an das Animationsfenster geschickt. Diese komplizierte Schleifenkon-
 *  struktion ist notwendig, um auch noch andere Events bearbeiten zu knnen.
 *     Es wurde eine ndeung durchgefhrt: 19.01.93.
 *  Durch ndern der aktuellen Welt und Zurckkehren in das Animationsfenster
 *  wird ein Szenenschnitt durchgefhrt. Kommt man in der Berechnung an diesen
 *  Punkt, so darf die Szene mit den alten Daten nicht mehr weitergerechnet wer-
 *  den, sondern es mu eine Kopie des Folgezustands angelegt werden (keine
 *  Berechnung!). Andernfalls kann die Folgeschrittberechnung durchgefhrt wer-
 *  den.
 ********************************************************************************/

void NextAnimation (Widget w, XEvent *event, String *params, Cardinal *num_params)
{
     static char frameNr[10], ray[20];
     XClientMessageEvent newEvent;
     TWelt *help;
     long h2;
     
     if (modusAnimation != anim_PAUSE)
     {
	  aktuelleWelt->FrameCounter ++;
	  /*****************************************************************************
	   * Umsetzen der Sync-Pointer, wenn man einen Sync-Punkt 'passiert'.
	   *****************************************************************************/
	  if (aktuelleWelt->thisSync != NULL)
	  {
	       aktuelleWelt->thisSync->FrameCounter = aktuelleWelt->FrameCounter-1;
	       aktuelleWelt->prevSync = aktuelleWelt->thisSync;
	       aktuelleWelt->thisSync = NULL;
	       XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel, " same scene ", NULL); 
	       XtVaSetValues (AW_toggleSync, XtNlabel, " no sync ", NULL); 
	  }
	  if (aktuelleWelt->nextSync != NULL)
	  {
	       if (isGleich (aktuelleWelt->Welt.Zeit+ZeitIncrement, 
			     aktuelleWelt->nextSync->Welt.Zeit))
	       {
		    XtVaSetValues (AW_toggleSync, XtNlabel, "   sync  ", NULL); 
		    aktuelleWelt->thisSync = aktuelleWelt->nextSync;
		    aktuelleWelt->nextSync = aktuelleWelt->nextSync->nextSync;
		    if (aktuelleWelt->thisSync->SzenenAnfang)
		    {
			 h2 = aktuelleWelt->FrameCounter;
			 help = aktuelleWelt->thisSync;
			 entferneWelt (&aktuelleWelt);
			 KopiereWelt (&aktuelleWelt, help);
			 aktuelleWelt->FrameCounter = h2;
			 XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel, "  new scene ", NULL); 
			 Ungeaendert = FALSE;
			 if (AnimKamera.MountObj != NULL)
			      sucheObjekt (FALSE);
		    }
		    else 
		    {
			 if (Ungeaendert)
			      UngeaendertFBB (&aktuelleWelt->Welt); 
			 FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
			 Ungeaendert = TRUE;
			 aktuelleWelt->SzenenAnfang = FALSE;
		    }
	       }
	       else
	       {
		    aktuelleWelt->thisSync = NULL;
		    aktuelleWelt->SzenenAnfang = FALSE;
		    if (Ungeaendert)
			 UngeaendertFBB (&aktuelleWelt->Welt); 
		    FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
		    Ungeaendert = TRUE;
	       }
	  }
	  else 
	  {
	       if (Ungeaendert)
		    UngeaendertFBB (&aktuelleWelt->Welt); 
	       FolgeBildBerechnung (&aktuelleWelt->Welt, ZeitIncrement);
	       aktuelleWelt->SzenenAnfang = FALSE;
	  }   
	  sprintf (frameNr, "%12ld", aktuelleWelt->FrameCounter);
	  XtVaSetValues (AW_FrameCnt, XtNlabel, frameNr, NULL);
	  if (AnimKamera.MountObj != NULL)
	  {
	       AnimKamera.Position[0] = AnimKamera.MountObj->Position[0]+AnimKamera.Offset[0];
	       AnimKamera.Position[1] = AnimKamera.MountObj->Position[1]+AnimKamera.Offset[1];
	       AnimKamera.Position[2] = AnimKamera.MountObj->Position[2]+AnimKamera.Offset[2];
	  }
	  AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
			    KoordAnAus|KoerperKoordAnAus|dreiD);
	  if (Sequenz && aktuelleWelt->thisSync == NULL)
	  {
	       aktuelleWelt->SzenenAnfang = TRUE;
	       help = NULL;
	       KopiereWelt (&help, aktuelleWelt);
	       if (help->prevSync != NULL)
		    help->prevSync->nextSync = help;
	       else firstSync = help;
	       if (help->nextSync != NULL)
		    help->nextSync->prevSync = help;
	       else lastSync = help;
	       aktuelleWelt->thisSync = help;
	  }
	  if (RaytracingOn)
	  {
	       sprintf (ray,"%s%05ld", rayName, aktuelleWelt->FrameCounter);
	       ErzeugeRaytracerBild (ray, AnimKamera, &aktuelleWelt->Welt, dreiD, 
				     raytracerVersion, aktuelleWelt->FrameCounter);
	  }
	  if (modusAnimation == anim_PLAY)
	  {
	       strcpy (newEvent.data.b,"NextPicture");
	       newEvent.type = ClientMessage;
	       newEvent.window = XtWindow (AW_Animation);
	       newEvent.format = 8;
	       XSendEvent (XtDisplay (AW_Animation), XtWindow (AW_Animation), TRUE, 0,
			   (XEvent*) &newEvent);
	  }
	  else
	       pruefeSyncButtons ();
     }
     else
	  pruefeSyncButtons ();
}


/*******************************************************************************
 *  void AnimationPlay (Widget w, XtPointer stop, XtPointer garbage)
 *  XtPointer stop                                                                              
 *  Fehler:  (Beschreibung evtl. Fehlerwerte im Resultatsparameter)
 *  
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt ein Flag, das anzeigt, da"s die Animation l"auft. 
 *     Da die Animation laufen soll bis der Pauseknopf gedr"uckt ist, wird eine
 *  'ClientMessage' an das Animations-Fenster geschickt (Begr"undung siehe oben).
 ********************************************************************************/

void AnimationPlay (Widget w, XtPointer clientData, XtPointer garbage)
{
     XtSetSensitive (AW_Close, FALSE); /* */
     XtSetSensitive (AW_firstSync, FALSE);
     XtSetSensitive (AW_prevSync, FALSE); 
     XtSetSensitive (AW_Step, FALSE);
     XtSetSensitive (AW_Play, FALSE);
     XtSetSensitive (AW_nextSync, FALSE);
     XtSetSensitive (AW_lastSync, FALSE);
     XtSetSensitive (AW_toggleSync, FALSE); 
     XtSetSensitive (AW_toggleSzenenAnfang, FALSE); 
     
     modusAnimation = anim_PLAY;
     NextAnimation (topLevel, NULL, NULL, NULL);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine setzt das Flag 'modusAnimation' auf 'Pause', so da"s in der 
 *  Routine 'NextAnimation' kein weiters mal aufgerufen wird. Zus"atzlich 
 *  werden s"amtlichen deaktivierten Kn"opfe aktiviert.
 ********************************************************************************/

void AnimationPause (Widget w, XtPointer clientData, XtPointer garbage)
{  
     modusAnimation = anim_PAUSE;
   
     XtSetSensitive (AW_Step, TRUE);
     XtSetSensitive (AW_Close, TRUE);
     XtSetSensitive (AW_toggleSync, TRUE); 
     XtSetSensitive (AW_toggleSzenenAnfang, TRUE); 
     XtSetSensitive (AW_Play, TRUE);
     pruefeSyncButtons();
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  Die Routine ruft 'NextAnimation' ber eine ClientMessage auf. Damit diese
 *  Routine nicht in eine Schleife geht, was hier nicht erwnscht ist, wird
 *  das Flag 'modusAnimation' auf Pause gesetzt. 
 ********************************************************************************/

void AnimationStep (Widget w, XtPointer stop, XtPointer garbage)
{
     modusAnimation = anim_STEP;
     NextAnimation (topLevel, NULL, NULL, NULL);
} 


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  Das Animations-Fenster wird geschlossen und der Anzeigeroutine diese mit-
 *  geteilt. Die Routine kann ber zwei Tasten ausgelst werden:
 *       close-Button     -- Fenster schliessen
 *       neueSzene-Button -- Fenster schliessen, beim erneuten ffnen des 
 *                           AnimationsFensters wird ein Sync-Punkt und das Flag 
 *                           'SzenenAnfang' auf TRUE gesetzt.
 ********************************************************************************/

void AnimationClose (Widget w, XtPointer Flag, XtPointer garbage)
{
     if (AnimKameraOpen)
     {
	  XtPopdown (KW_Shell);
	  AnimKameraOpen = FALSE;
     }
     XtPopdown (AW_Shell);
     SchliesseAnimation (&appContext, AW_Animation);
     NeuerSzenenAnfang = (TBoolean) Flag;
     selektiertesObjekt = aktuelleWelt->Welt.Koerper;
     HighLight (selektiertesObjekt);
     DObjektEinfuegen();
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void AnimationFirstSync (Widget w, XtPointer muell, XtPointer garbage)
{
     if (firstSync != NULL)
     {
	  entferneWelt (&aktuelleWelt); 
	  KopiereWelt (&aktuelleWelt, firstSync);
	  aktuelleWelt->thisSync = firstSync;
	  if (AnimKamera.MountObj != NULL)
	       sucheObjekt (TRUE);
	  pruefeSyncButtons();
	  Ungeaendert = FALSE;
	  AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
			    KoordAnAus|KoerperKoordAnAus|dreiD);
     }
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void AnimationPrevSync (Widget w, XtPointer muell, XtPointer garbage)
{
     TWelt *help;
     
     if (aktuelleWelt->prevSync != NULL)
     {
	  help = aktuelleWelt->prevSync;
	  entferneWelt (&aktuelleWelt);
	  KopiereWelt (&aktuelleWelt, help);
	  aktuelleWelt->thisSync = help;
	  if (AnimKamera.MountObj != NULL)
	       sucheObjekt (TRUE);
	  pruefeSyncButtons();
	  Ungeaendert = FALSE;
     } 
     else fprintf (stderr, "No previous sync-point.\n");
     AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|dreiD);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void AnimationNextSync (Widget w, XtPointer muell, XtPointer garbage)
{
     TWelt *help;
     
     if (aktuelleWelt->nextSync != NULL)
     {
	  help = aktuelleWelt->nextSync;
	  entferneWelt (&aktuelleWelt);
	  aktuelleWelt = NULL;
	  KopiereWelt (&aktuelleWelt, help);
	  aktuelleWelt->thisSync = help;
	  if (AnimKamera.MountObj != NULL)
	       sucheObjekt (TRUE);
	  pruefeSyncButtons();
	  Ungeaendert = FALSE;
     }
     else fprintf (stderr, "No more sync-points.\n");
     AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|dreiD);
}


/*******************************************************************************
 *  
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void AnimationLastSync (Widget w, XtPointer muell, XtPointer garbage)
{
     if ((lastSync != NULL) && (aktuelleWelt->FrameCounter <= lastSync->FrameCounter))
     {
	  entferneWelt (&aktuelleWelt); 
	  aktuelleWelt = NULL;
	  KopiereWelt (&aktuelleWelt, lastSync);
	  if (AnimKamera.MountObj != NULL)
	       sucheObjekt (TRUE);
	  AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
			    KoordAnAus|KoerperKoordAnAus|dreiD);
	  pruefeSyncButtons();
	  Ungeaendert = FALSE;
     }
}


/*******************************************************************************
 *  void AnimationSync (void)
 *
 *  Beschreibung:
 *  -------------
 *  
 ********************************************************************************/

void AnimationSync (void)
{
     TWelt *help;
   
     if (aktuelleWelt->thisSync == NULL)
     {
	  help = NULL;
	  KopiereWelt (&help, aktuelleWelt);
	  aktuelleWelt->thisSync = help;
	  if (aktuelleWelt->nextSync == NULL)
	       lastSync = help;
	  else aktuelleWelt->nextSync->prevSync = help;
	  if (aktuelleWelt->prevSync != NULL)
	       aktuelleWelt->prevSync->nextSync = help;
	  if (firstSync == NULL)
	  {
	       firstSync = aktuelleWelt->thisSync;
	       lastSync = firstSync;
	  }
	  
	  XtVaSetValues (AW_toggleSync, XtNlabel, "   sync  ", NULL);
	  if (aktuelleWelt->SzenenAnfang)
	       XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel, "  new scene ", NULL); 
	  else
	       XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel, " same scene ", NULL); 
     }
     else fprintf (stderr,"Something went terribly wrong in AnimationSync\n");
}


/*******************************************************************************
 *  void AnimationClearSync (void)
 *                                                                              
 *  Beschreibung:                                                               
 *  -------------                                                               
 *  Die Routine entfernt einen Sync-Punkt aus der Sync-Liste. Die Routine sollte
 *  nur dann aufrufbar sein, wenn man auf einem Sync-Punkt steht. Es darf aller-
 *  dings nicht der einzige (verbleibende) Sync-Punkt entfernt werden. Ist dies 
 *  nicht der Fall wird der aktuelle Sync-Punkt aus der Liste entfernt.Es mssen 
 *  dabei einige Sonderflle beachtet werden:
 *      1.) Sync-Punkt ist der Anfang der Liste -> Umsetzen des Zeigers 
 *          'firstSync'auf den folgenden Sync-Punkt.
 *      2.) Sync-Punkt ist am Ende der Liste -> Umsetzen des Zeigers 'lastSync'
 *          auf den vorhergehenden Sync-Punkt.
 *  Danach wird der Button deaktiviert, da man nun nicht mehr auf einem Sync-
 *  Punkt steht.
 *              ------  prevSync  ------  prevSync  ------
 *              |    |<-----------|    |<-----------|    |
 *  <-----------|    |----------->|    |----------->|    |----------->
 *    prevSync  ------  nextSync  ------  nextSync  ------  nextSync
 *                /|\              /|\                /|\
 *                 |                | thisSync         |
 *                  \  prevSync   ------              /
 *                   -------------|    |   nextSync  /
 *                                |    |-------------
 *                                ------
 * Daraus wird:
 *                              prevSync
 *                         -------------------- 
 *              ------   /        ------        \   ------
 *              |    |<-    re-   |    |          --|    |
 *  <-----------|    |---   moved |    |          ->|    |----------->
 *    prevSync  ------    \       ------        /   ------  nextSync
 *                /|\       -------------------       /|\
 *                 |             nextSync              |
 *                  \  prevSync   ------              /
 *                   -------------|    |   nextSync  /
 *                                |    |-------------
 *                                ------
 *                                  | thisSync
 *                                 \|/
 *                                  v
 *                                NULL
 ********************************************************************************/

void AnimationClearSync (void)
{
     TBoolean Next = FALSE;
     if (aktuelleWelt->thisSync != NULL)
     {
	  if (aktuelleWelt->SzenenAnfang)
	  {
	       Next = TRUE;
	       aktuelleWelt->SzenenAnfang = FALSE;
	  }
	  else 
	       Next = FALSE;
	  entferneWelt (&aktuelleWelt->thisSync);
	  if (Next)
	       while (aktuelleWelt->nextSync != NULL && !aktuelleWelt->nextSync->SzenenAnfang)
	       {
		    aktuelleWelt->thisSync = aktuelleWelt->nextSync->nextSync;
		    entferneWelt (&aktuelleWelt->nextSync);
		    aktuelleWelt->nextSync = aktuelleWelt->thisSync;
		    aktuelleWelt->thisSync = NULL;
	       }
	  if (aktuelleWelt->prevSync != NULL)
	  {
	       aktuelleWelt->prevSync->nextSync = aktuelleWelt->nextSync;
	       if (aktuelleWelt->nextSync == NULL)
	       { 
		    lastSync = aktuelleWelt->prevSync;
		    lastSync->nextSync = NULL;
	       }
	  }
	  else 
	  {
	       firstSync = aktuelleWelt->nextSync;
	       if (firstSync == NULL)
		    lastSync = NULL;
	  }
	  if (aktuelleWelt->nextSync != NULL)
	       aktuelleWelt->nextSync->prevSync = aktuelleWelt->prevSync;
	  else
	       lastSync = aktuelleWelt->prevSync;
	  
	  XtVaSetValues (AW_toggleSync, XtNlabel,"   no sync  ", NULL); 
	  XtVaSetValues (AW_toggleSzenenAnfang, XtNlabel,"same scene", NULL); 
     }
     else fprintf (stderr, "no sync-Point! This should never happen (AnimationClearSync)\n");
}


void ApplyGRN (Widget w, XtPointer muell, XtPointer garbage)
{
     char ray[40];
     
     XtPopdown (GRN_getRayName);
     raytracedFile = XawDialogGetValueString (GRN_Dialog);
     if (mkdir (raytracedFile, 511) == 0 || errno == EEXIST)
     {
	  sprintf (rayName,"%s/%s", raytracedFile, raytracedFile);
	  sprintf (ray,"%s%05ld", rayName, aktuelleWelt->FrameCounter);
	  ErzeugeRaytracerBild (ray, AnimKamera, &aktuelleWelt->Welt, dreiD,
				raytracerVersion, aktuelleWelt->FrameCounter);
     }
     else fprintf (stderr,"some errors occured\n");
}


void initGRN (Widget w)
{
     Position x, y;
     Dimension width, height;
     
     x = 0; y = 0; width = 0; height = 0;
     XtVaGetValues (w, XtNwidth, &width, XtNheight, &height, NULL);
     XtTranslateCoords (w, 0, -3*height/2, &x, &y);
     XtVaSetValues (GRN_getRayName, XtNx, x, XtNy, y, NULL);
     XtVaSetValues (GRN_Dialog, XtNvalue, raytracedFile, NULL);
     
     XtPopup (GRN_getRayName, XtGrabNonexclusive);
}


void AnimationToggleRaytracing (Widget w, XtPointer param, XtPointer garbage)
{
     if (!RaytracingOn)
     {
	  RaytracingOn = TRUE;
	  initGRN (w);
     }
     else 
     {
	  RaytracingOn = FALSE;
	  if (param != NULL)
	  {
	       XtPopdown (GRN_getRayName);
	       XtVaSetValues (AW_Raytracing, XtNstate, FALSE, NULL);
	  }
     }
}


void AnimationToggleSzenenAnfang (Widget w, XtPointer muell, XtPointer garbage)
{
     if (aktuelleWelt->SzenenAnfang)
	  AnimationClearSync();
     else
     {
	  aktuelleWelt->SzenenAnfang = TRUE;
	  if (aktuelleWelt->thisSync != NULL)
	       aktuelleWelt->thisSync->SzenenAnfang = TRUE;
	  else
	       AnimationSync();
     }
     pruefeSyncButtons();
}


void AnimationToggleSync (Widget w, XtPointer muell, XtPointer garbage)
{
     if (aktuelleWelt->thisSync != NULL)
	  AnimationClearSync();
     else
	  AnimationSync();
     pruefeSyncButtons();
}


void Animation3D (Widget w, XtPointer muell, XtPointer garbage)
{
     if (dreiD == Show3dON) 
	  dreiD = 0;
     else dreiD = Show3dON;
     AnzeigeAnimation (AW_Animation, AnimKamera, &aktuelleWelt->Welt, 
		       KoordAnAus|KoerperKoordAnAus|dreiD);
}


/*******************************************************************************
 *  void AnimationToggleSequenz (Widget w, XtPointer muell, XtPointer garbage)
 *
 *  Beschreibung:
 *  -------------
 *  ndert den Wert des Sequenz-Flags, das anzeigt, ob ein berechnetes Bild zu
 *  einem Sync-Punkt wird.
 ********************************************************************************/

void AnimationToggleSequenz (Widget w, XtPointer muell, XtPointer garbage)
{
     if (Sequenz)
	  Sequenz = FALSE;
     else Sequenz = TRUE;
}


/*******************************************************************************
 *  void installAnimationWindow (void)
 *                                                                              
 *  Beschreibung:                                                               
 *  -------------                                                               
 *  Das Fenster, in dem die Animation gezeigt wird, wird mit dieser Routine 
 *  kreiert.
 ********************************************************************************/

void installAnimationWindow (void)
{
     Pixmap BfirstSync, BprevSync, BnextSync, BlastSync, Bstop, Bplay, Bstep;
     
     BfirstSync = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(
					 XtScreen(topLevel)), (char *)firstSync_bits, 
					 firstSync_width, firstSync_height);
     BprevSync = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(
					XtScreen(topLevel)), (char *)prevSync_bits, 
					prevSync_width, prevSync_height);
     BnextSync = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(
				        XtScreen(topLevel)), (char *)nextSync_bits, 
					nextSync_width, nextSync_height);
     BlastSync = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(
					XtScreen(topLevel)), (char *)lastSync_bits, 
					lastSync_width, lastSync_height);
     Bstop = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				    (char *)stop_bits, stop_width, stop_height);
     Bplay = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				    (char *)play_bits, play_width, play_height);
     Bstep = XCreateBitmapFromData (XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)),
				    (char *)step_bits, step_width, step_height);
     
     AW_Shell = XtVaCreatePopupShell("Animation", topLevelShellWidgetClass, topLevel, NULL);
     AW_box = XtVaCreateManagedWidget("AW_box", formWidgetClass, AW_Shell, NULL);
     AW_Animation = XtVaCreateManagedWidget("AW_Animation", simpleWidgetClass, AW_box, NULL);
     AW_Close = XtVaCreateManagedWidget("AW_Close", commandWidgetClass, AW_box, NULL);
     AW_firstSync = XtVaCreateManagedWidget("AW_firstSync", commandWidgetClass, AW_box, 
					    XtNbitmap, BfirstSync, NULL);
     AW_prevSync = XtVaCreateManagedWidget("AW_prevSync", commandWidgetClass, AW_box, 
					   XtNbitmap, BprevSync, NULL);
     AW_Pause = XtVaCreateManagedWidget("AW_Pause", commandWidgetClass, AW_box, XtNbitmap, 
					Bstop, NULL);
     AW_Step = XtVaCreateManagedWidget("AW_Step", commandWidgetClass, AW_box, XtNbitmap, 
				       Bstep, NULL);
     AW_Play = XtVaCreateManagedWidget("AW_Play", commandWidgetClass, AW_box, XtNbitmap, 
				       Bplay, NULL);
     AW_nextSync = XtVaCreateManagedWidget("AW_nextSync", commandWidgetClass, AW_box, 
					   XtNbitmap, BnextSync, NULL);
     AW_lastSync = XtVaCreateManagedWidget("AW_lastSync", commandWidgetClass, AW_box, 
					   XtNbitmap, BlastSync, NULL);
     AW_FrameCnt = XtVaCreateManagedWidget("AW_FrameCnt", labelWidgetClass, AW_box, NULL);
     AW_toggleSync = XtVaCreateManagedWidget("AW_toggleSync", commandWidgetClass, AW_box, NULL);
     AW_toggleSzenenAnfang = XtVaCreateManagedWidget("AW_toggleSzenenAnfang", commandWidgetClass, 
						     AW_box, NULL);
     AW_Kamera = XtVaCreateManagedWidget("AW_Kamera", commandWidgetClass, AW_box, NULL);
     AW_Raytracing = XtVaCreateManagedWidget("AW_Raytracing", toggleWidgetClass, AW_box, NULL);
     AW_dreiD = XtVaCreateManagedWidget("AW_dreiD", toggleWidgetClass, AW_box, NULL);
     AW_Sequenz = XtVaCreateManagedWidget("AW_Sequenz", toggleWidgetClass, AW_box, NULL);

     XtAddCallback (AW_Play, XtNcallback, AnimationPlay, (XtPointer) NULL);
     XtAddCallback (AW_Pause, XtNcallback, AnimationPause, NULL);
     XtAddCallback (AW_Step, XtNcallback, AnimationStep, (XtPointer) NULL);
     XtAddCallback (AW_Close, XtNcallback, AnimationClose, (XtPointer) FALSE);
     XtAddCallback (AW_firstSync, XtNcallback, AnimationFirstSync, NULL);
     XtAddCallback (AW_prevSync, XtNcallback, AnimationPrevSync, NULL);
     XtAddCallback (AW_nextSync, XtNcallback, AnimationNextSync, NULL);
     XtAddCallback (AW_lastSync, XtNcallback, AnimationLastSync, NULL);
     XtAddCallback (AW_toggleSync, XtNcallback, AnimationToggleSync, NULL);
     XtAddCallback (AW_toggleSzenenAnfang, XtNcallback, AnimationToggleSzenenAnfang, NULL);
     XtAddCallback (AW_Kamera, XtNcallback, KameraInit, NULL);
     XtAddCallback (AW_Raytracing, XtNcallback, AnimationToggleRaytracing, NULL);
     XtAddCallback (AW_dreiD, XtNcallback, Animation3D, NULL);
     XtAddCallback (AW_Sequenz, XtNcallback, AnimationToggleSequenz, NULL);


     GRN_getRayName = XtVaCreatePopupShell("Name to save raytraced Pictures", 
					   transientShellWidgetClass, topLevel, NULL);
     GRN_Dialog = XtVaCreateManagedWidget("GRN_Dialog", dialogWidgetClass, GRN_getRayName, NULL);
     XawDialogAddButton (GRN_Dialog, "GRN_Apply", ApplyGRN, NULL);
     XawDialogAddButton (GRN_Dialog, "GRN_Abort", AnimationToggleRaytracing, (XtPointer) TRUE);
     Sequenz = FALSE;
}


/*******************************************************************************
 *  SetzeActionsAnimation (XtAppContext *AppContxt, Widget Animation)
 *  XtAppContext *AppContxt: Zeiger auf den ApplicationContext
 *  Widget Animation:        Fenster fr das die Action NextAnimation instal-
 *                           liert wird (zugnglich ber die Translationtable)
 *
 *  Beschreibung:
 *  -------------
 *  Zunchst wird die Action NextAnimation installiert, dann die Translation-
 *  table fr das Animationsfenster gesetzt, so da bei einem 'ClientMessage'
 *  Event die Action NextAnimation aufgerufen wird. 
 ********************************************************************************/

void SetzeActionsAnimation (XtAppContext *AppContxt, Widget Animation)
{
     static XtActionsRec actions[] = { {"NextAnimation", NextAnimation} };
     static String trans = "#augment\n\
                            <ClientMessage>:  NextAnimation()";
     
     XtAppAddActions (*AppContxt, actions, XtNumber(actions));
     XtAugmentTranslations (Animation, XtParseTranslationTable(trans));
}
