/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		Material.c
 *  Filetyp:		Modul
 ********************************************************************************
 *  Modulname:		
 *  Version:		1.1
 *  letzte Aenderung:	
 *  Autor:  		Andreas
 *  Status:		finished, only bugs will be fixed
 *							
 *  imp. Bezeichner:	
 * 
 *  exp. Bezeichner:    
 *
 *  Beschreibung:
 *  -------------
 *										
 *  Fehler:
 *  -------
 *     
 *  Versionsgeschichte:
 *  -------------------
 *    18.03.93: Erste Arbeiten: Neue Materialen.
 *    19.03.93: Materialdaten-Fenster wurde hinzugef"ugt.
 *    26.05.93: Beide Fenster wurden um die neuen Parameter erweitert."
 ********************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Command.h>
#include <X11/Shell.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Repeater.h>
#include <X11/Xaw/AsciiText.h>

#include <Xfwf/ScrList.h>

#include "Welt.h"


extern Widget topLevel, NO_Material;
extern TWelt *aktuelleWelt;
extern String *MaterialienListe;
extern TKoerper *selektiertesObjekt;


static Widget NM_Shell, NM_Name, NM_Haft, NM_Gleit, NM_Stoss, NM_Dichte, 
              NM_Dehn, NM_Daempf, NM_FarbeR, NM_FarbeG, NM_FarbeB, 
              NM_Durchsicht, NM_Rauhigkeit, NM_Reflexion, MD_Shell, MD_Name, 
              MD_Haft, MD_Gleit, MD_Stoss, MD_Dichte, MD_Dehn, MD_Daempf,
              MD_FarbeR, MD_FarbeG, MD_FarbeB, MD_Durchsicht, MD_Rauhigkeit, 
              MD_Reflexion;


void initNeuesMaterial (Widget w, XtPointer muell, XtPointer garbage)
{
     char *trans = malloc (20*sizeof (char));
     int i = selektiertesObjekt->Material;
     TMaterialTabelle mt = *aktuelleWelt->Welt.MaterialDaten;

     XtVaSetValues (NM_Haft, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", mt.Gleitreibungsfaktor[i]);
     XtVaSetValues (NM_Gleit, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", mt.Stossfaktor[i]);
     XtVaSetValues (NM_Stoss, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", mt.Dichte[i]);
     XtVaSetValues (NM_Dichte, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", mt.Dehnungsfaktor[i]);
     XtVaSetValues (NM_Dehn, XtNstring, trans, NULL);
     sprintf (trans,"%.3f", mt.Daempfungsfaktor[i]);
     XtVaSetValues (NM_Daempf, XtNstring, trans, NULL);
     sprintf (trans,"%d", DefaultR (&mt, i));
     XtVaSetValues (NM_FarbeR, XtNstring, trans, NULL);
     sprintf (trans,"%d", DefaultG (&mt, i));
     XtVaSetValues (NM_FarbeG, XtNstring, trans, NULL);
     sprintf (trans,"%d", DefaultB (&mt, i));
     XtVaSetValues (NM_FarbeB, XtNstring, trans, NULL);
     sprintf (trans,"%.1f ", DefaultDurchsichtigkeit (&mt, i)*100);
     XtVaSetValues (NM_Durchsicht, XtNstring, trans, NULL);
     sprintf (trans,"%.1f ", DefaultRauhigkeit (&mt, i)*100);
     XtVaSetValues (NM_Rauhigkeit, XtNstring, trans, NULL);
     sprintf (trans,"%.1f ", DefaultReflexion (&mt, i)*100);
     XtVaSetValues (NM_Reflexion, XtNstring, trans, NULL);
     XtPopup (NM_Shell, XtGrabNone);
}


void initMaterialDaten (Widget w, XtPointer muell, XtPointer garbage)
{
     char *trans = malloc (20*sizeof (char));
     int i = selektiertesObjekt->Material;
     TMaterialTabelle mt = *aktuelleWelt->Welt.MaterialDaten;

     XtVaSetValues (MD_Name, XtNlabel, mt.MaterialNamen[i], NULL);
     sprintf (trans,"%.8e", mt.Haftreibungsfaktor[i]);
     XtVaSetValues (MD_Haft, XtNlabel, trans, NULL);
     sprintf (trans,"%.8e", mt.Gleitreibungsfaktor[i]);
     XtVaSetValues (MD_Gleit, XtNlabel, trans, NULL);
     sprintf (trans,"%.8e", mt.Stossfaktor[i]);
     XtVaSetValues (MD_Stoss, XtNlabel, trans, NULL);
     sprintf (trans,"%.8e", mt.Dichte[i]);
     XtVaSetValues (MD_Dichte, XtNlabel, trans, NULL);
     sprintf (trans,"%.8e", mt.Dehnungsfaktor[i]);
     XtVaSetValues (MD_Dehn, XtNlabel, trans, NULL);
     sprintf (trans,"%.8e", mt.Daempfungsfaktor[i]);
     XtVaSetValues (MD_Daempf, XtNlabel, trans, NULL);
     sprintf (trans,"%8d", DefaultR (&mt, i));
     XtVaSetValues (MD_FarbeR, XtNlabel, trans, NULL);
     sprintf (trans,"%8d", DefaultG (&mt, i));
     XtVaSetValues (MD_FarbeG, XtNlabel, trans, NULL);
     sprintf (trans,"%8d", DefaultB (&mt, i));
     XtVaSetValues (MD_FarbeB, XtNlabel, trans, NULL);
     sprintf (trans,"%10.1f ", DefaultDurchsichtigkeit (&mt, i)*100);
     XtVaSetValues (MD_Durchsicht, XtNlabel, trans, NULL);
     sprintf (trans,"%10.1f ", DefaultRauhigkeit (&mt, i)*100);
     XtVaSetValues (MD_Rauhigkeit, XtNlabel, trans, NULL);
     sprintf (trans,"%10.1f ", DefaultReflexion (&mt, i)*100);
     XtVaSetValues (MD_Reflexion, XtNlabel, trans, NULL);
     
     XtPopup (MD_Shell, XtGrabNone);
}


void NeuesMaterialApply (Widget w, XtPointer muell, XtPointer garbage)
{
     char *name = malloc (30*sizeof (char)), 
          *trans = malloc (20*sizeof (char));
     TReal Dichte, Haftfaktor, Gleitfaktor, Stossfaktor, Dehnfaktor, 
           Daempffaktor, Durchsicht, Rauhigkeit, Reflexion;
     unsigned short R, G, B;

     XtPopdown (NM_Shell);
     XtVaGetValues (NM_Name, XtNstring, &name, NULL);
     printf("%s\n", name);
     XtVaGetValues (NM_Haft, XtNstring, &trans, NULL);
     Haftfaktor = (TReal) atof (trans);
     XtVaGetValues (NM_Gleit, XtNstring, &trans, NULL);
     Gleitfaktor = (TReal) atof (trans);
     XtVaGetValues (NM_Stoss, XtNstring, &trans, NULL);
     Stossfaktor = (TReal) atof (trans);
     XtVaGetValues (NM_Dichte, XtNstring, &trans, NULL);
     Dichte = (TReal) atof (trans);
     XtVaGetValues (NM_Dehn, XtNstring, &trans, NULL);
     Dehnfaktor = (TReal) atof (trans);
     XtVaGetValues (NM_Daempf, XtNstring, &trans, NULL);
     Daempffaktor = (TReal) atof (trans);
     XtVaGetValues (NM_FarbeR, XtNstring, &trans, NULL);
     R = atoi (trans);
     XtVaGetValues (NM_FarbeG, XtNstring, &trans, NULL);
     G = atoi (trans);
     XtVaGetValues (NM_FarbeB, XtNstring, &trans, NULL);
     B = atoi (trans);
     XtVaGetValues (NM_Durchsicht, XtNstring, &trans, NULL);
     Durchsicht = (TReal) (atof (trans)/100);
     XtVaGetValues (NM_Rauhigkeit, XtNstring, &trans, NULL);
     Rauhigkeit = (TReal) (atof (trans)/100);
     XtVaGetValues (NM_Reflexion, XtNstring, &trans, NULL);
     Reflexion = (TReal) (atof (trans)/100);
     if (ErgaenzeMatTab2 (aktuelleWelt->Welt.MaterialDaten, name, Dichte, Haftfaktor, 
			  Gleitfaktor, Stossfaktor, Dehnfaktor, Daempffaktor, R, G, B,
			  Durchsicht, Reflexion, Rauhigkeit))
	  fprintf (stderr,"No more entries available\n");
     MaterialienListe = (String *) MaterialNamen (aktuelleWelt->Welt.MaterialDaten);
     XfwfScrolledListSetList (NO_Material, MaterialienListe, 0, TRUE, NULL);
     XfwfScrolledListHighlightItem (NO_Material, selektiertesObjekt->Material);
}


void NeuesMaterialAbort (Widget w, XtPointer muell, XtPointer garbage)
{
     XtPopdown (NM_Shell);
}


void installNeuesMaterial (void)
{
   Widget NM_box, NM_Abort, NM_Apply, NM_NameTxt, NM_HaftTxt, NM_GleitTxt, 
          NM_StossTxt, NM_DichteTxt, NM_DehnTxt, NM_DaempfTxt, NM_NameBox, 
          NM_FarbeTxt, NM_DurchsichtTxt, NM_RauhigkeitTxt, NM_ReflexionTxt,
          NM_Box1, NM_Box2, NM_paned;
   
   NM_Shell = XtVaCreatePopupShell("insert new material", topLevelShellWidgetClass, topLevel, NULL);
   NM_paned = XtVaCreateManagedWidget("NM_paned", panedWidgetClass, NM_Shell, NULL);
   NM_NameBox = XtVaCreateManagedWidget("NM_NameBox", formWidgetClass, NM_paned, NULL);
   NM_NameTxt = XtVaCreateManagedWidget("NM_NameTxt", labelWidgetClass, NM_NameBox, NULL);
   NM_Name = XtVaCreateManagedWidget("NM_Name", asciiTextWidgetClass, NM_NameBox, NULL);

   NM_box = XtVaCreateManagedWidget("NM_box", formWidgetClass, NM_paned, NULL);
   NM_Box1 = XtVaCreateManagedWidget("NM_Box1", formWidgetClass, NM_box, NULL);
   NM_Box2 = XtVaCreateManagedWidget("NM_Box2", formWidgetClass, NM_box, NULL);
   NM_HaftTxt = XtVaCreateManagedWidget("NM_HaftTxt", labelWidgetClass, NM_Box1, NULL);
   NM_Haft = XtVaCreateManagedWidget("NM_Haft", asciiTextWidgetClass, NM_Box1, NULL);
   NM_GleitTxt = XtVaCreateManagedWidget("NM_GleitTxt", labelWidgetClass, NM_Box2, NULL);
   NM_Gleit = XtVaCreateManagedWidget("NM_Gleit", asciiTextWidgetClass, NM_Box2, NULL);
   NM_StossTxt = XtVaCreateManagedWidget("NM_StossTxt", labelWidgetClass, NM_Box1, NULL);
   NM_Stoss = XtVaCreateManagedWidget("NM_Stoss", asciiTextWidgetClass, NM_Box1, NULL);
   NM_DichteTxt = XtVaCreateManagedWidget("NM_DichteTxt", labelWidgetClass, NM_Box2, NULL);
   NM_Dichte = XtVaCreateManagedWidget("NM_Dichte", asciiTextWidgetClass, NM_Box2, NULL);
   NM_DehnTxt = XtVaCreateManagedWidget("NM_DehnTxt", labelWidgetClass, NM_Box1, NULL);
   NM_Dehn = XtVaCreateManagedWidget("NM_Dehn", asciiTextWidgetClass, NM_Box1, NULL);
   NM_DaempfTxt = XtVaCreateManagedWidget("NM_DaempfTxt", labelWidgetClass, NM_Box2, NULL);
   NM_Daempf = XtVaCreateManagedWidget("NM_Daempf", asciiTextWidgetClass, NM_Box2, NULL);
   NM_FarbeTxt = XtVaCreateManagedWidget("NM_FarbeTxt", labelWidgetClass, NM_Box1, NULL);
   NM_FarbeR = XtVaCreateManagedWidget("NM_FarbeR", asciiTextWidgetClass, NM_Box1, NULL);
   NM_FarbeG = XtVaCreateManagedWidget("NM_FarbeG", asciiTextWidgetClass, NM_Box1, NULL);
   NM_FarbeB = XtVaCreateManagedWidget("NM_FarbeB", asciiTextWidgetClass, NM_Box1, NULL);
   NM_DurchsichtTxt = XtVaCreateManagedWidget("NM_DurchsichtTxt", labelWidgetClass, NM_Box2, NULL);
   NM_Durchsicht = XtVaCreateManagedWidget("NM_Durchsicht", asciiTextWidgetClass, NM_Box2, NULL);
   NM_RauhigkeitTxt = XtVaCreateManagedWidget("NM_RauhigkeitTxt", labelWidgetClass, NM_Box2, NULL);
   NM_Rauhigkeit = XtVaCreateManagedWidget("NM_Rauhigkeit", asciiTextWidgetClass, NM_Box2, NULL);
   NM_ReflexionTxt = XtVaCreateManagedWidget("NM_ReflexionTxt", labelWidgetClass, NM_Box1, NULL);
   NM_Reflexion = XtVaCreateManagedWidget("NM_Reflexion", asciiTextWidgetClass, NM_Box1, NULL);

   NM_Apply = XtVaCreateManagedWidget("NM_Apply", commandWidgetClass, NM_box, NULL);
   NM_Abort = XtVaCreateManagedWidget("NM_Abort", commandWidgetClass, NM_box, NULL);

   XtAddCallback (NM_Apply, XtNcallback, NeuesMaterialApply, NULL);
   XtAddCallback (NM_Abort, XtNcallback, NeuesMaterialAbort, NULL);
}


void MaterialDatenApply (Widget w, XtPointer muell, XtPointer garbage)
{
   XtPopdown (MD_Shell);
}


void installMaterialDaten (void)
{
   Widget MD_box, MD_Apply, MD_HaftTxt, MD_GleitTxt, MD_StossTxt, MD_DichteTxt,
          MD_DehnTxt, MD_DaempfTxt, MD_FarbeTxt, MD_DurchsichtTxt, 
          MD_RauhigkeitTxt, MD_ReflexionTxt, MD_Box1, MD_Box2, MD_paned;
   
   MD_Shell = XtVaCreatePopupShell("show material parameter", topLevelShellWidgetClass, topLevel, NULL);
   MD_paned = XtVaCreateManagedWidget("MD_paned", panedWidgetClass, MD_Shell, NULL);
   MD_Name = XtVaCreateManagedWidget("MD_Name", labelWidgetClass, MD_paned, NULL);

   MD_box = XtVaCreateManagedWidget("MD_box", formWidgetClass, MD_paned, NULL);
   MD_Box1 = XtVaCreateManagedWidget("MD_Box1", formWidgetClass, MD_box, NULL);
   MD_Box2 = XtVaCreateManagedWidget("MD_Box2", formWidgetClass, MD_box, NULL);
   MD_HaftTxt = XtVaCreateManagedWidget("MD_HaftTxt", labelWidgetClass, MD_Box1, NULL);
   MD_Haft = XtVaCreateManagedWidget("MD_Haft", labelWidgetClass, MD_Box1, NULL);
   MD_GleitTxt = XtVaCreateManagedWidget("MD_GleitTxt", labelWidgetClass, MD_Box2, NULL);
   MD_Gleit = XtVaCreateManagedWidget("MD_Gleit", labelWidgetClass, MD_Box2, NULL);
   MD_StossTxt = XtVaCreateManagedWidget("MD_StossTxt", labelWidgetClass, MD_Box1, NULL);
   MD_Stoss = XtVaCreateManagedWidget("MD_Stoss", labelWidgetClass, MD_Box1, NULL);
   MD_DichteTxt = XtVaCreateManagedWidget("MD_DichteTxt", labelWidgetClass, MD_Box2, NULL);
   MD_Dichte = XtVaCreateManagedWidget("MD_Dichte", labelWidgetClass, MD_Box2, NULL);
   MD_DehnTxt = XtVaCreateManagedWidget("MD_DehnTxt", labelWidgetClass, MD_Box1, NULL);
   MD_Dehn = XtVaCreateManagedWidget("MD_Dehn", labelWidgetClass, MD_Box1, NULL);
   MD_DaempfTxt = XtVaCreateManagedWidget("MD_DaempfTxt", labelWidgetClass, MD_Box2, NULL);
   MD_Daempf = XtVaCreateManagedWidget("MD_Daempf", labelWidgetClass, MD_Box2, NULL);
   MD_FarbeTxt = XtVaCreateManagedWidget("MD_FarbeTxt", labelWidgetClass, MD_Box1, NULL);
   MD_FarbeR = XtVaCreateManagedWidget("MD_FarbeR", labelWidgetClass, MD_Box1, NULL);
   MD_FarbeG = XtVaCreateManagedWidget("MD_FarbeG", labelWidgetClass, MD_Box1, NULL);
   MD_FarbeB = XtVaCreateManagedWidget("MD_FarbeB", labelWidgetClass, MD_Box1, NULL);
   MD_DurchsichtTxt = XtVaCreateManagedWidget("MD_DurchsichtTxt", labelWidgetClass, MD_Box2, NULL);
   MD_Durchsicht = XtVaCreateManagedWidget("MD_Durchsicht", labelWidgetClass, MD_Box2, NULL);
   MD_RauhigkeitTxt = XtVaCreateManagedWidget("MD_RauhigkeitTxt", labelWidgetClass, MD_Box2, NULL);
   MD_Rauhigkeit = XtVaCreateManagedWidget("MD_Rauhigkeit", labelWidgetClass, MD_Box2, NULL);
   MD_ReflexionTxt = XtVaCreateManagedWidget("MD_ReflexionTxt", labelWidgetClass, MD_Box1, NULL);
   MD_Reflexion = XtVaCreateManagedWidget("MD_Reflexion", labelWidgetClass, MD_Box1, NULL);

   MD_Apply = XtVaCreateManagedWidget("MD_Apply", commandWidgetClass, MD_box, NULL);

   XtAddCallback (MD_Apply, XtNcallback, MaterialDatenApply, NULL);
}
