/********************************************************************************
 *  Projektname:        AERO
 *  Filename:           Welt.h
 *  Filetyp:            Header
 ********************************************************************************
 *  Modulname:          Welt.h
 *  Version:            1.0
 *  letzte Aenderung:   15.12.92
 *  Autor:              Andreas 
 *  Status:             
 *                                                                              
 *  imp. Bezeichner:
 * 
 *  exp. Bezeichner:
 *                                                                      
 *  Beschreibung:
 *  -------------
 *  
 *  Versionsgeschichte:
 *  -------------------
 *   15.12.92: Erweiterung der Struktur TWelt um 'FrameCounter'.
 *   13.01.93: Erweiterung der Struktur TWelt um Pointer 'thisSync' auf Struktur 
 *             TWelt. Die "Anderung wurde notwendig, da sonst das R"uckw"arts-
 *             laufen auf Sync-Punkten nicht funktioniert h"atte.
 *   19.01.93: Erweiterung der Struktur TWelt um ein Flag 'Szenenanfang'.
 ********************************************************************************/

#ifndef WELT_H
#define WELT_H
#include "folgeschrittberechnung.h"
#include <stdio.h>
#include <stdlib.h>
#include "Kamera.h"


typedef struct TWelt {
           TZustand Welt;
           unsigned long FrameCounter;  /* 15.12.92 */
           struct TWelt *prevSync;
           struct TWelt *thisSync;      /* 13.01.93 */
           struct TWelt *nextSync;
	   TBoolean SzenenAnfang;       /* 19.01.93 */
        } TWelt;


typedef enum { 
           anim_PAUSE, 
           anim_PLAY,
	   anim_STEP
        } TModusAnimation;


typedef enum {
           SpeicherOK,
           SpeicherVoll
        } TSpeicher;


typedef struct TKoerperListe {
           TKoerper *Koerper;
           struct TKoerperListe *next;
        } TKoerperListe;


typedef enum {
           Selektion,
           baueVerbindung,
	   loescheVerbindung,
	   aenderVerbindung,
	   anlegeKraft/*,
           entferneKoerper, 
           veraenderKraft,
           entferneKraft */
        } TSelektKontext;   /* f"ur die Selektionsroutine, zur Bestimmung     */
                            /* welche Routine sie f"ur die Weiterverarbeitung */
                            /* des gew"ahlten Objektes aufrufen mu"s          */
                            
typedef enum {
           XRich,
           YRich,
           ZRich
        } TRichtung;

typedef enum {
           Rot,
           Gruen,
           Blau
	} TFarbe;

typedef enum {
           schreibeAkt,
           leseAkt,
	   schreibeMat,
	   leseMat,
	   schreibeSeq,
	   leseSeq
        } TIORoutine;

#define SpeicherFrei( Pointer ) if( Pointer == NULL ){ fprintf( stderr, "No memory left, try later"); exit( -1 ); }
       

#endif
