/********************************************************************************
 *  Projektname:	AERO
 *  Filename:		animat.h
 *  Filetyp:		Header
 ********************************************************************************
 *  Modulname:		Anzeige
 *  Version:		0.0.1
 *  letzte Aenderung:	22.3.93
 *  Autor:  		Hartmut 
 *  Status:		Enthaelt bisher einige Definitionen fuer die Anzeige
 *                      des Animationsfensters
 *				 
 *  imp. Bezeichner:	div. Typennamen
 * 
 *  exp. Bezeichner:    keine, nur lokales Headerfile fuer mich
 *
 *  Beschreibung:	
 *  -------------	
 *  Lokaler (=privater) Header fuer die Routinen des Animationsfensters. Hier
 *  koennen verschiedene Parameter veraendert werden und hier sind diverse Typen
 *  fuer diese Routinen definiert.
 *									       
 *  Versionsgeschichte:							       
 *  -------------------			
 *  0.0.1:  Auslagerung aus anzeige.h
 ********************************************************************************/

#ifndef ANIMAT_H
#define ANIMAT_H

#include "visualisierung.h"

/*----------------------------------------------------------------------------
  Definitionen fuer Animation
  ----------------------------------------------------------------------------*/

#if 0
#define ADEBUG
#endif

/* Grundzoom, der beim Animationsfenster aufmultipliziert wird.
 * Von diesem Wert haengt es ab, wie gross ein Koerper von z.B. 1m Kantenlaenge
 * im Fenster zu sehen ist
 */

#define ANIM_ZOOM 2000


/* Rot- und Gruenton fuer die Stereobilddarstellung im Animationsfenster
 * festlegen
 */
#define GRUEN3D_R 0
#define GRUEN3D_G 65535
#define GRUEN3D_B 65535
#define ROT3D_R   65535
#define ROT3D_G   0
#define ROT3D_B   0



/* Abstand der Bildflaeche (2D) von der punktfoermigen virtuellen Kamera */

#define ANIM_DEFAULTABSTAND 0.5





/* Groesse des Kreuzes, mit dem Naegel bzw. feste Punkte im Animationsfenster
 * gezeichnet werden.
 */

#define ANIM_NAGELGROESSE 0.02



/* Groesse einer Pfeilspitze (in Pixeln) von Koordinatenachsen in der Darstellung.
 * Stellt man sich eine Pfeilspitze nach oben mit der Spitze an (x,y) vor, dann
 * hat das Dreieck der Pfeilspitze die Koordinaten:
 *       (x-DARST_PFEILBREITE, y+DARST_PFEILHOEHE)
 *	 (x,y)
 *	 (x+DARST_PFEILBREITE, y+DARST_PFEILHOEHE)   
 * Die Groesse ist auch von der Entfernung zum Betrachter abhaengig.
 */

#define ANIM_PFEILBREITE 4
#define ANIM_PFEILHOEHE 12


#endif /* #ifndef ANIMAT_H */ 
