/********************************************************************************
 *  Projektname		: AERO
 *  Filename		: zustand.h
 *  Filetyp		: Header
 ********************************************************************************
 *  Modulname		: zustand.o
 *  Version           	: 1
 *  letzte Aenderung	: 02.12.92
 *  Autor		: Horst Stolz (HUS)
 *  
 *  Beschreibung:
 *  
 *  Exportierte Funktionen/Makros:
 * 
 *  Noch zu machen:
 *
 *  Versionsgeschichte:
 *    03.03.93     Seed-Wert eingefuegt um wiederholbare Zufallszahlen zu bekommen
 *  
 ********************************************************************************/
#ifndef ZUSTAND_H
#define ZUSTAND_H

#ifndef GRUNDTYPEN_H
#include "grundtypen.h"
#endif

#ifndef KOERPER_H
#include "koerper.h"
#endif

#ifndef VERBINDUNGEN_H
#include "verbindungen.h"
#endif

#ifndef MATERIALIEN_H
#include "materialien.h"
#endif

/****************************************************************************
 * Speichert alle Informationen der Welt die im Zeitpunkt TZustand.Zeit
 * gueltig sind.
 */

typedef struct TZustand {
  TReal		     Zeit;
  TKoerper          *Koerper;
  TVerbindung       *Verbindungen;
  TMaterialTabelle  *MaterialDaten;
  TBoolean           GravitationAn;
  TVektor            GravitationsVektor;
  int                Seed;                   /* Seed-Wert fuer Zufallszahlen */
  TReal              HimmelsRadius;          /* Himmelskugel im Ursprung */
} TZustand;


#endif
