'\"
'\" Copyright (c) 1993, 1994 Eric Schenk.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE ERIC SCHENK BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF ERIC SCHENK
'\" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" ERIC SCHENK SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND ERIC SCHENK HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\"
'\" Some of these macros are from TK-3.6, copyright (c) 1991
'\" The Regents of the University of California.
'\" The applicable copyright notices appear below.
'\"
'\"
'\" Copyright (c) 1991 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'/"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS tkwm tkcmds 0.1
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tkwm  \- Tk based window managing shell
.SH SYNOPSIS
\fBtkwm\fR ?\fIoptions\fR? ?\fIarg arg ...\fR?
.SH OPTIONS
.IP "\fB\-display \fIdisplay\fR" 15
Display (and screen) to manage.
.IP "\fB\-file \fIfileName\fR" 15
Read commands from \fIfileName\fR rather than standard input.  The
last element in \fIfileName\fR will be used as the title for the
application and name of its interpreter for \fBsend\fR
commands (unless overridden by the \fB\-name\fR option\fR).
.IP "\fB\-name \fIname\fR" 15
Use \fIname\fR as the name of the interpreter for \fBsend\fR commands.
.IP "\fB\-sync\fR" 15
Execute all X server commands synchronously, so that errors
are reported immediately.  This will result in much slower
execution, but it is useful for debugging.
.IP "\fB\-help\fR" 15
Print a summary of the command-line options and exit.
.Be

.SH DESCRIPTION
.PP
\fITkwm\fR is a shell based on the Tcl command language,
the Tk toolkit with some window management extensions, and a main
program that reads commands from standard input or from a file.
It is specifically intended for the implementation of X window managers
and is unlikely to be suitable for other tasks.
It attempts to gain control of the designated display and screen
for management and then processes Tcl commands.
If \fITkwm\fR is invoked with no \fB\-f\fR option then it
reads Tcl commands interactively from standard input.
It will continue processing commands until all windows have been
deleted or until end-of-file is reached on standard input.
If there exists a file \fB.tkwmrc\fR in the home directory of
the user, \fItkwm\fR evaluates the file as a Tcl script
just before reading the first command from standard input.
.PP
If the \fB\-file\fR option is provided to Tk, then \fITkwm\fR reads Tcl
commands from the file named in the \fB\-file\fR option.  These
commands will normally create a window manager.
When the end of the command file is reached, \fITkwm\fR will
continue to respond to X events until all windows have been deleted.
There is no automatic evaluation of \fB.tkwmrc\fR in this
case, but the script file can always \fBsource\fR it if desired.

.SH "VARIABLES"
.PP
\fITkwm\fR sets the following Tcl variables:
.TP 15
\fBargc\fR
Contains a count of the number of \fIarg\fR arguments (0 if none),
not including the options described above.
.TP 15
\fBargv\fR
Contains a Tcl list whose elements are the \fIarg\fR arguments (not
including the options described above), in order, or an empty string
if there are no \fIarg\fR arguments.
.TP 15
\fBargv0\fR
Contains \fIfileName\fR if it was specified.
Otherwise, contains the name by which \fItkwm\fR was invoked.
.TP 15
\fBtcl_interactive\fR
Contains 1 if \fItkwm\fR is reading commands interactively (no
\fB\-file\fR option was specified and standard input is a terminal-like
device), 0 otherwise.

.SH "SCRIPT FILES"
.PP
If you create a Tcl script in a file whose first line is
.DS
\fB#!/usr/local/bin/tkwm -f\fR
.DE

then you can invoke the script file directly from your shell if
you mark it as executable.
This assumes that \fItkwm\fR has been installed in the default
location in /usr/local/bin;  if it's installed somewhere else
then you'll have to modify the above line to match.

.SH PROMPTS
.PP
When \fItkwm\fR is invoked interactively it normally prompts for each
command with ``\fB% \fR''.  You can change the prompt by setting the
variables \fBtcl_prompt1\fR and \fBtcl_prompt2\fR.  If variable
\fBtcl_prompt1\fR exists then it must consist of a Tcl script
to output a prompt;  instead of outputting a prompt \fItkwm\fR
will evaluate the script in \fBtcl_prompt1\fR.
The variable \fBtcl_prompt2\fR is used in a similar way when
a newline is typed but the current command isn't yet complete;
if \fBtcl_prompt2\fR isn't set then no prompt is output for
incomplete commands.

.SH "WINDOW MANAGEMENT EXTENSIONS"
.PP
The \fItkwm\fR window manager core provides one new command, and one new widget
for Tk. The widget, called a plug, is a wrapper for clients (windows that
\fItkwm\fR is managing). The main interface to \fItkwm\fR is through
the \fBtkwm\fR command, which has the general syntax:
.DS
\fBtkwm \fIsubcommand \fR?\fIoptions\fR?
.DE

where subcommand is one of
.DS
\fBbind, colormap, compressMotion, focus, grabserver, grabevent,
grabpointer, iconsize, info, outline, plug, pointer,
restack, reparent, ungrabserver, ungrabevent,
ungrabpointer\fR or \fBunmanaged\fR.
.DE

\fBTkwm\fR does not provide any useful window management by itself
but rather provides facilities for writing window managers in Tcl/Tk.

.SH "SUBCOMMANDS"
.PP
The sections below describe each of the subcommands provided by the
\fBtkwm\fR extension.

.SH "BIND"
\fBtkwm bind\fI eventSpec command\fR
.br
\fBtkwm bind\fI eventSpec\fR
.br
\fBtkwm bind\fR
.br
.PP
where \fIeventSpec\fR is one of:
.IP "\fB<Configure>\fR" 14
A client is requesting a geometry change.
.IP "\fB<FocusIn>\fR" 14
A client is requesting a change of focus.
.IP "\fB<Iconify>\fR" 14
A managed window is requesting iconification.
.IP "\fB<MapRequest>\fR" 14
A new window is requesting to be managed, or
an old window is requesting to be deiconified.
.IP "\fB<Property>\fR" 14
A client's properties have changed.
.br
.PP
The first form of  \fBbind\fR sets a new binding such
that \fBtkwm\fR will call the provided Tcl code to handle the given event.
The second form returns the current binding for an event.
The third form lists all the events that are currently bound.
(NOTE: The last two forms are not yet implemented.)

.PP
Commands bound with \fBtkwm bind\fR can make use of the following
substitutions (ala Tk's bind command):
.IP "\fB%W\fR" 5
The Tk window, if any, associated with the event.
This is set to "??" if no Tk window is currently associated with the event.
.IP "\fB%P\fR" 5
The property that has changed in a \fB<Property>\fR event. This string
will be one of:
\fBWM_CLASS\fR, \fBWM_TRANSIENT_FOR\fR, \fBWM_HINTS\fR, \fBWM_ICON_NAME\fR,
\fBWM_NAME\fR, \fBWM_ICON_SIZE\fR, \fBWM_NORMAL_HINTS\fR, \fBWM_SIZE_HINTS\fR,
\fBWM_ZOOM_HINTS\fR, \fBWM_CLIENT_MACHINE\fR, \fBWM_COMMAND\fR,
\fBWM_PROTOCOLS\fR, \fBWM_COLORMAP_WINDOWS\fR or \fBWM_STATE\fR.
The X documentation describes the meaning of these property types.
(NOTE: Some of these property events are not suppose to be
generated by clients. See the ICCCM and other X documentation. Also,
some of these events will be generated by Tkwm actions.)
.IP "\fB%e\fR" 5
The X window id associated with the event.
.IP "\fB%h\fR" 5
The requested height in a <Configure> event, "??" if no change is requested.
.IP "\fB%w\fR" 5
The requested width in a <Configure> event, "??" if no change is requested.
.IP "\fB%x\fR" 5
The requested x position in a <Configure> event, "??" if no change is requested.
.IP "\fB%y\fR" 5
The requested y position in a <Configure> event, "??" if no change is requested.
.IP "\fB%d\fR" 5
The detail field from in a <Configure> event, "??" if no change is requested.
.IP "\fB%S\fR" 5
The sibling window id in a <Configure> event, "??" if no change is requested.

.SH "COLORMAP"
\fBtkwm colormap\fI windowSpec\fR
.br
.PP
Choose the colormap for the named window.
The window can be any Tk window.
Plug windows are set to have the same colormap as their clients
and to track their clients colormaps.

.SH "COMPRESSMOTION"
\fBtkwm compressMotion\fR
.br
.PP
This command checks if there are any motion events in the event
queue after the current event. If there are any such motion events
then they are compressed into a single event, the event is then
dispatched, after the event has been processed \fBcompressMotion\fR
returns a 1. Otherwise \fBcompressMotion\fR returns a 0.

.SH "OUTLINE"
\fBtkwm outline\fI x y width height\fR
.br
.PP
This command draws a twm style xored on window outline on the screen
with its upper left hand corner at (\fIx,y\fR) and of the specified
\fIwidth\fR and \fIheight\fR. If there is currently an outline on
the screen it is erased first. If all four parameters are 0, then
no new outline is drawn.

.SH "GRABSERVER AND UNGRABSERVER"
\fBtkwm grabserver\fR
.br
\fBtkwm ungrabserver\fR
.br
.PP
These commands execute "XGrabServer" and "XUngrabServer" calls.
Grabbing the server prevents all other clients from communicating
with the server until the server is ungrabbed.
These should be used very sparingly, and carefully since use
of these commands can lock up your server.

.SH "GRABEVENT AND UNGRABEVENT"
\fBtkwm grabevent\fI windowSpec eventSpec\fR
.br
\fBtkwm ungrabevent\fI windowSpec eventSpec\fR
.br
.PP
Grab a keysym or a button press from a client window, or delete
a grab for the window. These grabs are needed because \fBtkwm\fR
cannot intercept all keyboard events over a client window
without disabling the client (since keyboard events only go
to one window in X). This if you want key or button sequences
over a client to have an effect in \fBtkwm\fR they must be individually
grabbed from the client.
Note that "windowSpec" can refer to any Tk window. If it refers
to a plug window, or a plug's frame window, then only events
specific to that plug will be grabbed. If "windowSpec" refers
to any other Tk window, then all children (in the X heriarchy)
will have their events grabbed. A particular use of this
is to grab events on the "." window, thus grabbing them from
all clients (current and future).

.SH "GRABPOINTER AND UNGRABPOINTER"
\fBtkwm grabpointer\fR ?\fIoptions\fR
.br
\fBtkwm ungrabpointer\fR
.br
.PP
These commands globally grab/ungrab all pointer related events over
all windows. This will be most especially usefull when doing
the initial positioning of a window during a map request.
The presence of these commands servers two purposes. First,
it allows one fewer patchs to the Tk core. Second, it allows
for keyboard events to continue to go to a client during
initial window positioning.

'\"-cursor Cursor

\fBWARNING:\fR These commands may interact badly with Tk's standard grab
mechanism. In particular a "grab release" will act as a
"tkwm ungrabpointer" if it is finished after "tkwm grabpointer" is run.
To prevent this run an "update" before using "tkwm grabpointer" to be
sure that all pending Tk grab events have been dealt with.

.SH "FOCUS"
\fBtkwm focus\fI windowSpec\fR
.br
\fBtkwm focus\fR
.br
.PP
Set the keyboard focus to the client of the named toplevel window.
If \fIwindowSpec\fR is \fBNone\fR then the keyboard focus will follow
the pointer.
If no \fIwindowSpec\fR is provided then the current focus will be returned.

.SH "UNMANAGED"
\fBtkwm unmanaged\fR
.br
.PP
Returns a list of windows that are not being managed by \fBtkwm\fR.
This is used to find the windows to map when starting up,
and can also be used to reacquire windows in a "restart".
[See the "tkwm_restart" procedure in the sample window manager
for an example of this.]

.SH "ICONSIZE"
\fBtkwm iconsize\fI min_width min_height max_width max_height width_inc height_inc ...\fR
.br
\fBtkwm iconsize\fR
.br
.PP
Set or return the WM_ICON_SIZE property. The icon size property is a
list of an arbitrary number of size specifications, each consisting
of six elements.

.SH "POINTER"
\fBtkwm pointer\fR
.br
.PP
Returns a space separated pair "x y" where x and y are the current
coordinates of the pointer over the root window.

.SH "RESTACK"
\fBtkwm restack\fI windowSpec stackingmode sibling\fR
.br
.PP
Modifies the stacking of the specified top level window.
[Perhaps I should not restrict this to top level windows?]

.SH "REPARENT"
\fBtkwm reparent\fI childWindowSpec parentWindowSpec\fR
.br
.PP
Makes \fIchildWindowSpec\fR a child of \fIparentWindowSpec\fR
by an XReparentWindow operation. This also places a __WM_ROOT
property on childWindowSpec that points to \fIparentWindowSpec\fR.

.SH "INFO"
\fBtkwm info\fI query windowSpec\fR
.br
.PP
The \fBinfo\fR subcommand returns information about the various
window manager properties and attributes of the client window
associated with \fIwindowSpec\fR. See the documentation below
on the \fBtkwm plug\fR command for a description of which
client is associated with a particular \fIwindowSpec\fR.
Unless otherwise noted, if a property or attribute is not defined
for the client a query will return the value "??".
The available values of \fIqueury\fR are as follows.

.IP "\fBwindow_id\fR" 15
Return the X identifier of the client window.

.IP "\fBx\fR" 15
Return the current \fIx\fR coordinate of the client window within
the root window.
.IP "\fBy\fR" 15
Return the current \fIy\fR coordinate of the client window within
the root window.
.IP "\fBwidth\fR" 15
Return the current width of the client in pixels. This does not
include the width of any extra frame windows that \fITkwm\fR may have
embellished the client with.
.IP "\fBheight\fR" 15
Return the current height of the client in pixels. This does not
include the height of any extra frame windows that \fITkwm\fR may have
embellished the client with.
.IP "\fBborder_width\fR" 15
Return the \fIborder_width\fR value requested by the client.
Note that the actual border width of the client window is always zero
and it is up to the window manager to provide a separate border
on a frame window. Window manager implementors can use this value
to respect client requests.
.IP "\fBdepth\fR" 15
Return the \fIdepth\fR of the client as reported by XGetWindowAttributes.

.IP "\fBname\fR" 15
Return the WM_NAME property of the client. If the property
has not been set the query returns the value "NoName".

.IP "\fBicon_name\fR" 15
Return the WM_ICON_NAME property of the client. If the property
has not been set the query returns the value "NoName".

.IP "\fBmin_width\fR" 15
Return the \fImin_width\fR field of the WM_SIZE_HINT structure.
.IP "\fBmin_height\fR" 15
Return the \fImin_height\fR field of the WM_SIZE_HINT structure.
.IP "\fBmax_width\fR" 15
Return the \fImax_width\fR field of the WM_SIZE_HINT structure.
If this field has not been set by the client the query returns
the string "Infinity".
.IP "\fBmax_height\fR" 15
Return the \fImax_height\fR field of the WM_SIZE_HINT structure.
If this field has not been set by the client the query returns
the string "Infinity".
.IP "\fBwidth_inc\fR" 15
Return the \fIwidth_inc\fR field of the WM_SIZE_HINT structure.
.IP "\fBheight_inc\fR" 15
Return the \fIheight_inc\fR field of the WM_SIZE_HINT structure.
.IP "\fBbase_width\fR" 15
Return the \fIbase_width\fR field of the WM_SIZE_HINT structure.
.IP "\fBbase_height\fR" 15
Return the \fIbase_height\fR field of the WM_SIZE_HINT structure.
.IP "\fBmin_aspect\fR" 15
Return the \fImin_aspect\fR field of the WM_SIZE_HINT structure
as the floating point value of the fraction give in the structure.
If the field has not been set by the client the query returns
the string "None.
.IP "\fBmax_aspect\fR" 15
Return the \fImax_aspect\fR field of the WM_SIZE_HINT structure
as the floating point value of the fraction give in the structure.
If the field has not been set by the client the query returns
the string "None.
.IP "\fBwin_gravity\fR" 15
Return the \fIwin_gravity\fR field of the WM_SIZE_HINT structure.
.IP "\fBUSPosition\fR" 15
Return 0 or 1 as the \fIUSPosition\fR flag is set in the WM_SIZE_HINT
structure.

.IP "\fBinput\fR" 15
Return the \fIinput\fR field of the WM_HINT structure.
.IP "\fBinitial_state\fR" 15
Return the \fIinitial_state\fR field of the WM_HINT structure.
The possible return values are: \fBwithdrawn\fR, \fBnormal\fR and
\fBiconic\fR.
.IP "\fBicon_pixmap\fR" 15
Return the \fIicon_pixmap\fR field of the WM_HINT structure.
This is a numeric X identifier for a pixmap. This can be passed
directly to the \fB-bitmap\fR option of Tk widgets as detailed below
in the section on changes to the stanard Tk widgets.
.IP "\fBicon_window\fR" 15
Return the \fIicon_window\fR field of the WM_HINT structure.
.IP "\fBicon_x\fR" 15
Return the \fIicon_x\fR field of the WM_HINT structure.
.IP "\fBicon_y\fR" 15
Return the \fIicon_y\fR field of the WM_HINT structure.
.IP "\fBicon_mask\fR" 15
Return the \fIicon_mask\fR field of the WM_HINT structure.
This is again a numeric X identifier for a pixmap.
.IP "\fBwindow_group\fR" 15
Return the \fIwindow_group\fR field of the WM_HINT structure.
If the field has not been set by the client the query returns
the string "None".

.IP "\fBres_name\fR" 15
Return the \fIres_name\fR field of the WM_CLASS_HINT structure.
If the field has not been set by the client the query returns
the string "NoName".
.IP "\fBres_class\fR" 15
Return the \fIres_class\fR field of the WM_CLASS_HINT structure.
If the field has not been set by the client the query returns
the string "NoName".

.IP "\fBtransient_for\fR" 15
Return the WM_TRANSIENT_FOR property of the client.

.IP "\fBprotocols\fR" 15
Returns a list of the protocols the client lists in
its WM_PROTOCOLS property. Possible entries are \fBTAKE_FOCUS\fR,
\fBSAVE_YOURSELF\fR and \fBDELETE_WINDOW\fR. See the ICCCM for
further details of the means of these protocols.

.IP "\fBcolormap_windows\fR" 15
Return the WM_COLORMAP_WINDOWS property of the client.
If the client window itself is not part of the WM_COLORMAP_WINDOWS
property then this list will have the client window added to
the front of the list.

.IP "\fBcommand\fR" 15
Return the WM_COMMAND property of the client.

.IP "\fBclient_machine\fR" 15
Return the WM_CLIENT_MACHINE property of the client.

.SH "PLUG"
\fBtkwm plug\fI windowSpec winid \fR?\fIoptions\fR?
.br
.PP
Create a client frame holding a window manager client.
Destroying the plug will return a reparented client window
to the root window. The frame size exactly matches the size
of the client. Resizing the plug (via TK's packing algorithms)
will cause the client to resize. The allowable options
are detailed below in the section on the \fBconfigure\fR method.
Each client has two associated windows (which can be used to
designate the client in the \fBtkwm info\fR command).
The first of these is the plug widget that contains the client.
The second is called the \fBframe\fR of the client. This
can be any Tk widget but will normally be a frame or toplevel
widget that is an ancestor of the plug widget. The frame widget
may also be the plug widget itself. The frame widget can
be set when the plug is created or via the \fBconfigure\fR method.

.SH "PLUG WIDGET COMMANDS"

The plug widget has several associated methods: configure, geometry, info,
sendconfig, position, and delete. Given a window specifier
\fIplugSpec\fR that names a plug window the methods have the following
syntax.

\fIplugSpec\fB configure\fR ?\fIoptions\fR?
.PP
Configure the plug. The allowable options are:
.IP "-frame tkwin" 15
Designate an outer frame for the plug. This frame's
root x and y location, together with the clients gravity
determine where a window gets remapped. Defaults to
the plug itself.
.IP "-setgrid boolean" 15
Turn gridding on based on the clients geometry.
This will make the toplevel window containing
the plug have a geometry exactly reflecting the pixel
size of the client window. This defaults to true.
.IP "-wm_state state" 15
Set the WM_STATE property on the client window.

.PP
\fIplugSpec\fB info\fI query\fR
.PP
An alternative interface to "tkwm info".
Votes for the prefered interface? Keep them both?

\fIplugSpec\fB hasShape\fR
.PP
Check if the plug has a shaped window as its client.
Returns 1 or 0.

\fIplugSpec\fB shapify\fR
.PP
Cookie-cut the plug's shape into its frame.
The background of the frame will be filled with whatever
is behind it.

\fIplugSpec\fB unshapify\fR
.PP
Turn off the shaped window management for the plug.

\fIplugSpec\fB sendconfig\fR
.PP
Send the client the current configuration.
If the client is resized in response to the a client
ConfigureRequest event the ICCCM requires the window
manager to send the current configuration if no actual
resizing occurs. To avoid sending unneeded configure
events window manager writers may wish to check if a
resize request changes the size of the window.

\fIplugSpec\fB geometry\fR
.PP
Reports the current client geometry.
Initially this is the clients requested geometry,
after the plug is actually placed within a frame on the window,
this represents the plug's real geometry, as it would be
interpreted by the client. Note that the size is given in pixels.

'\" \fIplugSpec\fB geometry\fI pos\fR
'\" .PP
'\" * NOT CURRENTLY IMPLEMENTED *
'\" Set the clients requested position and size information.
'\" This should not normally be needed as this information is
'\" obtained from the frame associated with the plug. Use of this
'\" command will almost certainly result in a non-ICCCM compliant
'\" window manager, it is here for people who want to experiment
'\" with window managers that place multiple clients into a single
'\" window and don't wish to have them all appear in one place when
'\" the window manager exits.

\fIplugSpec\fB delete\fR
.PP
Send a WM_DELETE to the client window. Client windows
should cooperate and terminate themselves on receipt.
If the window does not do the WM_DELETE protocol then
\fITkwm\fR will destroy the client window using XDestroyWindow.

\fIplugSpec\fB save_yourself\fR
.PP
Send a WM_SAVE_YOURSELF to the client window.

\fIplugSpec\fB take_focus\fR
.PP
Send a WM_TAKE_FOCUS to the client window.

.SH "CHANGES TO STANDARD TK COMMANDS"

.PP
Some minor changes to the normal Tk semantics have been introduced
with \fITkwm\fR. This section details these changes. Ideally I would like
to either remove the need for these changes or see some of them
become a part of standard Tk.

\fBBitmap options\fR
.PP
The "-bitmap" option has been modified to allow the use of
Numeric identifiers, e.g. \fB-bitmap 83834\fR where \fB83834\fR must refer to
an X bitmap ID, such as returned by
.DS
\fBtkwm info \fIwinPath \fRicon_bitmap\fR.
.DE

\fBPacker\fR
.PP
The packer code has been changed to perform mapping of subwindows even
if the top level window is not yet mapped. This was needed to allow window
managers to determine the dimensions of a window before placement.

\fBGrabs\fR
.PP
The grab code has been changed so that when a global grab is performed
Tk will receive motion events no matter where the mouse is rather
than only when the mouse is over windows owned by Tk.
This change is no longer used by the sample window manager,
but remains in the \fITkwm\fR core against future need.

\fBFrames\fR
.PP
A minor bug fix in the redraw code for \fBframe\fR widgets has been
included. This corrects a problem where the frame is not correctly
redrawn if the color is changed and the frame is then exposed without
an intervening update operation.

.SH BUGS
Destroying the root window (".") can cause a core dump.
Window managers should use the "exit" command to avoid this bug.

.SH SEE ALSO
stkwm(1), stkwm_prefs(1).

.SH "AUTHOR"
Eric Schenk, Department of Computer Science, University of Toronto.

