/***********************************************************************/
/*                                                                     */
/* Project      : GRAV                                                 */
/* Current Rel. : 3.1                                                  */
/* Creator      : Michael Knigge                                       */
/* Creation Date: 01/30/95                                             */
/* Description  : view file-info                                       */
/*                                                                     */
/* Functions    : grav_view_fileinfo()                                 */
/*                                                                     */
/***********************************************************************/

#include <stdio.h>
#include <string.h>
#include <ncurses.h>
#include "standard.h"
#include "gbm.h"
#include "defines.h"
#include "error.h"
#include "info.h"
#include "png.h"
#include "readgbm.h"
#include "readjpg.h"
#include "readpng.h"

int grav_view_fileinfo(int *error_id, int use_color, int index, DIRTAB dirtab[])
{
   int    rc;
   int    colors;
   char   row[40];
   GBM    gbm;
   GBMFT  gbmft;
   GBMRGB gbmrgb[256];

   switch(dirtab[index].gfx_type)
   {
   case 100: gbm.bpp = 24;
             grav_read_jpg_file(error_id, READ_HEADER_ONLY, index, dirtab, &gbm, &gbmft, gbmrgb);
             break;

   case 110: gbm.bpp = 24;
             grav_read_pcd_file(error_id, READ_HEADER_ONLY, index, dirtab, &gbm, &gbmft, gbmrgb);
             break;

   case 120: grav_read_png_file(error_id, READ_HEADER_ONLY, index, dirtab, &gbm, &gbmft, gbmrgb);
             break;
            
   default:  grav_read_gbm_file(error_id, READ_HEADER_ONLY, index, dirtab, &gbm, &gbmft, gbmrgb);
             break;
   }

   if (*error_id != GRAV_NO_ERROR)
      return(FALSE);

   if (use_color)
   {
      grav_draw_box(16,47,8,5,BLACK_ON_CYAN);
      attron(COLOR_PAIR(BLACK_ON_CYAN));
   }
   else
   {
      grav_draw_box(16,47,8,5,COLOR_REVERSE);
      attron(A_REVERSE);
   }

  /*
   * if we have a TIFF, the description in gbmft.long_name is too long
   * to fit in window, so we have to short it to 24 chars
   */
   
  if (dirtab[index].gfx_type == 3)
     strncpy(row, gbmft.long_name, 24);
  else
     strcpy(row,gbmft.long_name);
     
   mvaddstr(9,7,row);
 
   sprintf(row,"Filename      : %s", dirtab[index].filename);
   mvaddstr(11,7,row);

   sprintf(row,"Resolution    : %d x %d",gbm.w,gbm.h);
   mvaddstr(13,7,row);

   sprintf(row,"Bit per pixel : %d",gbm.bpp);
   mvaddstr(15,7,row);              

   if (gbm.bpp==24)
   {
      sprintf(row,"Colors        : Truecolor");
   }
   else
   {
      colors = ( (1 << gbm.bpp) & 0x1ff );
      sprintf(row,"Colors        : %ld", colors);
   }
   
   mvaddstr(17, 7, row);   
   mvaddstr(21, 20, "Press any key");
  
   refresh();
   getch();

   *error_id = GRAV_NO_ERROR;                                         
   return(TRUE);
}
