#include <stdio.h>
#include <stdlib.h>

#include "decode.h"

byte gray1[768];
byte gray2[768];
byte red[384];
byte blue[384];
int gray[768];
int r[768];
int b[768];
int g[768];

/*--------------------------------------------------------*/

static int gray_LUT[256] = {
    0,   1,   2,   4,   5,   7,   8,   9,  11,  12,  14,  15,  16,  18,  19,  21,
   22,  24,  25,  26,  28,  29,  31,  32,  33,  35,  36,  38,  39,  41,  42,  43,
   45,  46,  48,  49,  50,  52,  53,  55,  56,  57,  59,  60,  62,  63,  65,  66,
   67,  69,  70,  72,  73,  74,  76,  77,  79,  80,  82,  83,  84,  86,  87,  89,
   90,  91,  93,  94,  96,  97,  99, 100, 101, 103, 104, 106, 107, 108, 110, 111,
  113, 114, 115, 117, 118, 120, 121, 123, 124, 125, 127, 128, 130, 131, 132, 134,
  135, 137, 138, 140, 141, 142, 144, 145, 147, 148, 149, 151, 152, 154, 155, 156,
  158, 159, 161, 162, 164, 165, 166, 168, 169, 171, 172, 173, 175, 176, 178, 179,
  181, 182, 183, 185, 186, 188, 189, 190, 192, 193, 195, 196, 198, 199, 200, 202,
  203, 205, 206, 207, 209, 210, 212, 213, 214, 216, 217, 219, 220, 222, 223, 224,
  226, 227, 229, 230, 231, 233, 234, 236, 237, 239, 240, 241, 243, 244, 246, 247,
  248, 250, 251, 253, 254, 256, 257, 258, 260, 261, 263, 264, 265, 267, 268, 270,
  271, 272, 274, 275, 277, 278, 280, 281, 282, 284, 285, 287, 288, 289, 291, 292,
  294, 295, 297, 298, 299, 301, 302, 304, 305, 306, 308, 309, 311, 312, 313, 315,
  316, 318, 319, 321, 322, 323, 325, 326, 328, 329, 330, 332, 333, 335, 336, 338,
  339, 340, 342, 343, 345, 346, 347, 349, 350, 352, 353, 355, 356, 357, 359, 360  
};

static int blue_LUT[256] = {
  -318, -316, -314, -312, -310, -308, -306, -304, -302, -300, -298, -296, -294, -292, -290, -288,
  -286, -284, -282, -280, -278, -276, -274, -272, -270, -268, -266, -264, -262, -260, -258, -256,
  -254, -252, -250, -248, -246, -244, -242, -240, -238, -236, -234, -232, -230, -228, -226, -224,
  -222, -220, -218, -216, -214, -212, -210, -208, -206, -204, -202, -200, -198, -196, -194, -192,
  -190, -188, -186, -184, -182, -180, -178, -176, -174, -172, -170, -168, -166, -164, -162, -160,
  -158, -156, -154, -152, -150, -148, -146, -144, -142, -140, -138, -136, -134, -132, -130, -128,
  -126, -124, -122, -120, -118, -116, -114, -112, -110, -108, -106, -104, -102, -100,  -98,  -96,
   -94,  -92,  -90,  -88,  -86,  -84,  -82,  -80,  -78,  -76,  -74,  -72,  -70,  -68,  -66,  -64,
   -62,  -60,  -58,  -56,  -54,  -52,  -50,  -48,  -46,  -44,  -42,  -40,  -38,  -36,  -34,  -32,
   -30,  -28,  -26,  -24,  -22,  -20,  -18,  -16,  -14,  -12,  -10,   -8,   -6,   -4,   -2,    0,
     2,    4,    6,    8,   10,   12,   14,   16,   18,   20,   22,   24,   26,   28,   30,   32,
    34,   36,   38,   40,   42,   44,   46,   48,   50,   52,   54,   56,   58,   60,   62,   64,
    66,   68,   70,   72,   74,   76,   78,   80,   82,   84,   86,   88,   90,   92,   94,   96,
    98,  100,  102,  104,  106,  108,  110,  112,  114,  116,  118,  120,  122,  124,  126,  128,
   130,  132,  134,  136,  138,  140,  142,  144,  146,  148,  150,  152,  154,  156,  158,  160,
   162,  164,  166,  168,  170,  172,  174,  176,  178,  180,  182,  184,  186,  188,  190,  192,
};

static int red_LUT[256] = {
  -274, -272, -270, -268, -266, -264, -262, -260, -258, -256, -254, -252, -250, -248, -246, -244,
  -242, -240, -238, -236, -234, -232, -230, -228, -226, -224, -222, -220, -218, -216, -214, -212,
  -210, -208, -206, -204, -202, -200, -198, -196, -194, -192, -190, -188, -186, -184, -182, -180,
  -178, -176, -174, -172, -170, -168, -166, -164, -162, -160, -158, -156, -154, -152, -150, -148,
  -146, -144, -142, -140, -138, -136, -134, -132, -130, -128, -126, -124, -122, -120, -118, -116,
  -114, -112, -110, -108, -106, -104, -102, -100,  -98,  -96,  -94,  -92,  -90,  -88,  -86,  -84,
   -82,  -80,  -78,  -76,  -74,  -72,  -70,  -68,  -66,  -64,  -62,  -60,  -58,  -56,  -54,  -52,
   -50,  -48,  -46,  -44,  -42,  -40,  -38,  -36,  -34,  -32,  -30,  -28,  -26,  -24,  -22,  -20,
   -18,  -16,  -14,  -12,  -10,   -8,   -6,   -4,   -2,    0,    2,    4,    6,    8,   10,   12,
    14,   16,   18,   20,   22,   24,   26,   28,   30,   32,   34,   36,   38,   40,   42,   44,
    46,   48,   50,   52,   54,   56,   58,   60,   62,   64,   66,   68,   70,   72,   74,   76,
    78,   80,   82,   84,   86,   88,   90,   92,   94,   96,   98,  100,  102,  104,  106,  108,
   110,  112,  114,  116,  118,  120,  122,  124,  126,  128,  130,  132,  134,  136,  138,  140,
   142,  144,  146,  148,  150,  152,  154,  156,  158,  160,  162,  164,  166,  168,  170,  172,
   174,  176,  178,  180,  182,  184,  186,  188,  190,  192,  194,  196,  198,  200,  202,  204,
   206,  208,  210,  212,  214,  216,  218,  220,  222,  224,  226,  228,  230,  232,  234,  236,
};

static char gray2_LUT[256] = {
    0,   1,   2,   4,   5,   7,   8,   9,  11,  12,  14,  15,  16,  18,  19,  21,
   22,  24,  25,  26,  28,  29,  31,  32,  33,  35,  36,  38,  39,  41,  42,  43,
   45,  46,  48,  49,  50,  52,  53,  55,  56,  57,  59,  60,  62,  63,  65,  66,
   67,  69,  70,  72,  73,  74,  76,  77,  79,  80,  82,  83,  84,  86,  87,  89,
   90,  91,  93,  94,  96,  97,  99, 100, 101, 103, 104, 106, 107, 108, 110, 111,
  113, 114, 115, 117, 118, 120, 121, 123, 124, 125, 127, 128, 130, 131, 132, 134,
  135, 137, 138, 140, 141, 142, 144, 145, 147, 148, 149, 151, 152, 154, 155, 156,
  158, 159, 161, 162, 164, 165, 166, 168, 169, 171, 172, 173, 175, 176, 178, 179,
  181, 182, 183, 185, 186, 188, 189, 190, 192, 193, 195, 196, 198, 199, 200, 202,
  203, 205, 206, 207, 209, 210, 212, 213, 214, 216, 217, 219, 220, 222, 223, 224,
  226, 227, 229, 230, 231, 233, 234, 236, 237, 239, 240, 241, 243, 244, 246, 247,
  248, 250, 251, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255
};

/*--------------------------------------------------------*/

int decode(FILE *fp, struct PICTURE *picture)
{
  int  x,y,i,r,b,g,gray;
  
  if (!(((picture->x == 192) && (picture->y == 128)) ||
	((picture->x == 384) && (picture->y == 256)) ||
	((picture->x == 768) && (picture->y == 512))))
    return(ERR_PICTURESIZE_INVALID);
  
  for (y = 0, i = 0; y < picture->y; y += 2) {
    fread(gray1,picture->x,1,fp);
    fread(gray2,picture->x,1,fp);
    fread(blue,picture->x/2,1,fp);
    if (1 != fread(red,picture->x/2,1,fp)) {
      return(ERR_UNEXPECTED_EOF); }

    for (x = 0; x < picture->x; x++) {
      gray = gray_LUT[gray1[x]];
      b    = gray + blue_LUT[blue[x >> 1]];
      r    = gray + red_LUT [red [x >> 1]];
      g    = (10*gray - b - 3*r) / 6;
      picture->data[i++] = (r & ~0xff) ? ((r < 0) ? 0 : 255 ) : r;
      picture->data[i++] = (g & ~0xff) ? ((g < 0) ? 0 : 255 ) : g;
      picture->data[i++] = (b & ~0xff) ? ((b < 0) ? 0 : 255 ) : b;
    }
    
    for (x = 0; x < picture->x; x++) {
      gray = gray_LUT[gray2[x]];
      b    = gray + blue_LUT[blue[x >> 1]];
      r    = gray + red_LUT [red [x >> 1]];
      g    = (10*gray - b - 3*r) / 6;
      picture->data[i++] = (r & ~0xff) ? ((r < 0) ? 0 : 255 ) : r;
      picture->data[i++] = (g & ~0xff) ? ((g < 0) ? 0 : 255 ) : g;
      picture->data[i++] = (b & ~0xff) ? ((b < 0) ? 0 : 255 ) : b;
    }
    
  }
  return(0);
}

/*--------------------------------------------------------*/

int decode_gray(FILE *fp, struct PICTURE *picture)
{
  int  x,y,i;
  
  if (!(((picture->x == 192) && (picture->y == 128)) ||
	((picture->x == 384) && (picture->y == 256)) ||
	((picture->x == 768) && (picture->y == 512))))
    return(ERR_PICTURESIZE_INVALID);

  for (y = 0, i = 0; y < picture->y; y += 2) {
    fread(gray1,picture->x,1,fp);
    fread(gray2,picture->x,1,fp);
    fread(blue,picture->x/2,1,fp);
    if (1 != fread(red,picture->x/2,1,fp)) {
      return(ERR_UNEXPECTED_EOF); }
    
    for (x = 0; x < picture->x; x++) {
      picture->data[i++] = gray2_LUT[gray1[x]];
    }
    
    for (x = 0; x < picture->x; x++) {
      picture->data[i++] = gray2_LUT[gray2[x]];
    }
    
  }
  return(0);
}

/*--------------------------------------------------------*/

int decode_32k(FILE *fp, struct PICTURE *picture)
{
  int             x,y,i,r,b,g,gray,p;
  unsigned short  *data;

  data = (short*)picture->data; /* 16-bit wide memory access for hicolor */
  if (!(((picture->x == 192) && (picture->y == 128)) ||
	((picture->x == 384) && (picture->y == 256)) ||
	((picture->x == 768) && (picture->y == 512))))
    return(ERR_PICTURESIZE_INVALID);

  for (y = 0, i = 0; y < picture->y; y += 2) {
    fread(gray1,picture->x,1,fp);
    fread(gray2,picture->x,1,fp);
    fread(blue,picture->x/2,1,fp);
    if (1 != fread(red,picture->x/2,1,fp)) {
      return(ERR_UNEXPECTED_EOF); }
    
    for (x = 0; x < picture->x; x++) {
      gray = gray_LUT[gray1[x]];
      b    = gray + blue_LUT[blue[x >> 1]];
      r    = gray + red_LUT [red [x >> 1]];
      g    = (10*gray - b - 3*r) / 6;
      p  = ((r & ~0xff) ? ((r < 0) ? 0 : 0xf8 ) : r & 0xf8) << 7;
      p |= ((g & ~0xff) ? ((g < 0) ? 0 : 0xf8 ) : g & 0xf8) << 2;
      p |= ((b & ~0xff) ? ((b < 0) ? 0 : 0xf8 ) : b & 0xf8) >> 3;
      data[i++] = p;
    }
    
    for (x = 0; x < picture->x; x++) {
      gray = gray_LUT[gray2[x]];
      b    = gray + blue_LUT[blue[x >> 1]];
      r    = gray + red_LUT [red [x >> 1]];
      g    = (10*gray - b - 3*r) / 6;
      p  = ((r & ~0xff) ? ((r < 0) ? 0 : 0xf8 ) : r & 0xf8) << 7;
      p |= ((g & ~0xff) ? ((g < 0) ? 0 : 0xf8 ) : g & 0xf8) << 2;
      p |= ((b & ~0xff) ? ((b < 0) ? 0 : 0xf8 ) : b & 0xf8) >> 3;
      data[i++] = p;
    }
    
  }
  return(0);
}

