#include <stdio.h>
#include <stdlib.h>

#include "picture.h"

#define ERR_UNEXPECTED_EOF         1
#define ERR_PICTURESIZE_INVALID    2
#define ERR_FORK                   3
#define ERR_PIPE                   4

int decode(FILE *fp, struct PICTURE *picture);
/*
Aufgabe: Decodieren eines PhotoCD-Bildes
Eingabe: - Filepointer mit ImagePac, zum Lesen ge"offnet, mit fseek auf Anfang
           der Bilddaten positioniert.
         - Pointer auf struct PICTURE, in dieser sind Hoehe und Breite des 
           Bildes eingetragen und ausreichend Platz allokiert.
Ausgabe: OK - in struct PICTURE die Bilddaten & return = 0
         ERROR - return = error code:
         error codes:
           1 - Lesefehler
           2 - Bildgr"o"se gibts nicht / kann nicht gelesen werden
*/

int decode_gray(FILE *fp, struct PICTURE *picture);
/*
 * The same for grayscaled images
 */

int decode_32k(FILE *fp, struct PICTURE *picture);
/*
 * the same for hicolor display's
 */
