/* main.c     main entrypoint
 *
 * Copyright 1991, Michael Westerhof, Sun Microsystems, Inc.
 * This software may be freely used, distributed, or modified, providing
 * this header is not removed.
 *
 */

#include "config.h"
#include "version.h"
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

jmp_buf restart_env;

void
main(argc, argv)
	int argc;
	char *argv[];
{
	if(setjmp(restart_env)==0){
		(void)signal(SIGHUP, hupper);
	}

	/* set up the handler for statistics reporting */
	(void)signal(SIGUSR1, usr1_handler);
	(void)signal(SIGINT, int_handler);
	(void)signal(SIGTERM, term_handler);

	/* Say hello to the world */
	greet_world();

	/* Test arguments */
	if(argc>2){
		(void)fprintf(stderr,"Usage: %s [<configuration-file>]\n",argv[0]);
		exit(1);
	}

	/* Initialize all routines */
	config_init();
	kiss_init();
	route_init();
	process_init();
	io_init();

	/* read config file */
	config_read(argv[1]);

	/* print the current config and route info */
	dump_config();
	dump_routes();
	dump_params();

	/* Open the IO stuff */
	io_open();

	/* and let the games begin */
	io_start();
}

void
greet_world()
{
	(void)printf("\nax25ip (PROTOTYPE) %s\n",VERS);
	(void)printf("Copyright 1991, Michael Westerhof, Sun Microsystems, Inc.\n\n");
	(void)fflush(stdout);
}

void
do_stats()
{
	int save_loglevel;

/* save the old loglevel, and force at least loglevel 1 */
	save_loglevel = loglevel;
	loglevel = 1;

	(void)printf("\nSIGUSR1 signal: statistics and configuration report\n");

	greet_world();

	dump_config();
	dump_routes();
	dump_params();

	(void)printf("\nInput stats:\n");
	(void)printf("KISS input packets:  %d\n",stats.kiss_in);
	(void)printf("           too big:  %d\n",stats.kiss_toobig);
	(void)printf("          bad type:  %d\n",stats.kiss_badtype);
	(void)printf("         too short:  %d\n",stats.kiss_tooshort);
	(void)printf("        not for me:  %d\n",stats.kiss_not_for_me);
	(void)printf("  I am destination:  %d\n",stats.kiss_i_am_dest);
	(void)printf("    no route found:  %d\n",stats.kiss_no_ip_addr);
	(void)printf("UDP  input packets:  %d\n",stats.udp_in);
	(void)printf("IP   input packets:  %d\n",stats.ip_in);
	(void)printf("   failed CRC test:  %d\n",stats.ip_failed_crc);
	(void)printf("         too short:  %d\n",stats.ip_tooshort);
	(void)printf("        not for me:  %d\n",stats.ip_not_for_me);
	(void)printf("  I am destination:  %d\n",stats.ip_i_am_dest);
	(void)printf("\nOutput stats:\n");
	(void)printf("KISS output packets: %d\n",stats.kiss_out);
	(void)printf("            beacons: %d\n",stats.kiss_beacon_outs);
	(void)printf("UDP  output packets: %d\n",stats.udp_out);
	(void)printf("IP   output packets: %d\n",stats.ip_out);
	(void)printf("\n");

	(void)fflush(stdout);

/* restore the old loglevel */
	loglevel = save_loglevel;
}

void
hupper()
{
	(void)printf("\nSIGHUP!\n");
	longjmp(restart_env, 1);
}

void
usr1_handler()
{
	(void)printf("\nSIGUSR1!\n");
	do_stats();
}

void
int_handler()
{
	(void)printf("\nSIGINT!\n");
	do_stats();
	exit(1);
}

void
term_handler()
{
	(void)printf("\nSIGTERM!\n");
	do_stats();
	exit(1);
}
