/* -*- Mode:Text -*- */
#ifndef lint
static char Rcs_Id[] =
    "$Id: xgets.c,v 1.12 91/07/11 19:52:32 geoff Exp $";
#endif

/*
 * Copyright 1987, 1988, 1989, by Geoff Kuenning, Manhattan Beach, CA
 * Permission for non-profit use is hereby granted.
 * All other rights reserved.
 * See "version.h" for a more complete copyright notice.
 */

/*
 * $Log:	xgets.c,v $
 * Revision 1.12  91/07/11  19:52:32  geoff
 * Remove the include of stdio.h, since ispell.h now does this.
 * 
 * Revision 1.11  90/12/31  00:59:39  geoff
 * Reformat to follow a consistent convention throughout ispell
 * 
 * Revision 1.10  89/04/28  01:18:12  geoff
 * Change Header to Id;  nobody cares about my pathnames.
 * 
 * Revision 1.9  88/12/26  02:35:01  geoff
 * Add a copyright notice.
 * 
 * Revision 1.8  88/11/25  19:55:11  geoff
 * Fix the declaration of strlen so it isn't declared as a static.
 * 
 * Revision 1.7  88/04/11  01:39:06  geoff
 * Fix xgets to work like fgets instead of gets.
 * 
 * Revision 1.6  87/09/30  23:32:25  geoff
 * Move a global to ispell.h.
 * 
 * Revision 1.5  87/09/03  19:31:21  geoff
 * Make sure gets is defined, even if stdio muffs it
 * 
 * Revision 1.4  87/06/07  14:07:53  geoff
 * Integrate Johan Widen's bug fixes into the main branch
 * 
 * Revision 1.3  87/05/25  21:25:58  geoff
 * Make it compatible with config.h and with my flag variable names.
 * 
 * Revision 1.2  87/05/25  19:39:08  geoff
 * Add RCS ID keywords
 * 
 */

#include "config.h"
#include "ispell.h"

#ifndef MAXINCLUDEFILES
#define MAXINCLUDEFILES	1	/* maximum number of new files in stack */
#endif

/*
 * xgets () acts just like gets () except that if a line matches
 * "&Include_File&<something>" xgets () will start reading from the
 * file <something>.
 *
 *  Andrew Vignaux -- andrew@vuwcomp  Fri May  8 16:40:23 NZST 1987
 * modified
 *  Mark Davies -- mark@vuwcomp  Mon May 11 22:38:10 NZST 1987
 */

extern char *	fgets ();

char * xgets (str, size, stream)
    char		str[];
    int			size;
    FILE *		stream;
    {
#if MAXINCLUDEFILES == 0
    return fgets (str, size, stream);
#else
    static char *	Include_File = DEFINCSTR;
    static int		Include_Len = 0;
    extern int		strlen ();
    static FILE *	F[MAXINCLUDEFILES+1];
    static FILE **	current_F = F;
    char *		s = str;
    int			c;

    /* read the environment variable if we havent already */
    if (Include_Len == 0)
	{
	char *		env_variable;
	extern char *	getenv ();

	if ((env_variable = getenv (INCSTRVAR)) != NULL)
	    Include_File = env_variable;
	Include_Len = strlen (Include_File);

	/* initialise the file stack */
	*current_F = stream;
	}

    while (1)
	{
        if ((s - str) + 1 < size
          &&  (c = getc (*current_F)) != EOF
          &&  c != '\n')
	    {
	    *s++ = c;
	    continue;
	    }
	*s = '\0';		/* end of line */
	if (c == EOF)
	    {
	    if (current_F == F) /* if end of standard input */
		{
		if (s == str)
		    return (NULL);
		}
	    else
		{
	        (void) fclose (*(current_F--));
	      	if (s == str) continue;
		}
	    }

	if (incfileflag != 0
	  &&  strncmp (str, Include_File, Include_Len) == 0)
	    {
	    char *	file_name = str + Include_Len;

	    if (current_F - F < MAXINCLUDEFILES  &&  strlen (file_name) > 0)
		{
		FILE *	f;

		if (f = fopen (file_name, "r"))
		    *(++current_F) = f;
		}
	    s = str;
	    continue;
	    }
	break;
	}
    
    return (str);
#endif
    }
