/*
 * client.h
 *
 * (c)19/12/1993 Stuart N. John
 *
 */

#ifndef CLIENT_H
#define CLIENT_H


/* function prototypes */

extern int client_get_service(char *server);
/*
 * Opens connection to server
 * Returns -1 on failure; an identifier for the client (>= 0) on success
 */


extern Glove_t *client_get_record(int id);
/*
 * If PGCOMMS_TWOWAY is set, sends PG_GET_GLOVEDATA message to server, blocks waiting
 * for server reply
 * Returns NULL on error; pointer to glove data on success
 * If PGCOMMS_TWOWAY is not set, this just blocks waiting for the next data record
 */


extern int client_set_datalist(int id, int datalist);
/*
 * Sends PG_SET_DATALIST message & datalist to server, reads datalist from server
 * Returns -1 on error; 0 on success
 */


extern int client_get_datalist(int id);
/*
 * Sends PG_GET_DATALIST message to server, reads datalist from server
 * Returns -1 on error; 0 on success
 */


extern int client_set_comms(int id, int mode);
/*
 * Sends PG_SET_COMMS message & mode to server, reads mode from server
 * Returns -1 on error; 0 on success
 */


extern int client_get_comms(int id);
/*
 * Sends PG_GET_COMMS message to server, reads flags from server
 * Returns -1 on error; 0 on success
 */


extern int client_set_filter(int id, int mode);
/*
 * Sends PG_SET_FILTER message & mode to server, reads mode from server
 * Returns -1 on error; 0 on success
 */


extern int client_get_filter(int id);
/*
 * Sends PG_GET_FILTER message to server, reads mode from server
 * Returns -1 on error; 0 on success
 */


extern int client_reset(int id);
/*
 * Sends PG_RESET message to server, blocks 3 seconds, reads config from server
 * Returns -1 on error; 0 on success
 */


extern int client_quit(int id);
/*
 * Sends PG_QUIT message to server, closes the connection
 * Returns 0
 */

#endif
