/*
 * feature.h
 *
 * (c)10/3/1994 Stuart N. John
 *
 */

#ifndef FEATURE_H
#define FEATURE_H


typedef struct
{
  double x, y, z;
} Vector_t;

typedef struct
{
  Vector_t min;
  Vector_t max;
} Box_t;


/* continuous features */

extern void path_segment(Glove_t *g, Glove_t *lastg, Vector_t *v);
extern double length_path_segment(Vector_t *v);
extern void norm_path_segment(Vector_t *v, double length, Vector_t *nv);
extern void segment_speed(Vector_t *v, Glove_t *g, Vector_t *sv);
extern double linear_speed(double length, Glove_t *g);
extern void norm_cross_product(Vector_t *nv, Vector_t *lastnv, Vector_t *ncp);
extern double norm_dot_product(Vector_t *nv, Vector_t *lastnv);
extern postureData_t *hand_posture(Glove_t *g);

/* total features */

extern double bounding_box(Vector_t *minv, Vector_t *maxv, Box_t *box);

#endif
