/* filter.c
 *
 * (c)19/12/1993 Stuart N. John
 *
 *
 * History:
 *
 *   19-12-1993 - Created module
 *
 */

#include "filter.h"


/* arbitrary error percentage */

#define Alpha 0.25


/* filter co-efficients */

static float alpha = Alpha;
static float beta = Alpha * Alpha / (2.0 - Alpha);


/* prototypes */

static int alpha_beta(char *raw, char *s_est, char *v_est);


/* global functions */

int filter(char *x, char *y, char *z)
{
  static char xs_est = 0, xv_est = 0;
  static char ys_est = 0, yv_est = 0;
  static char zs_est = 0, zv_est = 0;

  alpha_beta(x, &xs_est, &xv_est);
  alpha_beta(y, &ys_est, &yv_est);
  alpha_beta(z, &zs_est, &zv_est);
}


/* static functions */

static int alpha_beta(char *raw, char *s_est, char *v_est)
{
  char s_pred, error;

  /* The alpha-beta algorithm (with T absorbed into v) */

  /* predict the new position */
  s_pred = *s_est + *v_est;

  /* compute the measurement error */
  error = *raw - s_pred;

  /* estimate the true position & velocity */
  *s_est = s_pred + alpha * error;
  *v_est += (beta * error);

  *raw = *s_est;
}
