/*
 * glove.h
 *
 * (c)3/1/1994 Stuart N. John
 *
 */

#ifndef GLOVE_H
#define GLOVE_H


/* enumerations (to hide bit and flex values) */

typedef enum { Thumb, Index, Middle, Ring } Fingers;
typedef enum { Open, Semi_open, Semi_closed, Closed } Flex;


typedef struct
{
  Flex thumb, index, middle, ring;
} Fingers_t;

typedef struct
{
  int       x, y, z;   /* 3-space co-ordinates */
  int       rotation;  /* wrist rotation       */
  Fingers_t fingers;   /* finger flex values   */
  int       key;       /* keypad               */
  int       tick;      /* tick diff value (us) */
} Glove_t;


/* client functions to retrieve massaged glove data */

extern int  getX(Glove_t *glove);
extern int  getY(Glove_t *glove);
extern int  getZ(Glove_t *glove);
extern int  getRotation(Glove_t *glove);
extern Flex getFinger(Glove_t *glove, Fingers finger);
extern Flex getThumb(Glove_t *glove);
extern Flex getIndex(Glove_t *glove);
extern Flex getMiddle(Glove_t *glove);
extern Flex getRing(Glove_t *glove);
extern int  getKey(Glove_t *glove);
extern int  getTime(Glove_t *glove);


/* client functions to store raw character glove data */

extern void setX(Glove_t *glove, char x);
extern void setY(Glove_t *glove, char y);
extern void setZ(Glove_t *glove, char z);
extern void setRotation(Glove_t *glove, char rot);
extern void setFingers(Glove_t *glove, u_char fingers);
extern void setKey(Glove_t *glove, u_char key);
extern void setTime(Glove_t *glove, char tick);

#endif
