/* message.c
 *
 * (c)6/1/1994 Stuart N. John
 *
 *
 * History:
 *
 *   6-1-1994 - Created module
 *
 */

#include <sys/file.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "powerglove.h"
#include "mode.h"
#include "message.h"


int send_message(Msg_id id, int socket, Mode_t *mode, char *data)
{
  static char buffer[MAX(G_BYTES, M_BYTES) + 1];  /* temp input buffer       */
  char        *buf = buffer;  /* pointer to input buffer */
  int         count = 0;      /* no. of bytes in message */

  /* message id */

  *buf++ = (char) id;
  ++count;

  /* message body */

  switch(id)
  {
    case PG_SET_CONFIG:
    case PG_REPLY_CONFIG:

           *buf++ = mode->datalist;
           *buf++ = mode->comms;
           *buf   = mode->filter;
           count += M_BYTES;
           break;

    case PG_SET_DATALIST:
    case PG_REPLY_DATALIST:

           *buf = mode->datalist;
#ifdef DEBUGMSG
           fprintf(stderr, "message: send datalist %x\n", *buf);
#endif
           ++count;
           break;

    case PG_SET_COMMS:
    case PG_REPLY_COMMS:

           *buf = mode->comms;
#ifdef DEBUGMSG
           fprintf(stderr, "message: send comms %x\n", *buf);
#endif
           ++count;
           break;

    case PG_SET_FILTER:
    case PG_REPLY_FILTER:

           *buf = mode->filter;
#ifdef DEBUGMSG
           fprintf(stderr, "message: send filter %x\n", *buf);
#endif
           ++count;
           break;

    case PG_REPLY_GLOVEDATA:

           bcopy(data, buf, G_BYTES);
           count += G_BYTES;
           break;

    default:

           break;
  }

  if (send(socket, buffer, count, 0) < 0)
    return -1;

#ifdef DEBUGMSG
  fprintf(stderr, "message: sent message %d (%d bytes) on socket %d\n", id, count, socket);
#endif

  return 0;
}


int get_message(int socket, Mode_t *mode, char *data)
{
  static char buffer[MAX(G_BYTES, M_BYTES) + 1];  /* temp input buffer       */
  char        *buf = buffer;  /* pointer to input buffer         */
  int         id;             /* message id                      */
  int         count = 0;      /* number of bytes in message body */

  /* look for a message id byte */

  while (recv(socket, buf, 1, 0) < 0 && errno == EWOULDBLOCK);

  /* if the socket dies, return an error */

  if (errno == ECONNRESET || errno == EPIPE)
    return -1;

  /* check for invalid message id */

  if (*buf < PG_GET_GLOVEDATA || *buf > PG_REPLY_FILTER)
    return -1;

  /* store message id */

  id = (int) *buf;

#ifdef DEBUGMSG
  fprintf(stderr, "message: got message %d from socket %d\n", id, socket);
#endif

  /* message body */

  switch(id)
  {
    case PG_SET_CONFIG:
    case PG_REPLY_CONFIG:

           count = M_BYTES;
           break;

    case PG_SET_DATALIST:
    case PG_SET_COMMS:
    case PG_SET_FILTER:
    case PG_REPLY_DATALIST:
    case PG_REPLY_COMMS:
    case PG_REPLY_FILTER:

           count = 1;
           break;

    case PG_REPLY_GLOVEDATA:

           count = G_BYTES;  /* size of glove data array */
           break;

    default:

           break;
  }

  /* read message body (do timeouts for endless loops ???) */

  if (count > 0)
    while (recv(socket, &buffer, count, 0) < 0 && errno == EWOULDBLOCK);

#ifdef DEBUGMSG
  fprintf(stderr, "message: message length %d\n", count + 1);
#endif

  /* act on message body data according to message id */

  switch(id)
  {
    case PG_SET_CONFIG:
    case PG_REPLY_CONFIG:

           mode->datalist = *buf++;
           mode->comms    = *buf++;
           mode->filter   = *buf;
           break;

    case PG_SET_DATALIST:
    case PG_REPLY_DATALIST:

           mode->datalist = *buf;
#ifdef DEBUGMSG
           fprintf(stderr, "message: set datalist to %x\n", mode->datalist);
#endif
           break;

    case PG_SET_COMMS:
    case PG_REPLY_COMMS:

           mode->comms = *buf;
#ifdef DEBUGMSG
           fprintf(stderr, "message: set comms to %x\n", mode->comms);
#endif
           break;

    case PG_SET_FILTER:
    case PG_REPLY_FILTER:

           mode->filter = *buf;
#ifdef DEBUGMSG
           fprintf(stderr, "message: set filter to %x\n", mode->filter);
#endif
           break;

    case PG_REPLY_GLOVEDATA:

           /* if we're waiting for a mode flag to come back, and
              the server has pre-empted it with a ONEWAY data
              message, then we won't get what we were expecting,
              and a NULL data pointer will crash the program */
              
           if (data)
             bcopy(buffer, data, G_BYTES);  /* size of glove data array */

           break;

    default:

           break;
  }

  return id;
}
