#include <linux/fs.h>
#include <X11/Xlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glove.h"
#include "posture.h"
#include "filter.h"

Display *mydisplay;
Window mywindow, rootwin, childwin;
int myscreen;
unsigned long black, white;
XEvent myevent;
char text[10];
int width, height, centrex, centrey, lastx, lasty, lastz = 0, rec;
char *message = " GLOVE (C) 26/11/1993 STU"; 
GC mygc;
Colormap cmap;
XColor color;
int box = 90;
int flag = 1;
long int col = -1;

int fd;
signed char pos[4];
unsigned char bits[2];
char buffer[] = {'0', '0', '0', '0', '0', '0', '0', '0', '\0'};
postureData_t *posture;


/* prototypes */
char *binary(unsigned char num, char *buf);

main()
{
   mydisplay = XOpenDisplay("");                                      /* connect to server */

   if(mydisplay == NULL)
   {
      fprintf(stderr, "cannot connect to X server !\n");
      exit(1);
   }
   printf("connected to X server...\n");

   fd = open("/dev/cua1", O_RDONLY);
   fprintf(stderr, "opened (modem) device on COM:2\n\n");

   myscreen = DefaultScreen(mydisplay);                               /* get a screen */

   white = WhitePixel(mydisplay, myscreen);                           /* look up colours */
   black = BlackPixel(mydisplay, myscreen);

   printf("got foreground/background...\n");

   width = DisplayWidth(mydisplay, myscreen) / 2;                     /* get width and height of root window */
   height = DisplayHeight(mydisplay, myscreen) / 2;
   printf("got screen width/height (%d/%d)...\n",width,height);
                                                                      /* create a window at based on screen size */
   mywindow = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
                                  0, 0, width-4, height-4, 2, white, black);
   
   if(mywindow == BadAlloc)
   {
      fprintf(stderr, "cannot open window !\n");
      exit(1);
   }

   mygc = XCreateGC(mydisplay, mywindow, 0, 0);                       /* create a GC */
   printf("created GC...\n");

   cmap = DefaultColormap(mydisplay, myscreen);                       /* make colour map */                                          
   XSetForeground(mydisplay, mygc, white);                     
   XSetBackground(mydisplay, mygc, black);
   printf("set foreground/background colours...\n");

   XSelectInput(mydisplay, mywindow, ExposureMask);                   /* get events */

   XMapRaised(mydisplay, mywindow);                                   /* pop this window up on the screen */
   printf("popped window...\n");

   XNextEvent(mydisplay, &myevent);
   printf("window now displayed...\n");

   XDrawImageString(mydisplay, mywindow, mygc, ((width-4)/2)-(((strlen(message)*8)/2)), height-30, message, strlen(message));

   XFlush(mydisplay);
   printf("flushing X server buffer...\n");

   pos[0] = pos[1] = pos[2] = 0;
   centrex = width/2;
   centrey = height/2;

   create_posture_table();
   col = white;

   for(;;)
   {
     lastx = pos[0];
     lasty = pos[1];
     lastz = pos[2];

     read(fd, bits, 1);                 /* header */
     if (*bits != 0xA0)
     {
       continue;
     }

     read(fd, &pos[0], 1);                  /* x pos */
     fprintf(stderr, "x:%4d ", pos[0]);
     read(fd, &pos[1], 1);                  /* y pos */
     fprintf(stderr, "y:%4d ", pos[1]);
     read(fd, &pos[2], 1);                  /* z pos */
     fprintf(stderr, "z:%4d ", pos[2]);

     read(fd, &pos[3], 1);                  /* rotation */
     fprintf(stderr, "r:%2d ", pos[3]);

     read(fd, &bits[0], 1);                 /* fingers */
     fprintf(stderr, "f:%s(%2x) ", binary(bits[0], buffer), bits[0]);

     if (pos[3] < 0)
       pos[3] = 0;
     if (pos[3] > 11)
       pos[3] = 11;

     filter(&pos[0], &pos[1], &pos[2]);

     posture = classify_posture(bits[0]>>6&3, bits[0]>>4&3, bits[0]>>2&3, bits[0]&3, pos[3]);
     if (posture)
       fprintf(stderr, "%s [%d] ", posture->name, posture->id);
     else
       fprintf(stderr, "(none) ");

     if (posture->id == 10)
       flag = FALSE;
     else
       flag = TRUE;

     if (posture->id == 9)
       break;

     if (posture->id == 5)
       XClearWindow(mydisplay, mywindow);

/*
     if (posture->id == 8)
       XSetForeground(mydisplay, mygc, ++col);                     
*/

     read(fd, &bits[1], 1);                 /* keys */
     fprintf(stderr, "k:%2x ", bits[1]);
     if (bits[1] == 0x80)
       break;
/*
     if (bits[1] == 0xa)
       flag = !flag;
*/
     if (bits[1] == 0xb)
       XClearWindow(mydisplay, mywindow);

     fprintf(stderr, "\r");

     if(flag)
     {
       rec = box+lastz*2;
       rec -= rec/2;
       XSetForeground(mydisplay, mygc, black);                     
       XDrawRectangle(mydisplay, mywindow, mygc, centrex+lastx*2, centrey-lasty*2, rec, rec);            
     }
     rec = box+pos[2]*2;
     rec -= rec/2;
     XSetForeground(mydisplay, mygc, col);
     XDrawRectangle(mydisplay, mywindow, mygc, centrex+pos[0]*2, centrey-pos[1]*2, rec, rec);            
     XFlush(mydisplay);
   }

   XDestroyWindow(mydisplay, mywindow);
   printf("\nclosing window...\n");

   XCloseDisplay(mydisplay);
   printf("closing display...\n");

   close(fd);
   fprintf(stderr, "\n\nbye...\n");

   printf("exit.\n");
   exit(0);
}

char *binary(unsigned char bits, char *buffer)
{
  int k;
  char *buf = buffer;

  for(k=0; k <= 7; k++) *buf++ = ((bits << k) & 0x80) ? '1' : '0';

  return buffer;
}
