#
| complex_angle.mu
#
MIN_PHI := float(-PI/2):
MAX_PHI := float(PI/2):
EPS     := 0.0001:

complex_surf := proc(re, im)
begin
    1/((u+I*v)^3+1):
end_proc:

cfun_surf_3d := proc(x_coord, y_coord, z_coord, u_val, v_val)
local erg, real, imag, phi;
begin
    erg := complex_surf(x_coord, y_coord):
    real := op(erg, 1):
    imag := op(erg, 2):
    if abs(real) > EPS then
        phi := atan(imag/abs(real)):
    else
        phi := sign(imag)*PI/2:
    end_if:
    value := (phi - MIN_PHI)/(MAX_PHI - MIN_PHI):
    
    [1-value, 0.5, value]:
end_proc:

plot3d(Axes = Box, Ticks = 0, Scaling = UnConstrained,
       [Mode = Surface,
             [u, v, min(abs(complex_surf(u, v)), 2.0)],
             u = [-2, 2], v = [-2, 2], Grid = [50, 50],
             Style = [ColorPatches, AndMesh],
             Color = [Function, cfun_surf_3d]
       ]);
